/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.inventory.sorting.mixin;

import com.devnemo.nemos.inventory.sorting.config.DefaultConfigValues;
import com.devnemo.nemos.inventory.sorting.config.model.ComponentConfig;
import com.devnemo.nemos.inventory.sorting.config.service.ConfigService;
import com.devnemo.nemos.inventory.sorting.factory.ButtonCreator;
import com.devnemo.nemos.inventory.sorting.factory.DropAllButtonFactory;
import com.devnemo.nemos.inventory.sorting.factory.MoveAllButtonFactory;
import com.devnemo.nemos.inventory.sorting.factory.MoveSameButtonFactory;
import com.devnemo.nemos.inventory.sorting.factory.SortButtonFactory;
import com.devnemo.nemos.inventory.sorting.gui.components.buttons.AbstractInventoryButton;
import com.progwml6.ironchest.client.screen.IronChestScreen;
import com.progwml6.ironchest.common.block.IronChestsTypes;
import com.progwml6.ironchest.common.inventory.IronChestMenu;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={IronChestScreen.class})
public abstract class NeoForgeIronChestScreenMixin
extends AbstractContainerScreen<IronChestMenu> {
    @Unique
    private int nemosInventorySortingNeoForge$inventoryEndIndex;
    @Unique
    private int nemosInventorySortingNeoForge$containerSize;
    @Unique
    private int nemosInventorySorting$latestInventoryXOffset = 0;
    @Unique
    private int nemosInventorySorting$latestStorageContainerXOffset = 0;
    @Unique
    private final ConfigService nemosInventorySortingNeoForge$configService = ConfigService.getInstance();
    @Unique
    private final List<AbstractWidget> nemosInventorySorting$widgets = new ArrayList<AbstractWidget>();

    public NeoForgeIronChestScreenMixin(IronChestMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    public void init() {
        super.init();
        this.nemosInventorySortingNeoForge$inventoryEndIndex = ((IronChestMenu)this.getMenu()).slots.size() - 9;
        this.nemosInventorySortingNeoForge$containerSize = this.nemosInventorySortingNeoForge$inventoryEndIndex - 27;
        this.nemosInventorySorting$latestStorageContainerXOffset = this.imageWidth - 8;
        this.nemosInventorySorting$latestInventoryXOffset = this.imageWidth - 8;
        if (this.nemosInventorySorting$shouldHaveStorageContainerButtons()) {
            this.nemosInventorySorting$initStorageContainerButtons();
        }
        for (AbstractWidget widget : this.nemosInventorySorting$widgets) {
            this.addRenderableWidget((GuiEventListener)widget);
        }
    }

    public boolean keyPressed(@NotNull KeyEvent keyEvent) {
        for (AbstractWidget widget : this.nemosInventorySorting$widgets) {
            if (!widget.keyPressed(keyEvent)) continue;
            return true;
        }
        return super.keyPressed(keyEvent);
    }

    public boolean keyReleased(@NotNull KeyEvent keyEvent) {
        for (AbstractWidget widget : this.nemosInventorySorting$widgets) {
            if (!widget.keyReleased(keyEvent)) continue;
            return true;
        }
        return super.keyReleased(keyEvent);
    }

    public boolean mouseClicked(@NotNull MouseButtonEvent mouseButtonEvent, boolean bl) {
        for (AbstractWidget widget : this.nemosInventorySorting$widgets) {
            if (!widget.mouseClicked(mouseButtonEvent, bl)) continue;
            return true;
        }
        return super.mouseClicked(mouseButtonEvent, bl);
    }

    protected void clearWidgets() {
        this.nemosInventorySorting$widgets.clear();
        super.clearWidgets();
    }

    @Unique
    private boolean nemosInventorySorting$shouldHaveStorageContainerButtons() {
        IronChestMenu ironChestMenu;
        IronChestMenu menu = (IronChestMenu)this.getMenu();
        return menu instanceof IronChestMenu && (ironChestMenu = menu).getChestType() != IronChestsTypes.DIRT;
    }

    @Unique
    private void nemosInventorySorting$initStorageContainerButtons() {
        SortButtonFactory sortButtonFactory = SortButtonFactory.getInstance();
        DropAllButtonFactory dropAllButtonFactory = DropAllButtonFactory.getInstance();
        MoveSameButtonFactory moveSameButtonFactory = MoveSameButtonFactory.getInstance();
        MoveAllButtonFactory moveAllButtonFactory = MoveAllButtonFactory.getInstance();
        List<ComponentConfig> configs = this.nemosInventorySortingNeoForge$configService.readOrGetDefaultIronChestComponentConfigs();
        int yOffset = this.imageHeight - 96;
        this.nemosInventorySorting$createButtonForContainer(configs, DefaultConfigValues.DROP_ALL_STORAGE_CONTAINER, dropAllButtonFactory, DefaultConfigValues.Y_OFFSET_CONTAINER);
        this.nemosInventorySorting$createButtonForContainer(configs, DefaultConfigValues.MOVE_ALL_STORAGE_CONTAINER, moveAllButtonFactory, DefaultConfigValues.Y_OFFSET_CONTAINER);
        this.nemosInventorySorting$createButtonForContainer(configs, DefaultConfigValues.MOVE_SAME_STORAGE_CONTAINER, moveSameButtonFactory, DefaultConfigValues.Y_OFFSET_CONTAINER);
        this.nemosInventorySorting$createButtonForContainer(configs, DefaultConfigValues.SORT_STORAGE_CONTAINER, sortButtonFactory, DefaultConfigValues.Y_OFFSET_CONTAINER);
        this.nemosInventorySorting$createButtonForInventory(configs, DefaultConfigValues.DROP_ALL_STORAGE_CONTAINER_INVENTORY, dropAllButtonFactory, yOffset);
        this.nemosInventorySorting$createButtonForInventory(configs, DefaultConfigValues.MOVE_ALL_STORAGE_CONTAINER_INVENTORY, moveAllButtonFactory, yOffset);
        this.nemosInventorySorting$createButtonForInventory(configs, DefaultConfigValues.MOVE_SAME_STORAGE_CONTAINER_INVENTORY, moveSameButtonFactory, yOffset);
        this.nemosInventorySorting$createButtonForInventory(configs, DefaultConfigValues.SORT_STORAGE_CONTAINER_INVENTORY, sortButtonFactory, yOffset);
    }

    @Unique
    private void nemosInventorySorting$createButtonForContainer(List<ComponentConfig> configs, String componentName, ButtonCreator buttonCreator, int defaultYOffset) {
        Optional<ComponentConfig> optionalComponentConfig = this.nemosInventorySortingNeoForge$configService.getOrDefaultComponentConfig(configs, componentName);
        if (optionalComponentConfig.isEmpty()) {
            return;
        }
        ComponentConfig config = optionalComponentConfig.get();
        if (!config.isEnabled()) {
            return;
        }
        int width = config.width();
        int xOffset = config.xOffset() != null ? config.xOffset() : this.nemosInventorySorting$latestStorageContainerXOffset - width - 7;
        int yOffset = config.yOffset() != null ? config.yOffset() : defaultYOffset;
        this.nemosInventorySorting$latestStorageContainerXOffset = xOffset;
        this.nemosInventorySorting$createContainerButton(buttonCreator, xOffset, yOffset, width, config.height());
    }

    @Unique
    private void nemosInventorySorting$createButtonForInventory(List<ComponentConfig> configs, String componentName, ButtonCreator buttonCreator, int defaultYOffset) {
        Optional<ComponentConfig> optionalComponentConfig = this.nemosInventorySortingNeoForge$configService.getOrDefaultComponentConfig(configs, componentName);
        if (optionalComponentConfig.isEmpty()) {
            return;
        }
        ComponentConfig config = optionalComponentConfig.get();
        if (!config.isEnabled()) {
            return;
        }
        int width = config.width();
        int xOffset = config.xOffset() != null ? config.xOffset() : this.nemosInventorySorting$latestInventoryXOffset - width - 7;
        int yOffset = config.yOffset() != null ? config.yOffset() : defaultYOffset;
        this.nemosInventorySorting$latestInventoryXOffset = xOffset;
        this.nemosInventorySorting$createInventoryButton(buttonCreator, xOffset, yOffset, width, config.height());
    }

    @Unique
    private void nemosInventorySorting$createContainerButton(ButtonCreator buttonCreator, int xOffset, int yOffset, int width, int height) {
        this.nemosInventorySorting$createButton(buttonCreator, 0, this.nemosInventorySortingNeoForge$containerSize, xOffset, yOffset, width, height, false);
    }

    @Unique
    private void nemosInventorySorting$createInventoryButton(ButtonCreator buttonCreator, int xOffset, int yOffset, int width, int height) {
        this.nemosInventorySorting$createButton(buttonCreator, this.nemosInventorySortingNeoForge$containerSize, this.nemosInventorySortingNeoForge$inventoryEndIndex, xOffset, yOffset, width, height, true);
    }

    @Unique
    private void nemosInventorySorting$createButton(ButtonCreator buttonCreator, int startIndex, int endIndex, int xOffset, int yOffset, int width, int height, boolean isInventoryButton) {
        AbstractInventoryButton sortButton = buttonCreator.createButton(startIndex, endIndex, this.leftPos, this.topPos, xOffset, yOffset, width, height, this.getMenu(), isInventoryButton);
        this.nemosInventorySorting$widgets.add(sortButton);
    }
}

