/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.inventory.sorting.gui.components.buttons;

import com.nemonotfound.nemos.inventory.sorting.client.InventorySortingKeyMappings;
import com.nemonotfound.nemos.inventory.sorting.gui.components.buttons.AbstractInventoryButton;
import com.nemonotfound.nemos.inventory.sorting.service.InventoryService;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class SortButton
extends AbstractInventoryButton {
    private final ResourceLocation buttonTexture = ResourceLocation.fromNamespaceAndPath((String)"nemos_inventory_sorting", (String)"sort_button");
    private final ResourceLocation buttonHoverTexture = ResourceLocation.fromNamespaceAndPath((String)"nemos_inventory_sorting", (String)"sort_button_highlighted");
    private final InventoryService inventoryService = InventoryService.getInstance();

    public SortButton(AbstractInventoryButton.Builder<SortButton> builder) {
        super(builder);
    }

    @Override
    protected ResourceLocation getButtonHoverTexture() {
        return this.buttonHoverTexture;
    }

    @Override
    protected ResourceLocation getButtonTexture() {
        return this.buttonTexture;
    }

    @Override
    public void onClick(@NotNull MouseButtonEvent mouseButtonEvent, boolean isDoubleClick) {
        this.inventoryService.handleSorting(this.menu, this.startIndex, this.currentEndIndex);
    }

    @Override
    protected KeyMapping getKeyMapping() {
        if (this.isInventoryButton) {
            return InventorySortingKeyMappings.SORT_INVENTORY.get();
        }
        return InventorySortingKeyMappings.SORT.get();
    }
}

