/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.inventory.sorting.gui.components.buttons;

import com.devnemo.nemos.inventory.sorting.config.model.FilterConfig;
import com.devnemo.nemos.inventory.sorting.gui.components.RecipeBookUpdatable;
import java.util.Arrays;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractFilterToggleButton
extends AbstractWidget
implements RecipeBookUpdatable {
    private final int xOffset;
    protected final FilterConfig filterConfig;

    public AbstractFilterToggleButton(Builder<? extends AbstractFilterToggleButton> builder) {
        super(builder.x.intValue(), builder.y.intValue(), builder.width.intValue(), builder.height.intValue(), builder.buttonName);
        this.xOffset = builder.xOffset;
        this.filterConfig = builder.filterConfig;
    }

    protected void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        ResourceLocation texture = this.filterConfig.isFilterPersistent() ? (this.isHovered() ? this.getToggleOnHoverTexture() : this.getToggleOnTexture()) : (this.isHovered() ? this.getToggleOffHoverTexture() : this.getToggleOffTexture());
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, texture, this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    @Override
    public void updateXPosition(int leftPos) {
        this.setX(leftPos + this.xOffset);
    }

    protected abstract ResourceLocation getToggleOffTexture();

    protected abstract ResourceLocation getToggleOnTexture();

    protected abstract ResourceLocation getToggleOffHoverTexture();

    protected abstract ResourceLocation getToggleOnHoverTexture();

    protected abstract void setTooltip();

    public abstract void onClick(@NotNull MouseButtonEvent var1, boolean var2);

    public boolean keyPressed(@NotNull KeyEvent keyEvent) {
        Minecraft minecraft = Minecraft.getInstance();
        boolean isKeyPressed = Arrays.stream(minecraft.options.keyMappings).filter(keyMapping -> keyMapping.same(this.getKeyMapping())).anyMatch(keyMapping -> keyMapping.matches(keyEvent));
        if (!isKeyPressed) {
            return super.keyPressed(keyEvent);
        }
        this.playDownSound(minecraft.getSoundManager());
        this.onClick(new MouseButtonEvent(0.0, 0.0, new MouseButtonInfo(0, 0)), false);
        return true;
    }

    public boolean mouseClicked(@NotNull MouseButtonEvent mouseButtonEvent, boolean bl) {
        Minecraft minecraft = Minecraft.getInstance();
        boolean isKeyPressed = Arrays.stream(minecraft.options.keyMappings).filter(keyMapping -> keyMapping.same(this.getKeyMapping())).anyMatch(keyMapping -> keyMapping.matchesMouse(mouseButtonEvent));
        if (!isKeyPressed) {
            return super.mouseClicked(mouseButtonEvent, bl);
        }
        this.playDownSound(minecraft.getSoundManager());
        this.onClick(mouseButtonEvent, bl);
        return true;
    }

    protected abstract KeyMapping getKeyMapping();

    protected void updateWidgetNarration(@NotNull NarrationElementOutput narrationElementOutput) {
    }

    public static class Builder<T extends AbstractFilterToggleButton> {
        private Integer x;
        private Integer y;
        private Integer xOffset;
        private Integer width;
        private Integer height;
        private Component buttonName;
        private FilterConfig filterConfig;
        private final Class<T> clazz;

        public Builder(Class<T> clazz) {
            this.clazz = clazz;
        }

        public Builder<T> x(int x) {
            this.x = x;
            return this;
        }

        public Builder<T> y(int y) {
            this.y = y;
            return this;
        }

        public Builder<T> xOffset(int xOffset) {
            this.xOffset = xOffset;
            return this;
        }

        public Builder<T> width(int width) {
            this.width = width;
            return this;
        }

        public Builder<T> height(int height) {
            this.height = height;
            return this;
        }

        public Builder<T> buttonName(Component buttonName) {
            this.buttonName = buttonName;
            return this;
        }

        public Builder<T> filterConfig(FilterConfig filterConfig) {
            this.filterConfig = filterConfig;
            return this;
        }

        public T build() {
            this.checkRequiredFields();
            try {
                return (T)((AbstractFilterToggleButton)this.clazz.getDeclaredConstructor(Builder.class).newInstance(this));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create instance of " + this.clazz.getName(), e);
            }
        }

        private void checkRequiredFields() {
            if (this.x == null || this.y == null || this.xOffset == null || this.width == null || this.height == null || this.buttonName == null || this.filterConfig == null) {
                throw new IllegalArgumentException("Not all fields were set!");
            }
        }
    }
}

