/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.inventory.sorting.gui.components.buttons;

import com.devnemo.nemos.inventory.sorting.client.InventorySortingKeyMappings;
import com.devnemo.nemos.inventory.sorting.gui.components.buttons.AbstractInventoryButton;
import com.devnemo.nemos.inventory.sorting.gui.components.buttons.AbstractSingleClickButton;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

public class MoveSameButton
extends AbstractSingleClickButton<MoveSameButton> {
    private final ResourceLocation buttonTexture = ResourceLocation.fromNamespaceAndPath((String)"nemos_inventory_sorting", (String)"move_same_button");
    private final ResourceLocation buttonHoverTexture = ResourceLocation.fromNamespaceAndPath((String)"nemos_inventory_sorting", (String)"move_same_button_highlighted");

    public MoveSameButton(AbstractInventoryButton.Builder<MoveSameButton> builder) {
        super(builder);
    }

    @Override
    protected ResourceLocation getButtonHoverTexture() {
        return this.buttonHoverTexture;
    }

    @Override
    protected ResourceLocation getButtonTexture() {
        return this.buttonTexture;
    }

    @Override
    public void onClick(@NotNull MouseButtonEvent mouseButtonEvent, boolean bl) {
        this.interactWithAllItems(ClickType.QUICK_MOVE, 0);
    }

    @Override
    protected KeyMapping getKeyMapping() {
        if (this.isInventoryButton) {
            return InventorySortingKeyMappings.MOVE_SAME_INVENTORY.get();
        }
        return InventorySortingKeyMappings.MOVE_SAME.get();
    }

    @Override
    @NotNull
    protected List<Integer> getItemSlotsToInteractWith(AbstractContainerMenu menu) {
        NonNullList slots = menu.slots;
        int newEndIndex = this.calculateEndIndex();
        List<Item> itemsOutOfIndexRange = this.getItemsOutOfIndexRange((NonNullList<Slot>)slots, this.startIndex, newEndIndex);
        return IntStream.range(this.startIndex, newEndIndex).mapToObj(slotIndex -> Map.entry(slotIndex, ((Slot)slots.get(slotIndex)).getItem())).filter(itemStackEntry -> this.isItemInOtherContainer((ItemStack)itemStackEntry.getValue(), itemsOutOfIndexRange)).map(Map.Entry::getKey).toList();
    }

    private List<Item> getItemsOutOfIndexRange(NonNullList<Slot> slots, int startIndex, int endIndex) {
        return slots.stream().filter(slot -> startIndex != 0 && slot.index < startIndex || startIndex == 0 && slot.index >= endIndex).filter(slot -> !slot.getItem().is(Items.AIR)).map(slot -> slot.getItem().getItem()).distinct().toList();
    }

    private boolean isItemInOtherContainer(ItemStack itemStack, List<Item> itemsOutOfIndexRange) {
        return !itemStack.is(Items.AIR) && itemsOutOfIndexRange.contains(itemStack.getItem());
    }
}

