/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.inventory.sorting;

import com.devnemo.nemos.inventory.sorting.ModKeyMappings;
import com.devnemo.nemos.inventory.sorting.NemosInventorySortingClientCommon;
import java.nio.file.Path;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;

@Mod(value="nemos_inventory_sorting")
public class NemosInventorySortingForge {
    public NemosInventorySortingForge(FMLJavaModLoadingContext context) {
        if (FMLEnvironment.dist.isClient()) {
            NemosInventorySortingClientCommon.init();
        }
        BusGroup modBusGroup = context.getModBusGroup();
        AddPackFindersEvent.getBus((BusGroup)modBusGroup).addListener(this::addBuiltInResourcePack);
        RegisterKeyMappingsEvent.getBus((BusGroup)modBusGroup).addListener(this::registerKeyMappings);
    }

    private void addBuiltInResourcePack(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            Path resourcePath = ModList.get().getModFileById("nemos_inventory_sorting").getFile().findResource(new String[]{"resourcepacks/dark_mode"});
            PackLocationInfo packLocationInfo = new PackLocationInfo("builtin/dark_mode", (Component)Component.translatable((String)"nemos_inventory_sorting.resourcePack.darkMode.name"), PackSource.BUILT_IN, Optional.empty());
            PathPackResources.PathResourcesSupplier pathResourcesSupplier = new PathPackResources.PathResourcesSupplier(resourcePath);
            PackSelectionConfig packSelectionConfig = new PackSelectionConfig(false, Pack.Position.TOP, false);
            Pack pack = Pack.readMetaAndCreate((PackLocationInfo)packLocationInfo, (Pack.ResourcesSupplier)pathResourcesSupplier, (PackType)PackType.CLIENT_RESOURCES, (PackSelectionConfig)packSelectionConfig);
            event.addRepositorySource(packConsumer -> packConsumer.accept(pack));
        }
    }

    private void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(ModKeyMappings.SORT.get());
        event.register(ModKeyMappings.SORT_INVENTORY.get());
        event.register(ModKeyMappings.MOVE_SAME.get());
        event.register(ModKeyMappings.MOVE_SAME_INVENTORY.get());
        event.register(ModKeyMappings.MOVE_ALL.get());
        event.register(ModKeyMappings.MOVE_ALL_INVENTORY.get());
        event.register(ModKeyMappings.DROP_ALL.get());
        event.register(ModKeyMappings.DROP_ALL_INVENTORY.get());
        event.register(ModKeyMappings.TOGGLE_FILTER_PERSISTENCE.get());
    }
}

