/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.inventory.sorting.mixin;

import com.nemonotfound.nemos.inventory.sorting.ModKeyMappings;
import com.nemonotfound.nemos.inventory.sorting.config.DefaultConfigValues;
import com.nemonotfound.nemos.inventory.sorting.config.model.ComponentConfig;
import com.nemonotfound.nemos.inventory.sorting.config.model.FilterConfig;
import com.nemonotfound.nemos.inventory.sorting.config.service.ConfigService;
import com.nemonotfound.nemos.inventory.sorting.factory.FilterButtonCreator;
import com.nemonotfound.nemos.inventory.sorting.factory.ToggleFilterPersistenceButtonFactory;
import com.nemonotfound.nemos.inventory.sorting.gui.components.FilterBox;
import com.nemonotfound.nemos.inventory.sorting.gui.components.buttons.AbstractFilterToggleButton;
import com.nemonotfound.nemos.inventory.sorting.model.FilterResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1921;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_481;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_465.class})
public abstract class AbstractContainerScreenMixin
extends class_437 {
    @Shadow
    protected int field_2776;
    @Shadow
    protected int field_2800;
    @Unique
    private FilterBox nemosInventorySorting$filterBox;
    @Unique
    private FilterConfig nemosInventorySorting$filterConfig;
    @Unique
    private static final class_2960 HIGHLIGHTED_SLOT = class_2960.method_60655((String)"nemos_inventory_sorting", (String)"container/highlighted_slot");
    @Unique
    private static final class_2960 HIGHLIGHTED_SLOT_INCLUDED_ITEM = class_2960.method_60655((String)"nemos_inventory_sorting", (String)"container/highlighted_slot_included_item");
    @Unique
    private static final class_2960 DIMMED_SLOT = class_2960.method_60655((String)"nemos_inventory_sorting", (String)"container/dimmed_slot");
    @Unique
    private final ConfigService nemosInventorySorting$configService = ConfigService.getInstance();
    @Unique
    private final Map<class_304, AbstractFilterToggleButton> nemosInventorySorting$keyMappingButtonMap = new HashMap<class_304, AbstractFilterToggleButton>();

    @Shadow
    public abstract class_1703 method_17577();

    protected AbstractContainerScreenMixin(class_2561 component) {
        super(component);
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    public void init(CallbackInfo ci) {
        if (this.nemosInventorySorting$shouldHaveFilterComponents()) {
            List<ComponentConfig> configs = this.nemosInventorySorting$configService.readOrGetDefaultComponentConfigs();
            this.nemosInventorySorting$filterConfig = this.nemosInventorySorting$configService.readOrGetDefaultFilterConfig();
            this.nemosInventorySorting$initFilterBox(configs);
            this.nemosInventorySorting$initFilterButtons(configs);
        }
    }

    @Unique
    private void nemosInventorySorting$initFilterBox(List<ComponentConfig> configs) {
        Optional<ComponentConfig> optionalComponentConfig = this.nemosInventorySorting$configService.getOrDefaultComponentConfig(configs, DefaultConfigValues.ITEM_FILTER);
        if (optionalComponentConfig.isEmpty()) {
            return;
        }
        ComponentConfig config = optionalComponentConfig.get();
        if (!config.isEnabled()) {
            return;
        }
        int yOffset = config.yOffset() != null ? config.yOffset() : DefaultConfigValues.Y_OFFSET_ITEM_FILTER;
        this.nemosInventorySorting$createSearchBox(config.xOffset(), yOffset, config.width(), config.height(), this.nemosInventorySorting$filterConfig.getFilter());
    }

    @Unique
    private void nemosInventorySorting$initFilterButtons(List<ComponentConfig> configs) {
        ToggleFilterPersistenceButtonFactory toggleFilterPersistenceButtonFactory = ToggleFilterPersistenceButtonFactory.getInstance();
        this.nemosInventorySorting$createButton(configs, DefaultConfigValues.FILTER_PERSISTENCE_TOGGLE, ModKeyMappings.TOGGLE_FILTER_PERSISTENCE.get(), toggleFilterPersistenceButtonFactory);
    }

    @Unique
    private void nemosInventorySorting$createButton(List<ComponentConfig> configs, String componentName, class_304 keyMapping, FilterButtonCreator filterButtonCreator) {
        Optional<ComponentConfig> optionalComponentConfig = this.nemosInventorySorting$configService.getOrDefaultComponentConfig(configs, componentName);
        if (optionalComponentConfig.isEmpty()) {
            return;
        }
        ComponentConfig config = optionalComponentConfig.get();
        if (!config.isEnabled()) {
            return;
        }
        int yOffset = config.yOffset() != null ? config.yOffset() : DefaultConfigValues.Y_OFFSET_ITEM_FILTER;
        AbstractFilterToggleButton button = filterButtonCreator.createButton(this.field_2776, this.field_2800, config.xOffset(), yOffset, config.width(), config.height(), this.nemosInventorySorting$filterConfig);
        this.nemosInventorySorting$keyMappingButtonMap.put(keyMapping, button);
        this.method_37063((class_364)button);
    }

    @Inject(method={"onClose"}, at={@At(value="TAIL")})
    private void onClose(CallbackInfo ci) {
        if (this.nemosInventorySorting$filterBox == null) {
            return;
        }
        String filter = this.nemosInventorySorting$filterConfig.isFilterPersistent() ? this.nemosInventorySorting$filterBox.method_1882() : "";
        this.nemosInventorySorting$filterConfig.setFilter(filter);
        this.nemosInventorySorting$configService.writeConfig(true, "config/nemos-inventory-sorting/filter-config.json", this.nemosInventorySorting$filterConfig);
    }

    @Unique
    private void nemosInventorySorting$createSearchBox(int xOffset, int yOffset, int width, int height, String filter) {
        this.nemosInventorySorting$filterBox = new FilterBox(this.field_22793, this.field_2776, this.field_2800, xOffset, yOffset, width, height, (class_2561)class_2561.method_43471((String)"nemos_inventory_sorting.itemFilter"));
        this.method_25429((class_364)this.nemosInventorySorting$filterBox);
        this.nemosInventorySorting$filterBox.method_1852(filter);
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    public void keyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (!this.nemosInventorySorting$shouldHaveFilterComponents()) {
            return;
        }
        if (this.nemosInventorySorting$filterBox != null && this.nemosInventorySorting$filterBox.method_25370() && keyCode != 256) {
            cir.setReturnValue((Object)this.nemosInventorySorting$filterBox.method_25404(keyCode, scanCode, modifiers));
            return;
        }
        Optional<Map.Entry> optionalButtonEntry = this.nemosInventorySorting$keyMappingButtonMap.entrySet().stream().filter(entry -> ((class_304)entry.getKey()).method_1417(keyCode, scanCode)).findFirst();
        optionalButtonEntry.ifPresent(entry -> {
            AbstractFilterToggleButton button = (AbstractFilterToggleButton)entry.getValue();
            button.method_25354(class_310.method_1551().method_1483());
            button.method_25348(0.0, 0.0);
        });
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")})
    private void mouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        Optional optional = this.method_19355(mouseX, mouseY);
        if (optional.isEmpty()) {
            for (class_364 guiEventListener : this.method_25396()) {
                guiEventListener.method_25365(false);
            }
        }
        Optional<Map.Entry> optionalButtonEntry = this.nemosInventorySorting$keyMappingButtonMap.entrySet().stream().filter(entry -> ((class_304)entry.getKey()).method_1433(button)).findFirst();
        optionalButtonEntry.ifPresent(entry -> {
            AbstractFilterToggleButton sortButton = (AbstractFilterToggleButton)entry.getValue();
            sortButton.method_25354(class_310.method_1551().method_1483());
            sortButton.method_25348(0.0, 0.0);
        });
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void renderFilterBar(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        if (!this.nemosInventorySorting$shouldHaveFilterComponents() || this.nemosInventorySorting$filterBox == null) {
            return;
        }
        this.nemosInventorySorting$filterBox.method_25394(guiGraphics, mouseX, mouseY, partialTick);
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;renderSlotHighlightFront(Lnet/minecraft/client/gui/GuiGraphics;)V", shift=At.Shift.AFTER)})
    void render(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        if (!this.nemosInventorySorting$shouldHaveFilterComponents() || this.nemosInventorySorting$filterBox == null) {
            return;
        }
        String filter = this.nemosInventorySorting$filterBox.method_1882();
        if (!filter.isEmpty()) {
            Map<FilterResult, List<class_1735>> filteredSlotMap = this.nemosInventorySorting$filterBox.filterSlots((class_2371<class_1735>)this.method_17577().field_7761, filter);
            this.nemosInventorySorting$markSlots(class_1921::method_62277, filteredSlotMap.get((Object)FilterResult.INCLUDED), guiGraphics, HIGHLIGHTED_SLOT);
            this.nemosInventorySorting$markSlots(class_1921::method_62277, filteredSlotMap.get((Object)FilterResult.HAS_INCLUDED_ITEM), guiGraphics, HIGHLIGHTED_SLOT_INCLUDED_ITEM);
            this.nemosInventorySorting$markSlots(class_1921::method_62275, filteredSlotMap.get((Object)FilterResult.EXCLUDED), guiGraphics, DIMMED_SLOT);
        }
    }

    @Unique
    private boolean nemosInventorySorting$shouldHaveFilterComponents() {
        return !(this.method_17577() instanceof class_481.class_483);
    }

    @Unique
    private void nemosInventorySorting$markSlots(Function<class_2960, class_1921> renderTypeFunction, List<class_1735> slots, class_332 guiGraphics, class_2960 texture) {
        if (slots == null) {
            return;
        }
        for (class_1735 slot : slots) {
            guiGraphics.method_52706(renderTypeFunction, texture, slot.field_7873, slot.field_7872, 16, 16);
        }
    }
}

