/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.inventory.sorting.mixin;

import com.nemonotfound.nemos.inventory.sorting.ModKeyMappings;
import com.nemonotfound.nemos.inventory.sorting.config.DefaultConfigValues;
import com.nemonotfound.nemos.inventory.sorting.config.model.ComponentConfig;
import com.nemonotfound.nemos.inventory.sorting.config.service.ConfigService;
import com.nemonotfound.nemos.inventory.sorting.factory.ButtonCreator;
import com.nemonotfound.nemos.inventory.sorting.factory.DropAllButtonFactory;
import com.nemonotfound.nemos.inventory.sorting.factory.SortAlphabeticallyButtonFactory;
import com.nemonotfound.nemos.inventory.sorting.factory.SortAlphabeticallyDescendingButtonFactory;
import com.nemonotfound.nemos.inventory.sorting.gui.components.FilterBox;
import com.nemonotfound.nemos.inventory.sorting.gui.components.buttons.AbstractInventoryButton;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_10260;
import net.minecraft.class_1661;
import net.minecraft.class_1723;
import net.minecraft.class_1729;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_490;
import net.minecraft.class_507;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_490.class})
public abstract class InventoryScreenMixin
extends class_10260<class_1723> {
    @Unique
    private final Map<class_304, AbstractInventoryButton> nemosInventorySorting$keyMappingButtonMap = new HashMap<class_304, AbstractInventoryButton>();
    @Unique
    private final ConfigService nemosInventorySorting$configService = ConfigService.getInstance();

    public InventoryScreenMixin(class_1723 menu, class_507<?> recipeBookComponent, class_1661 inventory, class_2561 component) {
        super((class_1729)menu, recipeBookComponent, inventory, component);
    }

    @Inject(method={"init"}, at={@At(value="RETURN")})
    public void init(CallbackInfo ci) {
        SortAlphabeticallyButtonFactory sortAlphabeticallyButtonFactory = SortAlphabeticallyButtonFactory.getInstance();
        SortAlphabeticallyDescendingButtonFactory sortAlphabeticallyDescendingButtonFactory = SortAlphabeticallyDescendingButtonFactory.getInstance();
        DropAllButtonFactory dropAllButtonFactory = DropAllButtonFactory.getInstance();
        List<ComponentConfig> configs = this.nemosInventorySorting$configService.readOrGetDefaultComponentConfigs();
        this.nemosInventorySorting$createButton(configs, DefaultConfigValues.SORT_ALPHABETICALLY_DESCENDING_INVENTORY, ModKeyMappings.SORT_ALPHABETICALLY_DESCENDING_INVENTORY.get(), sortAlphabeticallyDescendingButtonFactory, DefaultConfigValues.Y_OFFSET_INVENTORY);
        this.nemosInventorySorting$createButton(configs, DefaultConfigValues.SORT_ALPHABETICALLY_INVENTORY, ModKeyMappings.SORT_ALPHABETICALLY_INVENTORY.get(), sortAlphabeticallyButtonFactory, DefaultConfigValues.Y_OFFSET_INVENTORY);
        this.nemosInventorySorting$createButton(configs, DefaultConfigValues.DROP_ALL_INVENTORY, ModKeyMappings.DROP_ALL_INVENTORY.get(), dropAllButtonFactory, DefaultConfigValues.Y_OFFSET_INVENTORY);
        for (AbstractInventoryButton button : this.nemosInventorySorting$keyMappingButtonMap.values()) {
            this.method_37063((class_364)button);
        }
    }

    @Unique
    private void nemosInventorySorting$createButton(List<ComponentConfig> configsList, String componentName, class_304 keyMapping, ButtonCreator buttonCreator, int defaultYOffset) {
        Optional<ComponentConfig> optionalComponentConfig = this.nemosInventorySorting$configService.getOrDefaultComponentConfig(configsList, componentName);
        if (optionalComponentConfig.isEmpty()) {
            return;
        }
        ComponentConfig config = optionalComponentConfig.get();
        if (!config.isEnabled()) {
            return;
        }
        int yOffset = config.yOffset() != null ? config.yOffset() : defaultYOffset;
        this.nemosInventorySorting$createButton(keyMapping, buttonCreator, config.xOffset(), yOffset, config.width(), config.height());
    }

    @Unique
    private void nemosInventorySorting$createButton(class_304 keyMapping, ButtonCreator buttonCreator, int xOffset, int yOffset, int width, int height) {
        int nemosInventorySorting$startIndex = 9;
        int nemosInventorySorting$endIndex = 36;
        AbstractInventoryButton sortButton = buttonCreator.createButton(nemosInventorySorting$startIndex, nemosInventorySorting$endIndex, this.field_2776, this.field_2800, xOffset, yOffset, width, height, this.method_17577());
        this.nemosInventorySorting$keyMappingButtonMap.put(keyMapping, sortButton);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        Optional<Map.Entry> optionalButtonEntry = this.nemosInventorySorting$keyMappingButtonMap.entrySet().stream().filter(entry -> ((class_304)entry.getKey()).method_1417(keyCode, scanCode)).findFirst();
        Optional<class_364> optionalFilterBox = this.method_25396().stream().filter(widget -> widget instanceof FilterBox).findFirst();
        if (keyCode == 340) {
            this.nemosInventorySorting$updateToolTips(true);
        } else {
            if (optionalFilterBox.isPresent() && optionalFilterBox.get().method_25370()) {
                return super.method_25404(keyCode, scanCode, modifiers);
            }
            optionalButtonEntry.ifPresent(entry -> {
                AbstractInventoryButton button = (AbstractInventoryButton)entry.getValue();
                button.method_25354(class_310.method_1551().method_1483());
                button.method_25348(0.0, 0.0);
            });
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340) {
            this.nemosInventorySorting$updateToolTips(false);
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        Optional<Map.Entry> optionalButtonEntry = this.nemosInventorySorting$keyMappingButtonMap.entrySet().stream().filter(entry -> ((class_304)entry.getKey()).method_1433(button)).findFirst();
        optionalButtonEntry.ifPresent(entry -> {
            AbstractInventoryButton sortButton = (AbstractInventoryButton)entry.getValue();
            sortButton.method_25354(class_310.method_1551().method_1483());
            sortButton.method_25348(0.0, 0.0);
        });
        return super.method_25402(mouseX, mouseY, button);
    }

    @Unique
    private void nemosInventorySorting$updateToolTips(boolean isShiftDown) {
        for (AbstractInventoryButton button : this.nemosInventorySorting$keyMappingButtonMap.values()) {
            button.setIsShiftKeyDown(isShiftDown);
            button.setTooltip(this.method_17577());
        }
    }
}

