/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.inventory.sorting.service;

import com.nemonotfound.nemos.inventory.sorting.model.FilterResult;
import com.nemonotfound.nemos.inventory.sorting.service.TooltipService;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_9276;
import net.minecraft.class_9288;
import net.minecraft.class_9334;

public class FilterService {
    private static FilterService INSTANCE;

    public static FilterService getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FilterService();
        }
        return INSTANCE;
    }

    public Map<FilterResult, List<class_1735>> filterSlots(class_2371<class_1735> slots, String filter) {
        return slots.stream().collect(Collectors.groupingBy(slot -> this.filterSlot((class_1735)slot, filter)));
    }

    private FilterResult filterSlot(class_1735 slot, String filter) {
        class_1799 slotItem = slot.method_7677();
        if (slotItem.method_31574(class_1802.field_8162)) {
            return FilterResult.EXCLUDED;
        }
        if (this.bundleContentsMatchFilter(slotItem, filter) || this.itemContainerContentsMatchFilter(slotItem, filter)) {
            return FilterResult.HAS_INCLUDED_ITEM;
        }
        return this.matchesFilter(slotItem, filter) ? FilterResult.INCLUDED : FilterResult.EXCLUDED;
    }

    private boolean bundleContentsMatchFilter(class_1799 itemStack, String filter) {
        if (!itemStack.method_57826(class_9334.field_49650)) {
            return false;
        }
        class_9276 bundleContents = (class_9276)itemStack.method_58694(class_9334.field_49650);
        Stream<class_1799> stream = bundleContents != null ? bundleContents.method_59707() : Stream.builder().build();
        return this.contentsMatchFilter(stream, filter);
    }

    private boolean itemContainerContentsMatchFilter(class_1799 itemStack, String filter) {
        if (!itemStack.method_57826(class_9334.field_49622)) {
            return false;
        }
        class_9288 itemContainerContents = (class_9288)itemStack.method_58694(class_9334.field_49622);
        Stream<class_1799> stream = itemContainerContents != null ? itemContainerContents.method_57489() : Stream.builder().build();
        return this.contentsMatchFilter(stream, filter);
    }

    private boolean contentsMatchFilter(Stream<class_1799> stream, String filter) {
        return stream.anyMatch(itemStack -> this.matchesFilter((class_1799)itemStack, filter) || this.bundleContentsMatchFilter((class_1799)itemStack, filter));
    }

    private boolean matchesFilter(class_1799 itemStack, String filter) {
        boolean itemNameMatchesFilter = this.componentMatchesFilter(itemStack.method_63693(), filter);
        boolean itemDisplayNameMatchesFilter = this.componentMatchesFilter(itemStack.method_7954(), filter);
        boolean itemEnchantsMatchesFilter = this.enchantmentsMatchFilter(itemStack, filter);
        return itemNameMatchesFilter || itemDisplayNameMatchesFilter || itemEnchantsMatchesFilter;
    }

    private boolean enchantmentsMatchFilter(class_1799 itemStack, String filter) {
        TooltipService tooltipService = TooltipService.getInstance();
        return tooltipService.retrieveEnchantmentNames(itemStack).toLowerCase().contains(filter.toLowerCase());
    }

    private boolean componentMatchesFilter(class_2561 component, String filter) {
        return component.getString().toLowerCase().contains(filter.toLowerCase());
    }
}

