/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.inventory.sorting.service;

import com.nemonotfound.nemos.inventory.sorting.model.SlotItem;
import com.nemonotfound.nemos.inventory.sorting.service.MergingService;
import com.nemonotfound.nemos.inventory.sorting.service.sorting.AbstractSortingService;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1703;

public class InventoryService {
    private static InventoryService INSTANCE;
    private final MergingService inventoryMergeService;

    private InventoryService(MergingService inventoryMergeService) {
        this.inventoryMergeService = inventoryMergeService;
    }

    public static InventoryService getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InventoryService(MergingService.getInstance());
        }
        return INSTANCE;
    }

    public void handleSorting(AbstractSortingService sortingService, class_1703 menu, int startIndex, int endIndex) {
        int containerId = menu.field_7763;
        List<SlotItem> sortedSlotItems = sortingService.sortSlotItems(menu, startIndex, endIndex);
        this.inventoryMergeService.mergeAllItems(menu, sortedSlotItems, containerId);
        List<SlotItem> sortedSlotItemsAfterMerge = sortingService.sortSlotItems(menu, startIndex, endIndex);
        Map<Integer, Integer> slotSwapMap = sortingService.retrieveSlotSwapMap(sortedSlotItemsAfterMerge, startIndex);
        sortingService.sortItemsInInventory(menu, slotSwapMap, containerId);
    }

    public int calculateEndIndex(boolean shouldIncludeHotbar, int endIndex) {
        if (shouldIncludeHotbar) {
            return endIndex + 9;
        }
        return endIndex;
    }
}

