/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.inventory.sorting.service.sorting;

import com.nemonotfound.nemos.inventory.sorting.Constants;
import com.nemonotfound.nemos.inventory.sorting.model.SlotItem;
import com.nemonotfound.nemos.inventory.sorting.service.SlotSwappingService;
import com.nemonotfound.nemos.inventory.sorting.service.TooltipService;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractSortingService {
    private final SlotSwappingService inventorySwapService;
    private final TooltipService tooltipService;
    private final class_310 minecraft;

    protected AbstractSortingService(SlotSwappingService inventorySwapService, TooltipService tooltipService, class_310 minecraft) {
        this.inventorySwapService = inventorySwapService;
        this.tooltipService = tooltipService;
        this.minecraft = minecraft;
    }

    @NotNull
    public List<SlotItem> sortSlotItems(class_1703 menu, int startIndex, int endIndex) {
        return IntStream.range(startIndex, endIndex).mapToObj(slotIndex -> new SlotItem(slotIndex, ((class_1735)menu.field_7761.get(slotIndex)).method_7677())).filter(slotItem -> !slotItem.itemStack().method_7960()).sorted(this.comparator()).toList();
    }

    abstract Comparator<SlotItem> comparator();

    protected Comparator<SlotItem> comparatorByName() {
        Comparator<SlotItem> comparator = Comparator.comparing(slotItem -> slotItem.itemStack().method_63693().getString());
        return comparator.thenComparing(slotItem -> this.tooltipService.retrieveEnchantmentNames(slotItem.itemStack()));
    }

    public Map<Integer, Integer> retrieveSlotSwapMap(List<SlotItem> slotItems, int startIndex) {
        LinkedHashMap<Integer, Integer> slotSwapMap = new LinkedHashMap<Integer, Integer>();
        for (int i = 0; i < slotItems.size(); ++i) {
            int newSlot = i + startIndex;
            int currentSlot = slotItems.get(i).slotIndex();
            if (currentSlot == newSlot) continue;
            slotSwapMap.put(currentSlot, newSlot);
        }
        return slotSwapMap;
    }

    public void sortItemsInInventory(class_1703 menu, Map<Integer, Integer> slotSwapMap, int containerId) {
        Iterator<Map.Entry<Integer, Integer>> iterator;
        int remainingCyles = 1000;
        while (!slotSwapMap.isEmpty() && remainingCyles-- > 0 && (iterator = slotSwapMap.entrySet().iterator()).hasNext()) {
            int targetSlot;
            Map.Entry<Integer, Integer> entry = iterator.next();
            int currentSlot = entry.getKey();
            if (currentSlot == (targetSlot = entry.getValue().intValue())) {
                iterator.remove();
                continue;
            }
            this.inventorySwapService.performSlotSwap(menu, this.minecraft.field_1761, containerId, currentSlot, targetSlot, this.minecraft.field_1724);
            if (slotSwapMap.containsKey(targetSlot)) {
                slotSwapMap.put(currentSlot, slotSwapMap.get(targetSlot));
            } else {
                iterator.remove();
            }
            slotSwapMap.put(targetSlot, targetSlot);
        }
        if (remainingCyles <= 0) {
            Constants.LOG.warn("Slot swap cycle limit reached. Please report this");
        }
    }
}

