/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.inventory.sorting.gui.components.buttons;

import com.devnemo.nemos.inventory.sorting.gui.components.RecipeBookUpdatable;
import java.util.Arrays;
import net.minecraft.class_10799;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractInventoryButton
extends class_339
implements RecipeBookUpdatable {
    protected final class_1703 menu;
    protected final Integer startIndex;
    protected final Integer endIndex;
    private final int xOffset;
    private final class_2561 buttonName;
    private final class_2561 shiftButtonName;
    protected final boolean isInventoryButton;
    protected boolean isShiftKeyDown = false;

    public AbstractInventoryButton(Builder<? extends AbstractInventoryButton> builder) {
        super(builder.x.intValue(), builder.y.intValue(), builder.width.intValue(), builder.height.intValue(), builder.buttonName);
        this.method_47400(class_7919.method_47407((class_2561)builder.buttonName));
        this.buttonName = builder.buttonName;
        this.shiftButtonName = builder.shiftButtonName;
        this.menu = builder.menu;
        this.startIndex = builder.startIndex;
        this.endIndex = builder.endIndex;
        this.xOffset = builder.xOffset;
        this.isInventoryButton = builder.isInventoryButton;
    }

    public abstract void method_25348(double var1, double var3);

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340) {
            this.setIsShiftKeyDown(true);
            this.setTooltip();
        }
        class_310 minecraft = class_310.method_1551();
        boolean isKeyPressed = Arrays.stream(minecraft.field_1690.field_1839).filter(keyMapping -> keyMapping.method_1435(this.getKeyMapping())).anyMatch(keyMapping -> keyMapping.method_1417(keyCode, scanCode));
        if (!isKeyPressed) {
            return super.method_25404(keyCode, scanCode, modifiers);
        }
        this.method_25354(minecraft.method_1483());
        this.method_25348(0.0, 0.0);
        return true;
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340) {
            this.setIsShiftKeyDown(false);
            this.setTooltip();
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        class_310 minecraft = class_310.method_1551();
        boolean isKeyPressed = Arrays.stream(minecraft.field_1690.field_1839).filter(keyMapping -> keyMapping.method_1435(this.getKeyMapping())).anyMatch(keyMapping -> keyMapping.method_1433(button));
        if (!isKeyPressed) {
            return super.method_25402(mouseX, mouseY, button);
        }
        this.method_25354(minecraft.method_1483());
        this.method_25348(0.0, 0.0);
        return true;
    }

    protected abstract class_304 getKeyMapping();

    protected void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.method_49606()) {
            guiGraphics.method_52706(class_10799.field_56883, this.getButtonHoverTexture(), this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
        } else {
            guiGraphics.method_52706(class_10799.field_56883, this.getButtonTexture(), this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
        }
    }

    @Override
    public void updateXPosition(int leftPos) {
        this.method_46421(leftPos + this.xOffset);
    }

    protected abstract class_2960 getButtonHoverTexture();

    protected abstract class_2960 getButtonTexture();

    public void setIsShiftKeyDown(boolean shiftKeyDown) {
        this.isShiftKeyDown = shiftKeyDown;
    }

    public void setTooltip() {
        if (this.isButtonShiftable()) {
            this.method_47400(class_7919.method_47407((class_2561)this.shiftButtonName));
        } else {
            this.method_47400(class_7919.method_47407((class_2561)this.buttonName));
        }
    }

    protected int calculateEndIndex() {
        if (this.isButtonShiftable()) {
            return this.endIndex + 9;
        }
        return this.endIndex;
    }

    protected boolean isButtonShiftable() {
        return this.isShiftKeyDown && this.isInventoryButton;
    }

    protected void method_47399(@NotNull class_6382 narrationElementOutput) {
    }

    public static class Builder<T extends AbstractInventoryButton> {
        private Integer startIndex;
        private Integer endIndex;
        private Integer x;
        private Integer y;
        private Integer xOffset;
        private Integer width;
        private Integer height;
        private class_2561 buttonName;
        private class_2561 shiftButtonName;
        private class_1703 menu;
        private boolean isInventoryButton = false;
        private final Class<T> clazz;

        public Builder(Class<T> clazz) {
            this.clazz = clazz;
        }

        public Builder<T> startIndex(int startIndex) {
            this.startIndex = startIndex;
            return this;
        }

        public Builder<T> endIndex(int endIndex) {
            this.endIndex = endIndex;
            return this;
        }

        public Builder<T> x(int x) {
            this.x = x;
            return this;
        }

        public Builder<T> y(int y) {
            this.y = y;
            return this;
        }

        public Builder<T> xOffset(int xOffset) {
            this.xOffset = xOffset;
            return this;
        }

        public Builder<T> width(int width) {
            this.width = width;
            return this;
        }

        public Builder<T> height(int height) {
            this.height = height;
            return this;
        }

        public Builder<T> buttonName(class_2561 buttonName) {
            this.buttonName = buttonName;
            return this;
        }

        public Builder<T> shiftButtonName(class_2561 shiftButtonName) {
            this.shiftButtonName = shiftButtonName;
            return this;
        }

        public Builder<T> menu(class_1703 menu) {
            this.menu = menu;
            return this;
        }

        public Builder<T> isInventoryButton(boolean isInventoryButton) {
            this.isInventoryButton = isInventoryButton;
            return this;
        }

        public T build() {
            this.checkRequiredFields();
            try {
                return (T)((AbstractInventoryButton)this.clazz.getDeclaredConstructor(Builder.class).newInstance(this));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create instance of " + this.clazz.getName(), e);
            }
        }

        private void checkRequiredFields() {
            if (this.startIndex == null || this.endIndex == null || this.x == null || this.y == null || this.xOffset == null || this.width == null || this.height == null || this.buttonName == null || this.menu == null) {
                throw new IllegalArgumentException("Not all fields were set!");
            }
        }
    }
}

