/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.inventory.sorting;

import com.devnemo.nemos.inventory.sorting.Constants;
import com.devnemo.nemos.inventory.sorting.client.InventorySortingCategories;
import com.devnemo.nemos.inventory.sorting.client.InventorySortingKeyMappings;
import com.devnemo.nemos.inventory.sorting.config.DefaultConfigs;
import com.devnemo.nemos.inventory.sorting.config.service.ConfigService;
import com.devnemo.nemos.inventory.sorting.helper.SortOrder;
import com.devnemo.nemos.inventory.sorting.platform.IModLoaderHelper;
import com.devnemo.nemos.inventory.sorting.platform.IRegistryHelper;
import java.util.ServiceLoader;

public class NemosInventorySortingClientCommon {
    public static final IRegistryHelper REGISTRY_HELPER = ServiceLoader.load(IRegistryHelper.class).findFirst().orElseThrow();
    public static final IModLoaderHelper MOD_LOADER_HELPER = ServiceLoader.load(IModLoaderHelper.class).findFirst().orElseThrow();

    public static void init() {
        Constants.LOG.info("Thank you for using Nemo's Inventory Sorting!");
        InventorySortingCategories.init();
        InventorySortingKeyMappings.init();
        DefaultConfigs.setupDefaultConfigs();
        ConfigService.getInstance().writeConfig(false, "config/nemos-inventory-sorting/config.json", DefaultConfigs.DEFAULT_COMPONENT_CONFIGS);
        ConfigService.getInstance().writeConfig(false, "config/nemos-inventory-sorting/filter-config.json", DefaultConfigs.DEFAULT_FILTER_CONFIG);
        if (MOD_LOADER_HELPER.isModLoaded("ironchest")) {
            ConfigService.getInstance().writeConfig(false, "config/nemos-inventory-sorting/iron-chest-config.json", DefaultConfigs.DEFAULT_IRON_CHEST_COMPONENT_CONFIGS);
        }
        SortOrder.init();
    }
}

