/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.inventory.sorting.config.service;

import com.devnemo.nemos.inventory.sorting.Constants;
import com.devnemo.nemos.inventory.sorting.config.DefaultConfigs;
import com.devnemo.nemos.inventory.sorting.config.model.ComponentConfig;
import com.devnemo.nemos.inventory.sorting.config.model.FilterConfig;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;

public class ConfigService {
    private static ConfigService INSTANCE;
    private final Gson gson;
    private static final TypeToken<List<ComponentConfig>> COMPONENT_CONFIG_TYPE;
    private static final TypeToken<FilterConfig> FILTER_CONFIG_TYPE_TOKEN;

    private ConfigService(Gson gson) {
        this.gson = gson;
    }

    public static ConfigService getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ConfigService(new Gson());
        }
        return INSTANCE;
    }

    public <T> void writeConfig(boolean shouldUpdate, String filePath, T config) {
        if (!shouldUpdate && Files.exists(Paths.get(filePath, new String[0]), new LinkOption[0])) {
            return;
        }
        try {
            Files.createDirectories(Paths.get("config/nemos-inventory-sorting/", new String[0]), new FileAttribute[0]);
        }
        catch (Exception e) {
            Constants.LOG.error("An error occurred while creating directories:\n", (Throwable)e);
        }
        try (FileWriter writer = new FileWriter(filePath);){
            this.gson.toJson(config, (Appendable)writer);
        }
        catch (Exception e) {
            Constants.LOG.error("An error occurred while writing the config:\n", (Throwable)e);
        }
    }

    public List<ComponentConfig> readOrGetDefaultComponentConfigs() {
        return this.readOrGetDefaultConfig("config/nemos-inventory-sorting/config.json", COMPONENT_CONFIG_TYPE, DefaultConfigs.DEFAULT_COMPONENT_CONFIGS);
    }

    public FilterConfig readOrGetDefaultFilterConfig() {
        return this.readOrGetDefaultConfig("config/nemos-inventory-sorting/filter-config.json", FILTER_CONFIG_TYPE_TOKEN, new FilterConfig());
    }

    public List<ComponentConfig> readOrGetDefaultIronChestComponentConfigs() {
        return this.readOrGetDefaultConfig("config/nemos-inventory-sorting/iron-chest-config.json", COMPONENT_CONFIG_TYPE, DefaultConfigs.DEFAULT_IRON_CHEST_COMPONENT_CONFIGS);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T readOrGetDefaultConfig(String filePath, TypeToken<T> typeToken, T defaultValue) {
        try (FileReader reader = new FileReader(filePath);){
            Object object = this.gson.fromJson((Reader)reader, typeToken);
            return (T)object;
        }
        catch (Exception e) {
            Constants.LOG.error("An error occurred while reading the config:\n", (Throwable)e);
            return defaultValue;
        }
    }

    public Optional<ComponentConfig> getOrDefaultComponentConfig(List<ComponentConfig> configsList, String componentName) {
        Optional<ComponentConfig> optionalConfig = configsList.stream().filter(config -> config.componentName().equals(componentName)).findFirst();
        if (optionalConfig.isEmpty()) {
            return DefaultConfigs.DEFAULT_COMPONENT_CONFIGS.stream().filter(config -> config.componentName().equals(componentName)).findFirst();
        }
        return optionalConfig;
    }

    static {
        COMPONENT_CONFIG_TYPE = new TypeToken<List<ComponentConfig>>(){};
        FILTER_CONFIG_TYPE_TOKEN = new TypeToken<FilterConfig>(){};
    }
}

