/*
 * Decompiled with CFR 0.152.
 */
package com.github.hhhzzzsss.songplayer;

import com.github.hhhzzzsss.songplayer.Config;
import com.github.hhhzzzsss.songplayer.SongPlayer;
import com.github.hhhzzzsss.songplayer.Util;
import com.github.hhhzzzsss.songplayer.item.SongItemCreatorThread;
import com.github.hhhzzzsss.songplayer.item.SongItemUtils;
import com.github.hhhzzzsss.songplayer.playing.SongHandler;
import com.github.hhhzzzsss.songplayer.playing.Stage;
import com.github.hhhzzzsss.songplayer.song.Note;
import com.github.hhhzzzsss.songplayer.song.Playlist;
import com.github.hhhzzzsss.songplayer.song.Song;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_2172;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

public class CommandProcessor {
    public static ArrayList<Command> commands = new ArrayList();
    public static HashMap<String, Command> commandMap = new HashMap();
    public static ArrayList<String> commandCompletions = new ArrayList();

    public static void initCommands() {
        commands.add(new helpCommand());
        commands.add(new setPrefixCommand());
        commands.add(new playCommand());
        commands.add(new stopCommand());
        commands.add(new skipCommand());
        commands.add(new gotoCommand());
        commands.add(new loopCommand());
        commands.add(new statusCommand());
        commands.add(new queueCommand());
        commands.add(new songsCommand());
        commands.add(new playlistCommand());
        commands.add(new setCreativeCommandCommand());
        commands.add(new setSurvivalCommandCommand());
        commands.add(new useEssentialsCommandsCommand());
        commands.add(new useVanillaCommandsCommand());
        commands.add(new toggleFakePlayerCommand());
        commands.add(new setStageTypeCommand());
        commands.add(new breakSpeedCommand());
        commands.add(new placeSpeedCommand());
        commands.add(new toggleMovementCommand());
        commands.add(new setVelocityThresholdCommand());
        commands.add(new toggleAutoCleanupCommand());
        commands.add(new cleanupLastStageCommand());
        commands.add(new announcementCommand());
        commands.add(new toggleSurvivalOnlyCommand());
        commands.add(new toggleFlightNoclipCommand());
        commands.add(new songItemCommand());
        commands.add(new testSongCommand());
        for (Command command : commands) {
            commandMap.put(command.getName().toLowerCase(Locale.ROOT), command);
            commandCompletions.add(command.getName());
            for (String alias : command.getAliases()) {
                commandMap.put(alias.toLowerCase(Locale.ROOT), command);
                commandCompletions.add(alias);
            }
        }
    }

    public static boolean processChatMessage(String message) {
        if (message.startsWith(Config.getConfig().prefix)) {
            String[] parts = message.substring(Config.getConfig().prefix.length()).split(" ", 2);
            String name = parts.length > 0 ? parts[0] : "";
            String args = parts.length > 1 ? parts[1] : "";
            Command c = commandMap.get(name.toLowerCase(Locale.ROOT));
            if (c == null) {
                Util.showChatMessage("\u00a7cUnrecognized command");
            } else {
                try {
                    boolean success = c.processCommand(args);
                    if (!success) {
                        if (c.getSyntax().length == 0) {
                            Util.showChatMessage("\u00a7cSyntax: " + Config.getConfig().prefix + c.getName());
                        } else if (c.getSyntax().length == 1) {
                            Util.showChatMessage("\u00a7cSyntax: " + Config.getConfig().prefix + c.getName() + " " + c.getSyntax()[0]);
                        } else {
                            Util.showChatMessage("\u00a7cSyntax:");
                            for (String syntax : c.getSyntax()) {
                                Util.showChatMessage("\u00a7c    " + Config.getConfig().prefix + c.getName() + " " + syntax);
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    Util.showChatMessage("\u00a7cAn error occurred while running this command: \u00a74" + e.getMessage());
                }
            }
            return true;
        }
        return false;
    }

    public static CompletableFuture<Suggestions> handleSuggestions(String text, SuggestionsBuilder suggestionsBuilder) {
        String commandName2;
        if (!text.contains(" ")) {
            List names = commandCompletions.stream().map(commandName -> Config.getConfig().prefix + commandName).collect(Collectors.toList());
            return class_2172.method_9265(names, (SuggestionsBuilder)suggestionsBuilder);
        }
        String[] split = text.split(" ", 2);
        if (split[0].startsWith(Config.getConfig().prefix) && commandMap.containsKey(commandName2 = split[0].substring(1).toLowerCase(Locale.ROOT))) {
            return commandMap.get(commandName2).getSuggestions(split.length == 1 ? "" : split[1], suggestionsBuilder);
        }
        return null;
    }

    private static class helpCommand
    extends Command {
        private helpCommand() {
        }

        @Override
        public String getName() {
            return "help";
        }

        @Override
        public String[] getSyntax() {
            return new String[]{"[command]"};
        }

        @Override
        public String getDescription() {
            return "Lists commands or explains command";
        }

        @Override
        public boolean processCommand(String args) {
            if (args.length() == 0) {
                StringBuilder helpMessage = new StringBuilder("\u00a76Commands -");
                for (Command c : commands) {
                    helpMessage.append(" " + Config.getConfig().prefix + c.getName());
                }
                Util.showChatMessage(helpMessage.toString());
            } else if (commandMap.containsKey(args.toLowerCase(Locale.ROOT))) {
                Command c = commandMap.get(args.toLowerCase(Locale.ROOT));
                Util.showChatMessage("\u00a76------------------------------");
                Util.showChatMessage("\u00a76Help: \u00a73" + c.getName());
                Util.showChatMessage("\u00a76Description: \u00a73" + c.getDescription());
                if (c.getSyntax().length == 0) {
                    Util.showChatMessage("\u00a76Usage: \u00a73" + Config.getConfig().prefix + c.getName());
                } else if (c.getSyntax().length == 1) {
                    Util.showChatMessage("\u00a76Usage: \u00a73" + Config.getConfig().prefix + c.getName() + " " + c.getSyntax()[0]);
                } else {
                    Util.showChatMessage("\u00a76Usage:");
                    for (String syntax : c.getSyntax()) {
                        Util.showChatMessage("    \u00a73" + Config.getConfig().prefix + c.getName() + " " + syntax);
                    }
                }
                if (c.getAliases().length > 0) {
                    Util.showChatMessage("\u00a76Aliases: \u00a73" + String.join((CharSequence)", ", c.getAliases()));
                }
                Util.showChatMessage("\u00a76------------------------------");
            } else {
                Util.showChatMessage("\u00a7cCommand not recognized: " + args);
            }
            return true;
        }

        @Override
        public CompletableFuture<Suggestions> getSuggestions(String args, SuggestionsBuilder suggestionsBuilder) {
            return class_2172.method_9265(commandCompletions, (SuggestionsBuilder)suggestionsBuilder);
        }
    }

    private static class setPrefixCommand
    extends Command {
        private setPrefixCommand() {
        }

        @Override
        public String getName() {
            return "setPrefix";
        }

        @Override
        public String[] getAliases() {
            return new String[]{"prefix"};
        }

        @Override
        public String[] getSyntax() {
            return new String[]{"<prefix>"};
        }

        @Override
        public String getDescription() {
            return "Sets the command prefix used by SongPlayer";
        }

        @Override
        public boolean processCommand(String args) {
            if (args.contains(" ")) {
                Util.showChatMessage("\u00a7cPrefix cannot contain a space");
                return true;
            }
            if (args.startsWith("/")) {
                Util.showChatMessage("\u00a7cPrefix cannot start with a /");
                return true;
            }
            if (args.length() > 0) {
                Config.getConfig().prefix = args;
                Util.showChatMessage("\u00a76Set prefix to " + args);
                Config.saveConfigWithErrorHandling();
                return true;
            }
            return false;
        }
    }

    private static class playCommand
    extends Command {
        private playCommand() {
        }

        @Override
        public String getName() {
            return "play";
        }

        @Override
        public String[] getSyntax() {
            return new String[]{"<song or url>"};
        }

        @Override
        public String getDescription() {
            return "Plays a song";
        }

        @Override
        public boolean processCommand(String args) {
            if (args.length() > 0) {
                if (Config.getConfig().survivalOnly && SongPlayer.MC.field_1761.method_2920() != class_1934.field_9215) {
                    Util.showChatMessage("\u00a7cTo play in survival only mode, you must be in survival mode to start with.");
                    return true;
                }
                SongHandler.getInstance().loadSong(args);
                return true;
            }
            return false;
        }

        @Override
        public CompletableFuture<Suggestions> getSuggestions(String args, SuggestionsBuilder suggestionsBuilder) {
            return Util.giveSongSuggestions(args, suggestionsBuilder);
        }
    }

    private static class stopCommand
    extends Command {
        private stopCommand() {
        }

        @Override
        public String getName() {
            return "stop";
        }

        @Override
        public String[] getSyntax() {
            return new String[0];
        }

        @Override
        public String getDescription() {
            return "Stops playing";
        }

        @Override
        public boolean processCommand(String args) {
            if (SongHandler.getInstance().isIdle()) {
                Util.showChatMessage("\u00a76No song is currently playing");
                return true;
            }
            if (args.length() == 0) {
                if (SongHandler.getInstance().cleaningUp) {
                    SongHandler.getInstance().restoreStateAndReset();
                    Util.showChatMessage("\u00a76Stopped cleanup");
                } else if (Config.getConfig().autoCleanup && SongHandler.getInstance().originalBlocks.size() != 0) {
                    SongHandler.getInstance().partialResetAndCleanup();
                    Util.showChatMessage("\u00a76Stopped playing and switched to cleanup");
                } else {
                    SongHandler.getInstance().restoreStateAndReset();
                    Util.showChatMessage("\u00a76Stopped playing");
                }
                return true;
            }
            return false;
        }
    }

    private static class skipCommand
    extends Command {
        private skipCommand() {
        }

        @Override
        public String getName() {
            return "skip";
        }

        @Override
        public String[] getSyntax() {
            return new String[0];
        }

        @Override
        public String getDescription() {
            return "Skips current song";
        }

        @Override
        public boolean processCommand(String args) {
            if (SongHandler.getInstance().currentSong == null) {
                Util.showChatMessage("\u00a76No song is currently playing");
                return true;
            }
            if (args.length() == 0) {
                SongHandler.getInstance().currentSong = null;
                return true;
            }
            return false;
        }
    }

    private static class gotoCommand
    extends Command {
        private gotoCommand() {
        }

        @Override
        public String getName() {
            return "goto";
        }

        @Override
        public String[] getSyntax() {
            return new String[]{"<mm:ss>"};
        }

        @Override
        public String getDescription() {
            return "Goes to a specific time in the song";
        }

        @Override
        public boolean processCommand(String args) {
            if (SongHandler.getInstance().currentSong == null) {
                Util.showChatMessage("\u00a76No song is currently playing");
                return true;
            }
            if (args.length() > 0) {
                try {
                    long time = Util.parseTime(args);
                    SongHandler.getInstance().currentSong.setTime(time);
                    Util.showChatMessage("\u00a76Set song time to \u00a73" + Util.formatTime(time));
                    return true;
                }
                catch (IOException e) {
                    Util.showChatMessage("\u00a7cNot a valid time stamp");
                    return false;
                }
            }
            return false;
        }
    }

    private static class loopCommand
    extends Command {
        private loopCommand() {
        }

        @Override
        public String getName() {
            return "loop";
        }

        @Override
        public String[] getSyntax() {
            return new String[0];
        }

        @Override
        public String getDescription() {
            return "Toggles song looping";
        }

        @Override
        public boolean processCommand(String args) {
            if (SongHandler.getInstance().currentSong == null) {
                Util.showChatMessage("\u00a76No song is currently playing");
                return true;
            }
            SongHandler.getInstance().currentSong.looping = !SongHandler.getInstance().currentSong.looping;
            SongHandler.getInstance().currentSong.loopCount = 0;
            if (SongHandler.getInstance().currentSong.looping) {
                Util.showChatMessage("\u00a76Enabled looping");
            } else {
                Util.showChatMessage("\u00a76Disabled looping");
            }
            return true;
        }
    }

    private static class statusCommand
    extends Command {
        private statusCommand() {
        }

        @Override
        public String getName() {
            return "status";
        }

        @Override
        public String[] getAliases() {
            return new String[]{"current"};
        }

        @Override
        public String[] getSyntax() {
            return new String[0];
        }

        @Override
        public String getDescription() {
            return "Gets the status of the song that is currently playing";
        }

        @Override
        public boolean processCommand(String args) {
            if (args.length() == 0) {
                if (SongHandler.getInstance().currentSong == null) {
                    Util.showChatMessage("\u00a76No song is currently playing");
                    return true;
                }
                Song currentSong = SongHandler.getInstance().currentSong;
                long currentTime = Math.min(currentSong.time, currentSong.length);
                long totalTime = currentSong.length;
                Util.showChatMessage(String.format("\u00a76Currently playing %s \u00a73(%s/%s)", currentSong.name, Util.formatTime(currentTime), Util.formatTime(totalTime)));
                return true;
            }
            return false;
        }
    }

    private static class queueCommand
    extends Command {
        private queueCommand() {
        }

        @Override
        public String getName() {
            return "queue";
        }

        @Override
        public String[] getAliases() {
            return new String[]{"showQueue"};
        }

        @Override
        public String[] getSyntax() {
            return new String[0];
        }

        @Override
        public String getDescription() {
            return "Shows the current song queue";
        }

        @Override
        public boolean processCommand(String args) {
            if (args.length() == 0) {
                if (SongHandler.getInstance().currentSong == null && SongHandler.getInstance().songQueue.isEmpty()) {
                    Util.showChatMessage("\u00a76No song is currently playing");
                    return true;
                }
                Util.showChatMessage("\u00a76------------------------------");
                if (SongHandler.getInstance().currentSong != null) {
                    Util.showChatMessage("\u00a76Current song: \u00a73" + SongHandler.getInstance().currentSong.name);
                }
                int index = 0;
                for (Song song : SongHandler.getInstance().songQueue) {
                    Util.showChatMessage(String.format("\u00a76%d. \u00a73%s", ++index, song.name));
                }
                Util.showChatMessage("\u00a76------------------------------");
                return true;
            }
            return false;
        }
    }

    private static class songsCommand
    extends Command {
        private songsCommand() {
        }

        @Override
        public String getName() {
            return "songs";
        }

        @Override
        public String[] getAliases() {
            return new String[]{"list"};
        }

        @Override
        public String[] getSyntax() {
            return new String[]{"", "<subdirectory>"};
        }

        @Override
        public String getDescription() {
            return "Lists available songs. If an argument is provided, lists all songs in the subdirectory.";
        }

        @Override
        public boolean processCommand(String args) {
            if (!args.contains(" ")) {
                Path dir;
                if (args.length() == 0) {
                    dir = SongPlayer.SONG_DIR;
                } else {
                    dir = SongPlayer.SONG_DIR.resolve(args);
                    if (!Files.isDirectory(dir, new LinkOption[0])) {
                        Util.showChatMessage("\u00a7cDirectory not found");
                        return true;
                    }
                }
                List subdirectories = null;
                List songs = null;
                try {
                    subdirectories = Files.list(dir).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(Path::getFileName).map(Path::toString).map(str -> str + "/").collect(Collectors.toList());
                    songs = Files.list(dir).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::getFileName).map(Path::toString).collect(Collectors.toList());
                }
                catch (IOException e) {
                    Util.showChatMessage("\u00a7cError reading folder: \u00a74" + e.getMessage());
                    return true;
                }
                if (subdirectories.size() == 0 && songs.size() == 0) {
                    Util.showChatMessage("\u00a7bNo songs found. You can put midi or nbs files in the \u00a73.minecraft/songs \u00a76folder.");
                } else {
                    Util.showChatMessage("\u00a76----------------------------------------");
                    Util.showChatMessage("\u00a7eContents of .minecraft/songs/" + args);
                    if (subdirectories.size() > 0) {
                        Util.showChatMessage("\u00a76Subdirectories: \u00a73" + String.join((CharSequence)" ", subdirectories));
                    }
                    if (songs.size() > 0) {
                        Util.showChatMessage("\u00a76Songs: \u00a77" + String.join((CharSequence)", ", songs));
                    }
                    Util.showChatMessage("\u00a76----------------------------------------");
                }
                return true;
            }
            return false;
        }

        @Override
        public CompletableFuture<Suggestions> getSuggestions(String args, SuggestionsBuilder suggestionsBuilder) {
            return Util.giveSongDirectorySuggestions(args, suggestionsBuilder);
        }
    }

    private static class playlistCommand
    extends Command {
        private playlistCommand() {
        }

        @Override
        public String getName() {
            return "playlist";
        }

        @Override
        public String[] getSyntax() {
            return new String[]{"play <playlist>", "create <playlist>", "list [<playlist>]", "delete <playlist> <song>", "addSong <playlist> <song>", "removeSong <playlist> <song>", "renameSong <playlist> <index> <new name>", "loop", "shuffle"};
        }

        @Override
        public String getDescription() {
            return "Configures playlists";
        }

        @Override
        public boolean processCommand(String args) {
            String[] split = args.split(" ");
            if (split.length < 1) {
                return false;
            }
            try {
                Path playlistDir = null;
                if (split.length >= 2) {
                    playlistDir = SongPlayer.PLAYLISTS_DIR.resolve(split[1]);
                }
                switch (split[0].toLowerCase(Locale.ROOT)) {
                    case "play": {
                        if (split.length != 2) {
                            return false;
                        }
                        if (!Files.exists(playlistDir, new LinkOption[0])) {
                            Util.showChatMessage("\u00a7cPlaylist does not exist");
                            return true;
                        }
                        SongHandler.getInstance().setPlaylist(playlistDir);
                        return true;
                    }
                    case "create": {
                        if (split.length > 2) {
                            Util.showChatMessage("\u00a7cCannot have spaces in playlist name");
                            return true;
                        }
                        if (split.length != 2) {
                            return false;
                        }
                        Playlist.createPlaylist(split[1]);
                        Util.showChatMessage(String.format("\u00a76Created playlist \u00a73%s", split[1]));
                        return true;
                    }
                    case "delete": {
                        if (split.length != 2) {
                            return false;
                        }
                        Playlist.deletePlaylist(playlistDir);
                        Util.showChatMessage(String.format("\u00a76Deleted playlist \u00a73%s", split[1]));
                        return true;
                    }
                    case "list": {
                        if (split.length == 1) {
                            if (!Files.exists(SongPlayer.PLAYLISTS_DIR, new LinkOption[0])) {
                                return true;
                            }
                            List playlists = Files.list(SongPlayer.PLAYLISTS_DIR).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(Path::getFileName).map(Path::toString).collect(Collectors.toList());
                            if (playlists.size() == 0) {
                                Util.showChatMessage("\u00a76No playlists found");
                            } else {
                                Util.showChatMessage("\u00a76Playlists: \u00a73" + String.join((CharSequence)", ", playlists));
                            }
                            return true;
                        }
                        List<String> playlistIndex = Playlist.listSongs(playlistDir);
                        Util.showChatMessage("\u00a76------------------------------");
                        int index = 0;
                        for (String songName : playlistIndex) {
                            Util.showChatMessage(String.format("\u00a76%d. \u00a73%s", ++index, songName));
                        }
                        Util.showChatMessage("\u00a76------------------------------");
                        return true;
                    }
                    case "addsong": {
                        if (split.length < 3) {
                            return false;
                        }
                        String location = String.join((CharSequence)" ", Arrays.copyOfRange(split, 2, split.length));
                        Playlist.addSong(playlistDir, SongPlayer.SONG_DIR.resolve(location));
                        Util.showChatMessage(String.format("\u00a76Added \u00a73%s \u00a76to \u00a73%s", location, split[1]));
                        return true;
                    }
                    case "removesong": {
                        if (split.length < 3) {
                            return false;
                        }
                        String location = String.join((CharSequence)" ", Arrays.copyOfRange(split, 2, split.length));
                        Playlist.removeSong(playlistDir, location);
                        Util.showChatMessage(String.format("\u00a76Removed \u00a73%s \u00a76from \u00a73%s", location, split[1]));
                        return true;
                    }
                    case "renamesong": {
                        if (split.length < 4) {
                            return false;
                        }
                        String location = String.join((CharSequence)" ", Arrays.copyOfRange(split, 3, split.length));
                        int index = 0;
                        try {
                            index = Integer.parseInt(split[2]);
                        }
                        catch (Exception e) {
                            Util.showChatMessage(String.format("\u00a7cIndex must be an integer", new Object[0]));
                            return true;
                        }
                        String oldName = Playlist.renameSong(playlistDir, index - 1, location);
                        Util.showChatMessage(String.format("\u00a76Renamed \u00a73%s \u00a76to \u00a73%s", oldName, location));
                        return true;
                    }
                    case "loop": {
                        if (split.length != 1) {
                            return false;
                        }
                        Config.getConfig().loopPlaylists = !Config.getConfig().loopPlaylists;
                        SongHandler.getInstance().setPlaylistLoop(Config.getConfig().loopPlaylists);
                        if (Config.getConfig().loopPlaylists) {
                            Util.showChatMessage("\u00a76Enabled playlist looping");
                        } else {
                            Util.showChatMessage("\u00a76Disabled playlist looping");
                        }
                        Config.saveConfigWithErrorHandling();
                        return true;
                    }
                    case "shuffle": {
                        if (split.length != 1) {
                            return false;
                        }
                        Config.getConfig().shufflePlaylists = !Config.getConfig().shufflePlaylists;
                        SongHandler.getInstance().setPlaylistShuffle(Config.getConfig().shufflePlaylists);
                        if (Config.getConfig().shufflePlaylists) {
                            Util.showChatMessage("\u00a76Enabled playlist shuffling");
                        } else {
                            Util.showChatMessage("\u00a76Disabled playlist shuffling");
                        }
                        Config.saveConfigWithErrorHandling();
                        return true;
                    }
                }
                return false;
            }
            catch (IOException e) {
                Util.showChatMessage("\u00a7c" + e.getMessage());
                return true;
            }
        }

        @Override
        public CompletableFuture<Suggestions> getSuggestions(String args, SuggestionsBuilder suggestionsBuilder) {
            String[] split = args.split(" ", -1);
            if (split.length <= 1) {
                return class_2172.method_9253((String[])new String[]{"play", "create", "delete", "list", "addSong", "removeSong", "renameSong", "loop", "shuffle"}, (SuggestionsBuilder)suggestionsBuilder);
            }
            switch (split[0].toLowerCase(Locale.ROOT)) {
                default: {
                    return null;
                }
                case "play": 
                case "list": 
                case "delete": {
                    if (split.length == 2) {
                        return Util.givePlaylistSuggestions(suggestionsBuilder);
                    }
                    return null;
                }
                case "addsong": {
                    if (split.length == 2) {
                        return Util.givePlaylistSuggestions(suggestionsBuilder);
                    }
                    if (split.length >= 3) {
                        String location = String.join((CharSequence)" ", Arrays.copyOfRange(split, 2, split.length));
                        return Util.giveSongSuggestions(location, suggestionsBuilder);
                    }
                    return null;
                }
                case "removesong": {
                    if (split.length == 2) {
                        return Util.givePlaylistSuggestions(suggestionsBuilder);
                    }
                    if (split.length == 3) {
                        Path playlistDir = SongPlayer.PLAYLISTS_DIR.resolve(split[1]);
                        Stream<Path> playlistFiles = Playlist.getSongFiles(playlistDir);
                        if (playlistFiles == null) {
                            return null;
                        }
                        return class_2172.method_9264(playlistFiles.map(Path::getFileName).map(Path::toString), (SuggestionsBuilder)suggestionsBuilder);
                    }
                    return null;
                }
                case "renamesong": 
            }
            if (split.length == 2) {
                return Util.givePlaylistSuggestions(suggestionsBuilder);
            }
            if (split.length == 3) {
                Path playlistDir = SongPlayer.PLAYLISTS_DIR.resolve(split[1]);
                Stream<Path> playlistFiles = Playlist.getSongFiles(playlistDir);
                if (playlistFiles == null) {
                    return null;
                }
                int max = playlistFiles.collect(Collectors.toList()).size();
                Stream<String> suggestions = IntStream.range(1, max + 1).mapToObj(Integer::toString);
                return class_2172.method_9264(suggestions, (SuggestionsBuilder)suggestionsBuilder);
            }
            return null;
        }
    }

    private static class setCreativeCommandCommand
    extends Command {
        private setCreativeCommandCommand() {
        }

        @Override
        public String getName() {
            return "setCreativeCommand";
        }

        @Override
        public String[] getAliases() {
            return new String[]{"sc"};
        }

        @Override
        public String[] getSyntax() {
            return new String[]{"<command>"};
        }

        @Override
        public String getDescription() {
            return "Sets the command used to go into creative mode";
        }

        @Override
        public boolean processCommand(String args) {
            if (args.length() > 0) {
                Config.getConfig().creativeCommand = args.startsWith("/") ? args.substring(1) : args;
                Util.showChatMessage("\u00a76Set creative command to \u00a73/" + Config.getConfig().creativeCommand);
                Config.saveConfigWithErrorHandling();
                return true;
            }
            return false;
        }
    }

    private static class setSurvivalCommandCommand
    extends Command {
        private setSurvivalCommandCommand() {
        }

        @Override
        public String getName() {
            return "setSurvivalCommand";
        }

        @Override
        public String[] getAliases() {
            return new String[]{"ss"};
        }

        @Override
        public String[] getSyntax() {
            return new String[]{"<command>"};
        }

        @Override
        public String getDescription() {
            return "Sets the command used to go into survival mode";
        }

        @Override
        public boolean processCommand(String args) {
            if (args.length() > 0) {
                Config.getConfig().survivalCommand = args.startsWith("/") ? args.substring(1) : args;
                Util.showChatMessage("\u00a76Set survival command to \u00a73/" + Config.getConfig().survivalCommand);
                Config.saveConfigWithErrorHandling();
                return true;
            }
            return false;
        }
    }

    private static class useEssentialsCommandsCommand
    extends Command {
        private useEssentialsCommandsCommand() {
        }

        @Override
        public String getName() {
            return "useEssentialsCommands";
        }

        @Override
        public String[] getAliases() {
            return new String[]{"essentials", "useEssentials", "essentialsCommands"};
        }

        @Override
        public String[] getSyntax() {
            return new String[0];
        }

        @Override
        public String getDescription() {
            return "Switches to using essentials gamemode commands";
        }

        @Override
        public boolean processCommand(String args) {
            if (args.length() == 0) {
                Config.getConfig().creativeCommand = "gmc";
                Config.getConfig().survivalCommand = "gms";
                Util.showChatMessage("\u00a76Now using essentials gamemode commands");
                Config.saveConfigWithErrorHandling();
                return true;
            }
            return false;
        }
    }

    private static class useVanillaCommandsCommand
    extends Command {
        private useVanillaCommandsCommand() {
        }

        @Override
        public String getName() {
            return "useVanillaCommands";
        }

        @Override
        public String[] getAliases() {
            return new String[]{"vanilla", "useVanilla", "vanillaCommands"};
        }

        @Override
        public String[] getSyntax() {
            return new String[0];
        }

        @Override
        public String getDescription() {
            return "Switches to using vanilla gamemode commands";
        }

        @Override
        public boolean processCommand(String args) {
            if (args.length() == 0) {
                Config.getConfig().creativeCommand = "gamemode creative";
                Config.getConfig().survivalCommand = "gamemode survival";
                Util.showChatMessage("\u00a76Now using vanilla gamemode commands");
                Config.saveConfigWithErrorHandling();
                return true;
            }
            return false;
        }
    }

    private static class toggleFakePlayerCommand
    extends Command {
        private toggleFakePlayerCommand() {
        }

        @Override
        public String getName() {
            return "toggleFakePlayer";
        }

        @Override
        public String[] getAliases() {
            return new String[]{"fakePlayer", "fp"};
        }

        @Override
        public String[] getSyntax() {
            return new String[0];
        }

        @Override
        public String getDescription() {
            return "Shows a fake player representing your true position when playing songs";
        }

        @Override
        public boolean processCommand(String args) {
            if (args.length() == 0) {
                boolean bl = Config.getConfig().showFakePlayer = !Config.getConfig().showFakePlayer;
                if (Config.getConfig().showFakePlayer) {
                    Util.showChatMessage("\u00a76Enabled fake player");
                } else {
                    Util.showChatMessage("\u00a76Disabled fake player");
                }
                Config.saveConfigWithErrorHandling();
                return true;
            }
            return false;
        }
    }

    private static class setStageTypeCommand
    extends Command {
        private setStageTypeCommand() {
        }

        @Override
        public String getName() {
            return "setStageType";
        }

        @Override
        public String[] getAliases() {
            return new String[]{"setStage", "stageType"};
        }

        @Override
        public String[] getSyntax() {
            return new String[]{"<DEFAULT | WIDE | SPHERICAL>"};
        }

        @Override
        public String getDescription() {
            return "Sets the type of noteblock stage to build";
        }

        @Override
        public boolean processCommand(String args) {
            if (args.length() > 0) {
                try {
                    Stage.StageType stageType;
                    Config.getConfig().stageType = stageType = Stage.StageType.valueOf(args.toUpperCase(Locale.ROOT));
                    Util.showChatMessage("\u00a76Set stage type to \u00a73" + stageType.name());
                    Config.saveConfigWithErrorHandling();
                }
                catch (IllegalArgumentException e) {
                    Util.showChatMessage("\u00a7cInvalid stage type");
                }
                return true;
            }
            return false;
        }

        @Override
        public CompletableFuture<Suggestions> getSuggestions(String args, SuggestionsBuilder suggestionsBuilder) {
            if (!args.contains(" ")) {
                return class_2172.method_9264(Arrays.stream(Stage.StageType.values()).map(Enum::name), (SuggestionsBuilder)suggestionsBuilder);
            }
            return null;
        }
    }

    private static class breakSpeedCommand
    extends Command {
        private breakSpeedCommand() {
        }

        @Override
        public String getName() {
            return "breakSpeed";
        }

        @Override
        public String[] getSyntax() {
            return new String[]{"set <speed>", "reset"};
        }

        @Override
        public String getDescription() {
            return "Sets the block breaking speed in blocks/sec";
        }

        @Override
        public boolean processCommand(String args) {
            if (args.length() == 0) {
                return false;
            }
            String[] split = args.split(" ");
            switch (split[0].toLowerCase(Locale.ROOT)) {
                case "set": {
                    double speed;
                    if (split.length != 2) {
                        return false;
                    }
                    try {
                        speed = Double.parseDouble(split[1]);
                    }
                    catch (NumberFormatException e) {
                        Util.showChatMessage("\u00a7cSpeed must be a number");
                        return true;
                    }
                    if (speed <= 0.0) {
                        Util.showChatMessage("\u00a7cSpeed must be greater than 0");
                        return true;
                    }
                    Config.getConfig().breakSpeed = speed;
                    Config.saveConfigWithErrorHandling();
                    Util.showChatMessage("\u00a76Set block breaking speed to \u00a73" + Config.getConfig().breakSpeed + " \u00a76blocks/sec");
                    return true;
                }
                case "reset": {
                    if (split.length != 1) {
                        return false;
                    }
                    Config.getConfig().breakSpeed = 40.0;
                    Config.saveConfigWithErrorHandling();
                    Util.showChatMessage("\u00a76Reset block breaking speed to \u00a73" + Config.getConfig().breakSpeed + " \u00a76blocks/sec");
                    return true;
                }
            }
            return false;
        }

        @Override
        public CompletableFuture<Suggestions> getSuggestions(String args, SuggestionsBuilder suggestionsBuilder) {
            String[] split = args.split(" ", -1);
            if (split.length <= 1) {
                return class_2172.method_9253((String[])new String[]{"set", "reset"}, (SuggestionsBuilder)suggestionsBuilder);
            }
            return null;
        }
    }

    private static class placeSpeedCommand
    extends Command {
        private placeSpeedCommand() {
        }

        @Override
        public String getName() {
            return "placeSpeed";
        }

        @Override
        public String[] getSyntax() {
            return new String[]{"set <speed>", "reset"};
        }

        @Override
        public String getDescription() {
            return "Sets the block placement speed in blocks/sec";
        }

        @Override
        public boolean processCommand(String args) {
            if (args.length() == 0) {
                return false;
            }
            String[] split = args.split(" ");
            switch (split[0].toLowerCase(Locale.ROOT)) {
                case "set": {
                    double speed;
                    if (split.length != 2) {
                        return false;
                    }
                    try {
                        speed = Double.parseDouble(split[1]);
                    }
                    catch (NumberFormatException e) {
                        Util.showChatMessage("\u00a7cSpeed must be a number");
                        return true;
                    }
                    if (speed <= 0.0) {
                        Util.showChatMessage("\u00a7cSpeed must be greater than 0");
                        return true;
                    }
                    Config.getConfig().placeSpeed = speed;
                    Config.saveConfigWithErrorHandling();
                    Util.showChatMessage("\u00a76Set block placement speed to \u00a73" + Config.getConfig().placeSpeed + " \u00a76blocks/sec");
                    return true;
                }
                case "reset": {
                    if (split.length != 1) {
                        return false;
                    }
                    Config.getConfig().placeSpeed = 20.0;
                    Config.saveConfigWithErrorHandling();
                    Util.showChatMessage("\u00a76Reset block placement speed to \u00a73" + Config.getConfig().placeSpeed + " \u00a76blocks/sec");
                    return true;
                }
            }
            return false;
        }

        @Override
        public CompletableFuture<Suggestions> getSuggestions(String args, SuggestionsBuilder suggestionsBuilder) {
            String[] split = args.split(" ", -1);
            if (split.length <= 1) {
                return class_2172.method_9253((String[])new String[]{"set", "reset"}, (SuggestionsBuilder)suggestionsBuilder);
            }
            return null;
        }
    }

    private static class toggleMovementCommand
    extends Command {
        private toggleMovementCommand() {
        }

        @Override
        public String getName() {
            return "toggleMovement";
        }

        @Override
        public String[] getAliases() {
            return new String[]{"movement"};
        }

        @Override
        public String[] getSyntax() {
            return new String[]{"<swing | rotate>"};
        }

        @Override
        public String getDescription() {
            return "Toggles different types of movements";
        }

        @Override
        public boolean processCommand(String args) {
            switch (args.toLowerCase(Locale.ROOT)) {
                case "swing": {
                    boolean bl = Config.getConfig().swing = !Config.getConfig().swing;
                    if (Config.getConfig().swing) {
                        Util.showChatMessage("\u00a76Enabled arm swinging");
                    } else {
                        Util.showChatMessage("\u00a76Disabled arm swinging");
                    }
                    Config.saveConfigWithErrorHandling();
                    return true;
                }
                case "rotate": {
                    boolean bl = Config.getConfig().rotate = !Config.getConfig().rotate;
                    if (Config.getConfig().rotate) {
                        Util.showChatMessage("\u00a76Enabled player rotation");
                    } else {
                        Util.showChatMessage("\u00a76Disabled player rotation");
                    }
                    Config.saveConfigWithErrorHandling();
                    return true;
                }
            }
            return false;
        }

        @Override
        public CompletableFuture<Suggestions> getSuggestions(String args, SuggestionsBuilder suggestionsBuilder) {
            if (!args.contains(" ")) {
                return class_2172.method_9253((String[])new String[]{"swing", "rotate"}, (SuggestionsBuilder)suggestionsBuilder);
            }
            return null;
        }
    }

    private static class setVelocityThresholdCommand
    extends Command {
        private setVelocityThresholdCommand() {
        }

        @Override
        public String getName() {
            return "setVelocityThreshold";
        }

        @Override
        public String[] getAliases() {
            return new String[]{"velocityThreshold", "threshold"};
        }

        @Override
        public String[] getSyntax() {
            return new String[]{"<threshold>"};
        }

        @Override
        public String getDescription() {
            return "Sets the minimum velocity below which notes won't be played (applies to midi and nbs). This must be a number from 0 to 100. For song items, the threshold is baked in upon item creation.";
        }

        @Override
        public boolean processCommand(String args) {
            if (args.length() > 0) {
                try {
                    int threshold = Integer.parseInt(args);
                    if (threshold < 0 || threshold > 100) {
                        Util.showChatMessage("\u00a7cVelocity threshold must be a value between 0 and 100");
                        return true;
                    }
                    Config.getConfig().velocityThreshold = threshold;
                    Util.showChatMessage("\u00a76Set velocity threshold to " + threshold);
                    Config.saveConfigWithErrorHandling();
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            return false;
        }
    }

    private static class toggleAutoCleanupCommand
    extends Command {
        private toggleAutoCleanupCommand() {
        }

        @Override
        public String getName() {
            return "toggleAutoCleanup";
        }

        @Override
        public String[] getAliases() {
            return new String[]{"autoCleanup"};
        }

        @Override
        public String[] getSyntax() {
            return new String[0];
        }

        @Override
        public String getDescription() {
            return "Toggles whether you automatically clean up your stage and restore the original blocks after playing";
        }

        @Override
        public boolean processCommand(String args) {
            if (args.length() == 0) {
                boolean bl = Config.getConfig().autoCleanup = !Config.getConfig().autoCleanup;
                if (Config.getConfig().autoCleanup) {
                    Util.showChatMessage("\u00a76Enabled automatic cleanup");
                } else {
                    Util.showChatMessage("\u00a76Disabled automatic cleanup");
                }
                Config.saveConfigWithErrorHandling();
                return true;
            }
            return false;
        }
    }

    private static class cleanupLastStageCommand
    extends Command {
        private cleanupLastStageCommand() {
        }

        @Override
        public String getName() {
            return "cleanupLastStage";
        }

        @Override
        public String[] getAliases() {
            return new String[0];
        }

        @Override
        public String[] getSyntax() {
            return new String[0];
        }

        @Override
        public String getDescription() {
            return "Cleans up your most recent stage and restores the original blocks";
        }

        @Override
        public boolean processCommand(String args) {
            if (args.length() == 0) {
                Stage lastStage = SongHandler.getInstance().lastStage;
                if (!SongHandler.getInstance().isIdle()) {
                    Util.showChatMessage("\u00a7cYou cannot start cleanup if you are in the middle of another action");
                    return true;
                }
                if (lastStage == null || SongHandler.getInstance().originalBlocks.size() == 0 || !lastStage.serverIdentifier.equals(Util.getServerIdentifier())) {
                    Util.showChatMessage("\u00a76There is nothing to clean up");
                    return true;
                }
                if (SongPlayer.MC.field_1724.method_19538().method_1025(lastStage.getOriginBottomCenter()) > 9.0 || !lastStage.worldName.equals(Util.getWorldName())) {
                    String coordStr = String.format("%d %d %d", lastStage.position.method_10263(), lastStage.position.method_10264(), lastStage.position.method_10260());
                    Util.showChatMessage("\u00a76You must be within \u00a733 \u00a76blocks of the center of your stage to start cleanup.");
                    class_5250 coordText = Util.joinTexts(null, new class_2561[]{class_2561.method_43470((String)"This is at ").method_10862(class_2583.field_24360.method_10977(class_124.field_1065)), class_2561.method_43470((String)coordStr).method_10862(class_2583.field_24360.method_10977(class_124.field_1062).method_30938(Boolean.valueOf(true)).method_10958((class_2558)new class_2558.class_10606(coordStr)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("Copy \"" + coordStr + "\""))))), class_2561.method_43470((String)" in world ").method_10862(class_2583.field_24360.method_10977(class_124.field_1065)), class_2561.method_43470((String)lastStage.worldName).method_10862(class_2583.field_24360.method_10977(class_124.field_1062))});
                    Util.showChatMessage((class_2561)coordText);
                    return true;
                }
                SongHandler.getInstance().startCleanup();
                return true;
            }
            return false;
        }
    }

    private static class announcementCommand
    extends Command {
        private announcementCommand() {
        }

        @Override
        public String getName() {
            return "announcement";
        }

        @Override
        public String[] getSyntax() {
            return new String[]{"enable", "disable", "getMessage", "setMessage <message>"};
        }

        @Override
        public String getDescription() {
            return "Set an announcement message that is sent when you start playing a song. With setMessage, write [name] where the song name should go.";
        }

        @Override
        public boolean processCommand(String args) {
            String[] split = args.split(" ", 2);
            switch (split[0].toLowerCase(Locale.ROOT)) {
                case "enable": {
                    if (split.length != 1) {
                        return false;
                    }
                    Config.getConfig().doAnnouncement = true;
                    Util.showChatMessage("\u00a76Enabled song announcements");
                    Config.saveConfigWithErrorHandling();
                    return true;
                }
                case "disable": {
                    if (split.length != 1) {
                        return false;
                    }
                    Config.getConfig().doAnnouncement = false;
                    Util.showChatMessage("\u00a76Disabled song announcements");
                    Config.saveConfigWithErrorHandling();
                    return true;
                }
                case "getmessage": {
                    if (split.length != 1) {
                        return false;
                    }
                    Util.showChatMessage("\u00a76Current announcement message is \u00a7r" + Config.getConfig().announcementMessage);
                    return true;
                }
                case "setmessage": {
                    if (split.length != 2) {
                        return false;
                    }
                    Config.getConfig().announcementMessage = split[1];
                    Util.showChatMessage("\u00a76Set announcement message to \u00a7r" + split[1]);
                    Config.saveConfigWithErrorHandling();
                    return true;
                }
            }
            return false;
        }

        @Override
        public CompletableFuture<Suggestions> getSuggestions(String args, SuggestionsBuilder suggestionsBuilder) {
            if (!args.contains(" ")) {
                return class_2172.method_9253((String[])new String[]{"enable", "disable", "getMessage", "setMessage"}, (SuggestionsBuilder)suggestionsBuilder);
            }
            return null;
        }
    }

    private static class toggleSurvivalOnlyCommand
    extends Command {
        private toggleSurvivalOnlyCommand() {
        }

        @Override
        public String getName() {
            return "toggleSurvivalOnly";
        }

        @Override
        public String[] getAliases() {
            return new String[]{"survivalOnly"};
        }

        @Override
        public String[] getSyntax() {
            return new String[0];
        }

        @Override
        public String getDescription() {
            return "Enables or disables survival-only mode, in which automatic noteblock placement is disabled and automatic tuning is done by right-clicking.";
        }

        @Override
        public boolean processCommand(String args) {
            if (args.length() == 0) {
                if (!SongHandler.getInstance().isIdle()) {
                    Util.showChatMessage("\u00a7cYou cannot change this setting while playing or building");
                    return true;
                }
                boolean bl = Config.getConfig().survivalOnly = !Config.getConfig().survivalOnly;
                if (Config.getConfig().survivalOnly) {
                    Util.showChatMessage("\u00a76Enabled survival only mode");
                } else {
                    Util.showChatMessage("\u00a76Disabled survival only mode");
                }
                Config.saveConfigWithErrorHandling();
                return true;
            }
            return false;
        }
    }

    private static class toggleFlightNoclipCommand
    extends Command {
        private toggleFlightNoclipCommand() {
        }

        @Override
        public String getName() {
            return "toggleFlightNoclip";
        }

        @Override
        public String[] getAliases() {
            return new String[]{"flightNoclip"};
        }

        @Override
        public String[] getSyntax() {
            return new String[0];
        }

        @Override
        public String getDescription() {
            return "Toggles flight noclip. When enabled, your local player can clip through blocks when flying while playing a song.";
        }

        @Override
        public boolean processCommand(String args) {
            if (args.length() == 0) {
                boolean bl = Config.getConfig().flightNoclip = !Config.getConfig().flightNoclip;
                if (Config.getConfig().flightNoclip) {
                    Util.showChatMessage("\u00a76Enabled flight noclip");
                } else {
                    Util.showChatMessage("\u00a76Disabled flight noclip");
                }
                Config.saveConfigWithErrorHandling();
                return true;
            }
            return false;
        }
    }

    private static class songItemCommand
    extends Command {
        private songItemCommand() {
        }

        @Override
        public String getName() {
            return "songItem";
        }

        @Override
        public String[] getAliases() {
            return new String[]{"item"};
        }

        @Override
        public String[] getSyntax() {
            return new String[]{"create <song or url>", "setSongName <name>"};
        }

        @Override
        public String getDescription() {
            return "Assigns/edits song data for the item in your hand";
        }

        @Override
        public boolean processCommand(String args) {
            if (args.length() == 0) {
                return false;
            }
            if (SongPlayer.MC.field_1761.method_2920() != class_1934.field_9220) {
                Util.showChatMessage("\u00a7cYou must be in creative mode to use this command");
                return true;
            }
            class_1799 stack = SongPlayer.MC.field_1724.method_6047();
            String[] split = args.split(" ");
            switch (split[0].toLowerCase(Locale.ROOT)) {
                case "create": {
                    if (split.length < 2) {
                        return false;
                    }
                    String location = String.join((CharSequence)" ", Arrays.copyOfRange(split, 1, split.length));
                    try {
                        new SongItemCreatorThread(location).start();
                    }
                    catch (IOException e) {
                        Util.showChatMessage("\u00a7cError creating song item: \u00a74" + e.getMessage());
                    }
                    return true;
                }
                case "setsongname": {
                    if (split.length < 2) {
                        return false;
                    }
                    if (SongItemUtils.isSongItem(stack)) {
                        String name = String.join((CharSequence)" ", Arrays.copyOfRange(split, 1, split.length));
                        SongItemUtils.updateSongItemTag(stack, songItemTag -> songItemTag.method_10582("DisplayName", name));
                        SongItemUtils.addSongItemDisplay(stack);
                        SongPlayer.MC.field_1724.method_6122(class_1268.field_5808, stack);
                        SongPlayer.MC.field_1761.method_2909(SongPlayer.MC.field_1724.method_5998(class_1268.field_5808), 36 + SongPlayer.MC.field_1724.method_31548().method_67532());
                        Util.showChatMessage("\u00a76Set song display name to \u00a73" + name);
                        return true;
                    }
                    Util.showChatMessage("\u00a7cYou must be holding a song item");
                    return true;
                }
            }
            return false;
        }

        @Override
        public CompletableFuture<Suggestions> getSuggestions(String args, SuggestionsBuilder suggestionsBuilder) {
            String[] split = args.split(" ", -1);
            if (split.length <= 1) {
                return class_2172.method_9253((String[])new String[]{"create", "setSongName"}, (SuggestionsBuilder)suggestionsBuilder);
            }
            switch (split[0].toLowerCase(Locale.ROOT)) {
                case "create": {
                    if (split.length < 2) break;
                    String location = String.join((CharSequence)" ", Arrays.copyOfRange(split, 1, split.length));
                    return Util.giveSongSuggestions(location, suggestionsBuilder);
                }
            }
            return null;
        }
    }

    private static class testSongCommand
    extends Command {
        private testSongCommand() {
        }

        @Override
        public String getName() {
            return "testSong";
        }

        @Override
        public String[] getSyntax() {
            return new String[0];
        }

        @Override
        public String getDescription() {
            return "Creates a song for testing";
        }

        @Override
        public boolean processCommand(String args) {
            if (args.length() == 0) {
                Song song = new Song("test_song");
                for (int i = 0; i < 400; ++i) {
                    song.add(new Note(i, i * 50));
                }
                song.length = 20000L;
                SongHandler.getInstance().setSong(song);
                return true;
            }
            return false;
        }
    }

    private static abstract class Command {
        private Command() {
        }

        public abstract String getName();

        public abstract String[] getSyntax();

        public abstract String getDescription();

        public abstract boolean processCommand(String var1);

        public String[] getAliases() {
            return new String[0];
        }

        public CompletableFuture<Suggestions> getSuggestions(String args, SuggestionsBuilder suggestionsBuilder) {
            return null;
        }
    }
}

