/*
 * Decompiled with CFR 0.152.
 */
package com.github.hhhzzzsss.songplayer;

import com.github.hhhzzzsss.songplayer.SongPlayer;
import com.github.hhhzzzsss.songplayer.Util;
import com.github.hhhzzzsss.songplayer.playing.Stage;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class Config {
    private static Config config = null;
    public static final Path CONFIG_FILE = SongPlayer.SONGPLAYER_DIR.resolve("config.json");
    private static final Gson gson = new Gson();
    public String prefix = "$";
    public String creativeCommand = "gamemode creative";
    public String survivalCommand = "gamemode survival";
    public boolean showFakePlayer = false;
    public boolean loopPlaylists = false;
    public boolean shufflePlaylists = false;
    public Stage.StageType stageType = Stage.StageType.DEFAULT;
    public boolean swing = false;
    public boolean rotate = false;
    public int velocityThreshold = 0;
    public boolean doAnnouncement = false;
    public String announcementMessage = "&6Now playing: &3[name]";
    public double breakSpeed = 40.0;
    public double placeSpeed = 20.0;
    public boolean autoCleanup = false;
    public boolean survivalOnly = false;
    public boolean flightNoclip = false;

    public static Config getConfig() {
        if (config == null) {
            config = new Config();
            try {
                if (Files.exists(CONFIG_FILE, new LinkOption[0])) {
                    Config.loadConfig();
                } else {
                    Config.saveConfig();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return config;
    }

    public static void loadConfig() throws IOException {
        BufferedReader reader = Files.newBufferedReader(CONFIG_FILE);
        config = (Config)gson.fromJson((Reader)reader, Config.class);
        reader.close();
    }

    public static void saveConfig() throws IOException {
        BufferedWriter writer = Files.newBufferedWriter(CONFIG_FILE, new OpenOption[0]);
        writer.write(gson.toJson((Object)config));
        writer.close();
    }

    public static void saveConfigWithErrorHandling() {
        try {
            Config.saveConfig();
        }
        catch (IOException e) {
            if (SongPlayer.MC.field_1687 != null) {
                Util.showChatMessage("\u00a7cFailed to save config file");
            }
            e.printStackTrace();
        }
    }
}

