/*
 * Decompiled with CFR 0.152.
 */
package com.github.hhhzzzsss.songplayer;

import com.github.hhhzzzsss.songplayer.SongPlayer;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_5218;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.class_8828;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public class Util {
    static final class_310 MC = class_310.method_1551();
    public static Pattern timePattern = Pattern.compile("(?:(\\d+):)?(\\d+):(\\d+)");

    public static void createDirectoriesSilently(Path path) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Path resolveWithIOException(Path path, String other) throws IOException {
        try {
            return path.resolve(other);
        }
        catch (InvalidPathException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static String formatTime(long milliseconds) {
        long temp = Math.abs(milliseconds);
        long seconds = (temp /= 1000L) % 60L;
        long minutes = (temp /= 60L) % 60L;
        long hours = temp /= 60L;
        StringBuilder sb = new StringBuilder();
        if (milliseconds < 0L) {
            sb.append("-");
        }
        if (hours > 0L) {
            sb.append(String.format("%d:", hours));
            sb.append(String.format("%02d:", minutes));
        } else {
            sb.append(String.format("%d:", minutes));
        }
        sb.append(String.format("%02d", seconds));
        return sb.toString();
    }

    public static long parseTime(String timeStr) throws IOException {
        Matcher matcher = timePattern.matcher(timeStr);
        if (matcher.matches()) {
            long time = 0L;
            String hourString = matcher.group(1);
            String minuteString = matcher.group(2);
            String secondString = matcher.group(3);
            if (hourString != null) {
                time += (long)(Integer.parseInt(hourString) * 60 * 60 * 1000);
            }
            time += (long)(Integer.parseInt(minuteString) * 60 * 1000);
            time = (long)((double)time + Double.parseDouble(secondString) * 1000.0);
            return time;
        }
        throw new IOException("Invalid time pattern");
    }

    public static CompletableFuture<Suggestions> giveSongSuggestions(String arg, SuggestionsBuilder suggestionsBuilder) {
        Stream<Path> songFiles;
        int lastSlash = arg.lastIndexOf("/");
        String dirString = "";
        Path dir = SongPlayer.SONG_DIR;
        if (lastSlash >= 0) {
            dirString = arg.substring(0, lastSlash + 1);
            try {
                dir = Util.resolveWithIOException(dir, dirString);
            }
            catch (IOException e) {
                return null;
            }
        }
        try {
            songFiles = Files.list(dir);
        }
        catch (IOException e) {
            return null;
        }
        int clipStart = arg.contains(" ") ? arg.lastIndexOf(" ") + 1 : 0;
        ArrayList<CallSite> suggestionsList = new ArrayList<CallSite>();
        for (Path path : songFiles.collect(Collectors.toList())) {
            if (Files.isRegularFile(path, new LinkOption[0])) {
                suggestionsList.add((CallSite)((Object)(dirString + path.getFileName().toString())));
                continue;
            }
            if (!Files.isDirectory(path, new LinkOption[0])) continue;
            suggestionsList.add((CallSite)((Object)(dirString + path.getFileName().toString() + "/")));
        }
        Stream<String> suggestions = suggestionsList.stream().filter(str -> str.startsWith(arg)).map(str -> str.substring(clipStart));
        return class_2172.method_9264(suggestions, (SuggestionsBuilder)suggestionsBuilder);
    }

    public static CompletableFuture<Suggestions> givePlaylistSuggestions(SuggestionsBuilder suggestionsBuilder) {
        if (!Files.exists(SongPlayer.PLAYLISTS_DIR, new LinkOption[0])) {
            return null;
        }
        try {
            return class_2172.method_9264(Files.list(SongPlayer.PLAYLISTS_DIR).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(Path::getFileName).map(Path::toString), (SuggestionsBuilder)suggestionsBuilder);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static CompletableFuture<Suggestions> giveSongDirectorySuggestions(String arg, SuggestionsBuilder suggestionsBuilder) {
        Stream<Path> songFiles;
        String dirString;
        int lastSlash = arg.lastIndexOf("/");
        Path dir = SongPlayer.SONG_DIR;
        if (lastSlash >= 0) {
            dirString = arg.substring(0, lastSlash + 1);
            try {
                dir = Util.resolveWithIOException(dir, dirString);
            }
            catch (IOException e) {
                return null;
            }
        } else {
            dirString = "";
        }
        try {
            songFiles = Files.list(dir);
        }
        catch (IOException e) {
            return null;
        }
        int clipStart = arg.contains(" ") ? arg.lastIndexOf(" ") + 1 : 0;
        Stream<String> suggestions = songFiles.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(path -> dirString + path.getFileName().toString() + "/").filter(str -> str.startsWith(arg)).map(str -> str.substring(clipStart));
        return class_2172.method_9264(suggestions, (SuggestionsBuilder)suggestionsBuilder);
    }

    public static class_5250 getStyledText(String str, class_2583 style) {
        class_5250 text = class_5250.method_43477((class_7417)class_8828.method_54232((String)str));
        text.method_10862(style);
        return text;
    }

    public static void setItemName(class_1799 stack, class_2561 text) {
        stack.method_57379(class_9334.field_49631, (Object)text);
    }

    public static void setItemLore(class_1799 stack, class_2561 ... loreLines) {
        stack.method_57379(class_9334.field_49632, (Object)new class_9290(List.of(loreLines)));
    }

    public static class_5250 joinTexts(class_5250 base, class_2561 ... children) {
        if (base == null) {
            base = class_2561.method_43473();
        }
        for (class_2561 child : children) {
            base.method_10852(child);
        }
        return base;
    }

    public static String getWorldName() {
        return Util.MC.field_1687.method_27983().method_29177().toString();
    }

    public static String getServerIdentifier() {
        if (MC.method_1542()) {
            return "local;" + MC.method_1576().method_27050(class_5218.field_24188).getParent().getFileName().toString();
        }
        return "remote;" + Util.MC.method_1558().field_3761;
    }

    public static void showChatMessage(String message) {
        Util.MC.field_1724.method_7353(class_2561.method_30163((String)message), false);
    }

    public static void showChatMessage(class_2561 text) {
        Util.MC.field_1724.method_7353(text, false);
    }

    public static void sendChatMessage(String message) {
        Util.MC.field_1724.field_3944.method_45729(message);
    }

    public static void sendCommand(String command) {
        Util.MC.field_1724.field_3944.method_45730(command);
    }

    public static class LimitedSizeInputStream
    extends InputStream {
        private final InputStream original;
        private final long maxSize;
        private long total;

        public LimitedSizeInputStream(InputStream original, long maxSize) {
            this.original = original;
            this.maxSize = maxSize;
        }

        @Override
        public int read() throws IOException {
            int i = this.original.read();
            if (i >= 0) {
                this.incrementCounter(1);
            }
            return i;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int i = this.original.read(b, off, len);
            if (i >= 0) {
                this.incrementCounter(i);
            }
            return i;
        }

        private void incrementCounter(int size) throws IOException {
            this.total += (long)size;
            if (this.total > this.maxSize) {
                throw new IOException("Input stream exceeded maximum size of " + this.maxSize + " bytes");
            }
        }
    }
}

