/*
 * Decompiled with CFR 0.152.
 */
package com.github.hhhzzzsss.songplayer.conversion;

import com.github.hhhzzzsss.songplayer.song.DownloadUtils;
import com.github.hhhzzzsss.songplayer.song.Instrument;
import com.github.hhhzzzsss.songplayer.song.Note;
import com.github.hhhzzzsss.songplayer.song.Song;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;

public class MidiConverter {
    public static final int SET_INSTRUMENT = 192;
    public static final int SET_TEMPO = 81;
    public static final int NOTE_ON = 144;
    public static final int NOTE_OFF = 128;
    public static HashMap<Integer, Instrument[]> instrumentMap = new HashMap();
    public static HashMap<Integer, Integer> percussionMap;

    public static Song getSongFromUrl(URL url) throws IOException, InvalidMidiDataException, URISyntaxException, NoSuchAlgorithmException, KeyManagementException {
        Sequence sequence = MidiSystem.getSequence(DownloadUtils.DownloadToInputStream(url, 0x500000));
        return MidiConverter.getSong(sequence, Paths.get(url.toURI().getPath(), new String[0]).getFileName().toString());
    }

    public static Song getSongFromFile(Path file) throws InvalidMidiDataException, IOException {
        Sequence sequence = MidiSystem.getSequence(file.toFile());
        return MidiConverter.getSong(sequence, file.getFileName().toString());
    }

    public static Song getSongFromBytes(byte[] bytes, String name) throws InvalidMidiDataException, IOException {
        Sequence sequence = MidiSystem.getSequence(new ByteArrayInputStream(bytes));
        return MidiConverter.getSong(sequence, name);
    }

    public static Song getSong(Sequence sequence, String name) {
        Song song = new Song(name);
        long tpq = sequence.getResolution();
        ArrayList<MidiEvent> tempoEvents = new ArrayList<MidiEvent>();
        for (Track track : sequence.getTracks()) {
            for (int i = 0; i < track.size(); ++i) {
                MetaMessage mm;
                MidiEvent event = track.get(i);
                MidiMessage message = event.getMessage();
                if (!(message instanceof MetaMessage) || (mm = (MetaMessage)message).getType() != 81) continue;
                tempoEvents.add(event);
            }
        }
        Collections.sort(tempoEvents, (a, b) -> Long.compare(a.getTick(), b.getTick()));
        for (Track track : sequence.getTracks()) {
            long microTime = 0L;
            int[] instrumentIds = new int[16];
            int mpq = 500000;
            int tempoEventIdx = 0;
            long prevTick = 0L;
            for (int i = 0; i < track.size(); ++i) {
                MidiEvent event = track.get(i);
                MidiMessage message = event.getMessage();
                while (tempoEventIdx < tempoEvents.size() && event.getTick() > ((MidiEvent)tempoEvents.get(tempoEventIdx)).getTick()) {
                    long deltaTick = ((MidiEvent)tempoEvents.get(tempoEventIdx)).getTick() - prevTick;
                    prevTick = ((MidiEvent)tempoEvents.get(tempoEventIdx)).getTick();
                    microTime += (long)mpq / tpq * deltaTick;
                    MetaMessage mm = (MetaMessage)((MidiEvent)tempoEvents.get(tempoEventIdx)).getMessage();
                    byte[] data = mm.getData();
                    int new_mpq = data[2] & 0xFF | (data[1] & 0xFF) << 8 | (data[0] & 0xFF) << 16;
                    if (new_mpq != 0) {
                        mpq = new_mpq;
                    }
                    ++tempoEventIdx;
                }
                if (!(message instanceof ShortMessage)) continue;
                ShortMessage sm = (ShortMessage)message;
                if (sm.getCommand() == 192) {
                    instrumentIds[sm.getChannel()] = sm.getData1();
                    continue;
                }
                if (sm.getCommand() == 144) {
                    long time;
                    int pitch = sm.getData1();
                    int velocity = sm.getData2();
                    if (velocity == 0) continue;
                    velocity = velocity * 100 / 127;
                    long deltaTick = event.getTick() - prevTick;
                    prevTick = event.getTick();
                    Note note = sm.getChannel() == 9 ? MidiConverter.getMidiPercussionNote(pitch, velocity, microTime) : MidiConverter.getMidiInstrumentNote(instrumentIds[sm.getChannel()], pitch, velocity, microTime += (long)mpq / tpq * deltaTick);
                    if (note != null) {
                        song.add(note);
                    }
                    if ((time = microTime / 1000L) <= song.length) continue;
                    song.length = time;
                    continue;
                }
                if (sm.getCommand() != 128) continue;
                long deltaTick = event.getTick() - prevTick;
                prevTick = event.getTick();
                long time = (microTime += (long)mpq / tpq * deltaTick) / 1000L;
                if (time <= song.length) continue;
                song.length = time;
            }
        }
        song.sort();
        if (!song.notes.isEmpty()) {
            long shift = song.notes.get((int)0).time - 1000L;
            if (song.notes.get((int)0).time > 1000L) {
                for (Note note : song.notes) {
                    note.time -= shift;
                }
            }
            song.length -= shift;
        }
        return song;
    }

    public static Note getMidiInstrumentNote(int midiInstrument, int midiPitch, int velocity, long microTime) {
        Instrument instrument = null;
        Instrument[] instrumentList = instrumentMap.get(midiInstrument);
        if (instrumentList != null) {
            for (Instrument candidateInstrument : instrumentList) {
                if (midiPitch < candidateInstrument.offset || midiPitch > candidateInstrument.offset + 24) continue;
                instrument = candidateInstrument;
                break;
            }
        }
        if (instrument == null) {
            return null;
        }
        int pitch = midiPitch - instrument.offset;
        int noteId = pitch + instrument.instrumentId * 25;
        long time = microTime / 1000L;
        return new Note(noteId, time, velocity);
    }

    private static Note getMidiPercussionNote(int midiPitch, int velocity, long microTime) {
        if (percussionMap.containsKey(midiPitch)) {
            int noteId = percussionMap.get(midiPitch);
            long time = microTime / 1000L;
            return new Note(noteId, time, velocity);
        }
        return null;
    }

    static {
        instrumentMap.put(0, new Instrument[]{Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(1, new Instrument[]{Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(2, new Instrument[]{Instrument.BIT, Instrument.DIDGERIDOO, Instrument.BELL});
        instrumentMap.put(3, new Instrument[]{Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(4, new Instrument[]{Instrument.BIT, Instrument.DIDGERIDOO, Instrument.BELL});
        instrumentMap.put(5, new Instrument[]{Instrument.BIT, Instrument.DIDGERIDOO, Instrument.BELL});
        instrumentMap.put(6, new Instrument[]{Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(7, new Instrument[]{Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(8, new Instrument[]{Instrument.IRON_XYLOPHONE, Instrument.BASS, Instrument.XYLOPHONE});
        instrumentMap.put(9, new Instrument[]{Instrument.IRON_XYLOPHONE, Instrument.BASS, Instrument.XYLOPHONE});
        instrumentMap.put(10, new Instrument[]{Instrument.IRON_XYLOPHONE, Instrument.BASS, Instrument.XYLOPHONE});
        instrumentMap.put(11, new Instrument[]{Instrument.IRON_XYLOPHONE, Instrument.BASS, Instrument.XYLOPHONE});
        instrumentMap.put(12, new Instrument[]{Instrument.IRON_XYLOPHONE, Instrument.BASS, Instrument.XYLOPHONE});
        instrumentMap.put(13, new Instrument[]{Instrument.IRON_XYLOPHONE, Instrument.BASS, Instrument.XYLOPHONE});
        instrumentMap.put(14, new Instrument[]{Instrument.IRON_XYLOPHONE, Instrument.BASS, Instrument.XYLOPHONE});
        instrumentMap.put(15, new Instrument[]{Instrument.IRON_XYLOPHONE, Instrument.BASS, Instrument.XYLOPHONE});
        instrumentMap.put(16, new Instrument[]{Instrument.DIDGERIDOO, Instrument.BIT, Instrument.XYLOPHONE});
        instrumentMap.put(17, new Instrument[]{Instrument.DIDGERIDOO, Instrument.BIT, Instrument.XYLOPHONE});
        instrumentMap.put(18, new Instrument[]{Instrument.DIDGERIDOO, Instrument.BIT, Instrument.XYLOPHONE});
        instrumentMap.put(19, new Instrument[]{Instrument.DIDGERIDOO, Instrument.BIT, Instrument.XYLOPHONE});
        instrumentMap.put(20, new Instrument[]{Instrument.DIDGERIDOO, Instrument.BIT, Instrument.XYLOPHONE});
        instrumentMap.put(21, new Instrument[]{Instrument.DIDGERIDOO, Instrument.BIT, Instrument.XYLOPHONE});
        instrumentMap.put(22, new Instrument[]{Instrument.DIDGERIDOO, Instrument.BIT, Instrument.XYLOPHONE});
        instrumentMap.put(23, new Instrument[]{Instrument.DIDGERIDOO, Instrument.BIT, Instrument.XYLOPHONE});
        instrumentMap.put(24, new Instrument[]{Instrument.GUITAR, Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(25, new Instrument[]{Instrument.GUITAR, Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(26, new Instrument[]{Instrument.GUITAR, Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(27, new Instrument[]{Instrument.GUITAR, Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(28, new Instrument[]{Instrument.GUITAR, Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(29, new Instrument[]{Instrument.DIDGERIDOO, Instrument.BIT, Instrument.XYLOPHONE});
        instrumentMap.put(30, new Instrument[]{Instrument.DIDGERIDOO, Instrument.BIT, Instrument.XYLOPHONE});
        instrumentMap.put(31, new Instrument[]{Instrument.GUITAR, Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(32, new Instrument[]{Instrument.BASS, Instrument.HARP, Instrument.BELL});
        instrumentMap.put(33, new Instrument[]{Instrument.BASS, Instrument.HARP, Instrument.BELL});
        instrumentMap.put(34, new Instrument[]{Instrument.BASS, Instrument.HARP, Instrument.BELL});
        instrumentMap.put(35, new Instrument[]{Instrument.BASS, Instrument.HARP, Instrument.BELL});
        instrumentMap.put(36, new Instrument[]{Instrument.DIDGERIDOO, Instrument.BIT, Instrument.XYLOPHONE});
        instrumentMap.put(37, new Instrument[]{Instrument.DIDGERIDOO, Instrument.BIT, Instrument.XYLOPHONE});
        instrumentMap.put(38, new Instrument[]{Instrument.DIDGERIDOO, Instrument.BIT, Instrument.XYLOPHONE});
        instrumentMap.put(39, new Instrument[]{Instrument.DIDGERIDOO, Instrument.BIT, Instrument.XYLOPHONE});
        instrumentMap.put(40, new Instrument[]{Instrument.FLUTE, Instrument.GUITAR, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(41, new Instrument[]{Instrument.FLUTE, Instrument.GUITAR, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(42, new Instrument[]{Instrument.FLUTE, Instrument.GUITAR, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(43, new Instrument[]{Instrument.FLUTE, Instrument.GUITAR, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(44, new Instrument[]{Instrument.BIT, Instrument.DIDGERIDOO, Instrument.BELL});
        instrumentMap.put(45, new Instrument[]{Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(46, new Instrument[]{Instrument.HARP, Instrument.BASS, Instrument.CHIME});
        instrumentMap.put(47, new Instrument[]{Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(48, new Instrument[]{Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(49, new Instrument[]{Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(50, new Instrument[]{Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(51, new Instrument[]{Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(52, new Instrument[]{Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(53, new Instrument[]{Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(54, new Instrument[]{Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(55, new Instrument[]{Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(56, new Instrument[]{Instrument.BIT, Instrument.DIDGERIDOO, Instrument.BELL});
        instrumentMap.put(57, new Instrument[]{Instrument.BIT, Instrument.DIDGERIDOO, Instrument.BELL});
        instrumentMap.put(58, new Instrument[]{Instrument.BIT, Instrument.DIDGERIDOO, Instrument.BELL});
        instrumentMap.put(59, new Instrument[]{Instrument.BIT, Instrument.DIDGERIDOO, Instrument.BELL});
        instrumentMap.put(60, new Instrument[]{Instrument.BIT, Instrument.DIDGERIDOO, Instrument.BELL});
        instrumentMap.put(61, new Instrument[]{Instrument.BIT, Instrument.DIDGERIDOO, Instrument.BELL});
        instrumentMap.put(62, new Instrument[]{Instrument.BIT, Instrument.DIDGERIDOO, Instrument.BELL});
        instrumentMap.put(63, new Instrument[]{Instrument.BIT, Instrument.DIDGERIDOO, Instrument.BELL});
        instrumentMap.put(64, new Instrument[]{Instrument.FLUTE, Instrument.DIDGERIDOO, Instrument.IRON_XYLOPHONE, Instrument.BELL});
        instrumentMap.put(65, new Instrument[]{Instrument.FLUTE, Instrument.DIDGERIDOO, Instrument.IRON_XYLOPHONE, Instrument.BELL});
        instrumentMap.put(66, new Instrument[]{Instrument.FLUTE, Instrument.DIDGERIDOO, Instrument.IRON_XYLOPHONE, Instrument.BELL});
        instrumentMap.put(67, new Instrument[]{Instrument.FLUTE, Instrument.DIDGERIDOO, Instrument.IRON_XYLOPHONE, Instrument.BELL});
        instrumentMap.put(68, new Instrument[]{Instrument.FLUTE, Instrument.DIDGERIDOO, Instrument.IRON_XYLOPHONE, Instrument.BELL});
        instrumentMap.put(69, new Instrument[]{Instrument.FLUTE, Instrument.DIDGERIDOO, Instrument.IRON_XYLOPHONE, Instrument.BELL});
        instrumentMap.put(70, new Instrument[]{Instrument.FLUTE, Instrument.DIDGERIDOO, Instrument.IRON_XYLOPHONE, Instrument.BELL});
        instrumentMap.put(71, new Instrument[]{Instrument.FLUTE, Instrument.DIDGERIDOO, Instrument.IRON_XYLOPHONE, Instrument.BELL});
        instrumentMap.put(72, new Instrument[]{Instrument.FLUTE, Instrument.DIDGERIDOO, Instrument.IRON_XYLOPHONE, Instrument.BELL});
        instrumentMap.put(73, new Instrument[]{Instrument.FLUTE, Instrument.DIDGERIDOO, Instrument.IRON_XYLOPHONE, Instrument.BELL});
        instrumentMap.put(74, new Instrument[]{Instrument.FLUTE, Instrument.DIDGERIDOO, Instrument.IRON_XYLOPHONE, Instrument.BELL});
        instrumentMap.put(75, new Instrument[]{Instrument.FLUTE, Instrument.DIDGERIDOO, Instrument.IRON_XYLOPHONE, Instrument.BELL});
        instrumentMap.put(76, new Instrument[]{Instrument.FLUTE, Instrument.DIDGERIDOO, Instrument.IRON_XYLOPHONE, Instrument.BELL});
        instrumentMap.put(77, new Instrument[]{Instrument.FLUTE, Instrument.DIDGERIDOO, Instrument.IRON_XYLOPHONE, Instrument.BELL});
        instrumentMap.put(78, new Instrument[]{Instrument.FLUTE, Instrument.DIDGERIDOO, Instrument.IRON_XYLOPHONE, Instrument.BELL});
        instrumentMap.put(79, new Instrument[]{Instrument.FLUTE, Instrument.DIDGERIDOO, Instrument.IRON_XYLOPHONE, Instrument.BELL});
        instrumentMap.put(80, new Instrument[]{Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(81, new Instrument[]{Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(82, new Instrument[]{Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(83, new Instrument[]{Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(84, new Instrument[]{Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(85, new Instrument[]{Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(86, new Instrument[]{Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(87, new Instrument[]{Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(88, new Instrument[]{Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(89, new Instrument[]{Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(90, new Instrument[]{Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(91, new Instrument[]{Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(92, new Instrument[]{Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(93, new Instrument[]{Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(94, new Instrument[]{Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(95, new Instrument[]{Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(98, new Instrument[]{Instrument.BIT, Instrument.DIDGERIDOO, Instrument.BELL});
        instrumentMap.put(99, new Instrument[]{Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(100, new Instrument[]{Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(101, new Instrument[]{Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(102, new Instrument[]{Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(103, new Instrument[]{Instrument.HARP, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(104, new Instrument[]{Instrument.BANJO, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(105, new Instrument[]{Instrument.BANJO, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(106, new Instrument[]{Instrument.BANJO, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(107, new Instrument[]{Instrument.BANJO, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(108, new Instrument[]{Instrument.BANJO, Instrument.BASS, Instrument.BELL});
        instrumentMap.put(109, new Instrument[]{Instrument.HARP, Instrument.DIDGERIDOO, Instrument.BELL});
        instrumentMap.put(110, new Instrument[]{Instrument.HARP, Instrument.DIDGERIDOO, Instrument.BELL});
        instrumentMap.put(111, new Instrument[]{Instrument.HARP, Instrument.DIDGERIDOO, Instrument.BELL});
        instrumentMap.put(112, new Instrument[]{Instrument.IRON_XYLOPHONE, Instrument.BASS, Instrument.XYLOPHONE});
        instrumentMap.put(113, new Instrument[]{Instrument.IRON_XYLOPHONE, Instrument.BASS, Instrument.XYLOPHONE});
        instrumentMap.put(114, new Instrument[]{Instrument.IRON_XYLOPHONE, Instrument.BASS, Instrument.XYLOPHONE});
        instrumentMap.put(115, new Instrument[]{Instrument.IRON_XYLOPHONE, Instrument.BASS, Instrument.XYLOPHONE});
        instrumentMap.put(116, new Instrument[]{Instrument.IRON_XYLOPHONE, Instrument.BASS, Instrument.XYLOPHONE});
        instrumentMap.put(117, new Instrument[]{Instrument.IRON_XYLOPHONE, Instrument.BASS, Instrument.XYLOPHONE});
        instrumentMap.put(118, new Instrument[]{Instrument.IRON_XYLOPHONE, Instrument.BASS, Instrument.XYLOPHONE});
        instrumentMap.put(119, new Instrument[]{Instrument.IRON_XYLOPHONE, Instrument.BASS, Instrument.XYLOPHONE});
        percussionMap = new HashMap();
        percussionMap.put(35, 10 + 25 * Instrument.BASEDRUM.instrumentId);
        percussionMap.put(36, 6 + 25 * Instrument.BASEDRUM.instrumentId);
        percussionMap.put(37, 6 + 25 * Instrument.HAT.instrumentId);
        percussionMap.put(38, 8 + 25 * Instrument.SNARE.instrumentId);
        percussionMap.put(39, 6 + 25 * Instrument.HAT.instrumentId);
        percussionMap.put(40, 4 + 25 * Instrument.SNARE.instrumentId);
        percussionMap.put(41, 6 + 25 * Instrument.BASEDRUM.instrumentId);
        percussionMap.put(42, 22 + 25 * Instrument.SNARE.instrumentId);
        percussionMap.put(43, 13 + 25 * Instrument.BASEDRUM.instrumentId);
        percussionMap.put(44, 22 + 25 * Instrument.SNARE.instrumentId);
        percussionMap.put(45, 15 + 25 * Instrument.BASEDRUM.instrumentId);
        percussionMap.put(46, 18 + 25 * Instrument.SNARE.instrumentId);
        percussionMap.put(47, 20 + 25 * Instrument.BASEDRUM.instrumentId);
        percussionMap.put(48, 23 + 25 * Instrument.BASEDRUM.instrumentId);
        percussionMap.put(49, 17 + 25 * Instrument.SNARE.instrumentId);
        percussionMap.put(50, 23 + 25 * Instrument.BASEDRUM.instrumentId);
        percussionMap.put(51, 24 + 25 * Instrument.SNARE.instrumentId);
        percussionMap.put(52, 8 + 25 * Instrument.SNARE.instrumentId);
        percussionMap.put(53, 13 + 25 * Instrument.SNARE.instrumentId);
        percussionMap.put(54, 18 + 25 * Instrument.HAT.instrumentId);
        percussionMap.put(55, 18 + 25 * Instrument.SNARE.instrumentId);
        percussionMap.put(56, 1 + 25 * Instrument.HAT.instrumentId);
        percussionMap.put(57, 13 + 25 * Instrument.SNARE.instrumentId);
        percussionMap.put(58, 2 + 25 * Instrument.HAT.instrumentId);
        percussionMap.put(59, 13 + 25 * Instrument.SNARE.instrumentId);
        percussionMap.put(60, 9 + 25 * Instrument.HAT.instrumentId);
        percussionMap.put(61, 2 + 25 * Instrument.HAT.instrumentId);
        percussionMap.put(62, 8 + 25 * Instrument.HAT.instrumentId);
        percussionMap.put(63, 22 + 25 * Instrument.BASEDRUM.instrumentId);
        percussionMap.put(64, 15 + 25 * Instrument.BASEDRUM.instrumentId);
        percussionMap.put(65, 13 + 25 * Instrument.SNARE.instrumentId);
        percussionMap.put(66, 8 + 25 * Instrument.SNARE.instrumentId);
        percussionMap.put(67, 8 + 25 * Instrument.HAT.instrumentId);
        percussionMap.put(68, 3 + 25 * Instrument.HAT.instrumentId);
        percussionMap.put(69, 20 + 25 * Instrument.HAT.instrumentId);
        percussionMap.put(70, 23 + 25 * Instrument.HAT.instrumentId);
        percussionMap.put(71, 24 + 25 * Instrument.HAT.instrumentId);
        percussionMap.put(72, 24 + 25 * Instrument.HAT.instrumentId);
        percussionMap.put(73, 17 + 25 * Instrument.HAT.instrumentId);
        percussionMap.put(74, 11 + 25 * Instrument.HAT.instrumentId);
        percussionMap.put(75, 18 + 25 * Instrument.HAT.instrumentId);
        percussionMap.put(76, 9 + 25 * Instrument.HAT.instrumentId);
        percussionMap.put(77, 5 + 25 * Instrument.HAT.instrumentId);
        percussionMap.put(78, 22 + 25 * Instrument.HAT.instrumentId);
        percussionMap.put(79, 19 + 25 * Instrument.SNARE.instrumentId);
        percussionMap.put(80, 17 + 25 * Instrument.HAT.instrumentId);
        percussionMap.put(81, 22 + 25 * Instrument.HAT.instrumentId);
        percussionMap.put(82, 22 + 25 * Instrument.SNARE.instrumentId);
        percussionMap.put(83, 24 + 25 * Instrument.CHIME.instrumentId);
        percussionMap.put(84, 24 + 25 * Instrument.CHIME.instrumentId);
        percussionMap.put(85, 21 + 25 * Instrument.HAT.instrumentId);
        percussionMap.put(86, 14 + 25 * Instrument.BASEDRUM.instrumentId);
        percussionMap.put(87, 7 + 25 * Instrument.BASEDRUM.instrumentId);
    }
}

