/*
 * Decompiled with CFR 0.152.
 */
package com.github.hhhzzzsss.songplayer.conversion;

import com.github.hhhzzzsss.songplayer.song.Instrument;
import com.github.hhhzzzsss.songplayer.song.Note;
import com.github.hhhzzzsss.songplayer.song.Song;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

public class NBSConverter {
    public static Instrument[] instrumentIndex = new Instrument[]{Instrument.HARP, Instrument.BASS, Instrument.BASEDRUM, Instrument.SNARE, Instrument.HAT, Instrument.GUITAR, Instrument.FLUTE, Instrument.BELL, Instrument.CHIME, Instrument.XYLOPHONE, Instrument.IRON_XYLOPHONE, Instrument.COW_BELL, Instrument.DIDGERIDOO, Instrument.BIT, Instrument.BANJO, Instrument.PLING};

    public static Song getSongFromBytes(byte[] bytes, String fileName) throws IOException {
        short tickJumps;
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        short songLength = 0;
        byte format = 0;
        byte vanillaInstrumentCount = 0;
        songLength = buffer.getShort();
        if (songLength == 0) {
            format = buffer.get();
        }
        if (format >= 1) {
            vanillaInstrumentCount = buffer.get();
        }
        if (format >= 3) {
            songLength = buffer.getShort();
        }
        int layerCount = buffer.getShort();
        String songName = NBSConverter.getString(buffer, bytes.length);
        String songAuthor = NBSConverter.getString(buffer, bytes.length);
        String songOriginalAuthor = NBSConverter.getString(buffer, bytes.length);
        String songDescription = NBSConverter.getString(buffer, bytes.length);
        short tempo = buffer.getShort();
        byte autoSaving = buffer.get();
        byte autoSavingDuration = buffer.get();
        byte timeSignature = buffer.get();
        int minutesSpent = buffer.getInt();
        int leftClicks = buffer.getInt();
        int rightClicks = buffer.getInt();
        int blocksAdded = buffer.getInt();
        int blocksRemoved = buffer.getInt();
        String origFileName = NBSConverter.getString(buffer, bytes.length);
        byte loop = 0;
        byte maxLoopCount = 0;
        short loopStartTick = 0;
        if (format >= 4) {
            loop = buffer.get();
            maxLoopCount = buffer.get();
            loopStartTick = buffer.getShort();
        }
        ArrayList<NBSNote> nbsNotes = new ArrayList<NBSNote>();
        int tick = -1;
        while ((tickJumps = buffer.getShort()) != 0) {
            short layerJumps;
            tick = (short)(tick + tickJumps);
            int layer = -1;
            while ((layerJumps = buffer.getShort()) != 0) {
                layer = (short)(layer + layerJumps);
                NBSNote note = new NBSNote();
                note.tick = tick;
                note.layer = (short)layer;
                note.instrument = buffer.get();
                note.key = buffer.get();
                if (format >= 4) {
                    note.velocity = buffer.get();
                    note.panning = buffer.get();
                    note.pitch = buffer.getShort();
                }
                nbsNotes.add(note);
            }
        }
        ArrayList<NBSLayer> nbsLayers = new ArrayList<NBSLayer>();
        if (buffer.hasRemaining()) {
            for (int i = 0; i < layerCount; ++i) {
                NBSLayer layer = new NBSLayer();
                layer.name = NBSConverter.getString(buffer, bytes.length);
                if (format >= 4) {
                    layer.lock = buffer.get();
                }
                layer.volume = buffer.get();
                if (format >= 2) {
                    layer.stereo = buffer.get();
                }
                nbsLayers.add(layer);
            }
        }
        Song song = new Song(songName.trim().length() > 0 ? songName : fileName);
        if (loop > 0) {
            song.looping = true;
            song.loopPosition = NBSConverter.getMilliTime(loopStartTick, tempo);
            song.loopCount = maxLoopCount;
        }
        for (NBSNote note : nbsNotes) {
            if (note.instrument >= instrumentIndex.length) continue;
            Instrument instrument = instrumentIndex[note.instrument];
            while (note.key < 33) {
                note.key = (byte)(note.key + 12);
            }
            while (note.key > 57) {
                note.key = (byte)(note.key - 12);
            }
            int layerVolume = 100;
            if (nbsLayers.size() > note.layer) {
                layerVolume = ((NBSLayer)nbsLayers.get((int)note.layer)).volume;
            }
            int pitch = note.key - 33;
            int noteId = pitch + instrument.instrumentId * 25;
            song.add(new Note(noteId, NBSConverter.getMilliTime(note.tick, tempo), layerVolume));
        }
        song.length = song.get((int)(song.size() - 1)).time + 50L;
        return song;
    }

    private static String getString(ByteBuffer buffer, int maxSize) throws IOException {
        int length = buffer.getInt();
        if (length > maxSize) {
            throw new IOException("String is too large");
        }
        byte[] arr = new byte[length];
        buffer.get(arr, 0, length);
        return new String(arr);
    }

    private static int getMilliTime(int tick, int tempo) {
        return 1000 * tick * 100 / tempo;
    }

    private static class NBSNote {
        public int tick;
        public short layer;
        public byte instrument;
        public byte key;
        public byte velocity = (byte)100;
        public byte panning = (byte)100;
        public short pitch = 0;

        private NBSNote() {
        }
    }

    private static class NBSLayer {
        public String name;
        public byte lock = 0;
        public byte volume;
        public byte stereo = (byte)100;

        private NBSLayer() {
        }
    }
}

