/*
 * Decompiled with CFR 0.152.
 */
package com.github.hhhzzzsss.songplayer.conversion;

import com.github.hhhzzzsss.songplayer.Config;
import com.github.hhhzzzsss.songplayer.Util;
import com.github.hhhzzzsss.songplayer.song.Note;
import com.github.hhhzzzsss.songplayer.song.Song;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class SPConverter {
    public static final byte[] FILE_TYPE_SIGNATURE = new byte[]{-53, 123, -51, -124, -122, -46, -35, 38};
    public static final long MAX_UNCOMPRESSED_SIZE = 0x3200000L;

    public static Song getSongFromBytes(byte[] bytes, String fileName) throws IOException {
        short noteId;
        Util.LimitedSizeInputStream is = new Util.LimitedSizeInputStream(new GZIPInputStream(new ByteArrayInputStream(bytes)), 0x3200000L);
        bytes = is.readAllBytes();
        is.close();
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (byte b : FILE_TYPE_SIGNATURE) {
            if (b == buffer.get()) continue;
            throw new IOException("Invalid file type signature");
        }
        byte version = buffer.get();
        if (version != 1) {
            throw new IOException("Unsupported format version!");
        }
        long songLength = buffer.getLong();
        String songName = SPConverter.getString(buffer, bytes.length);
        int loop = buffer.get() & 0xFF;
        int loopCount = buffer.get() & 0xFF;
        long loopPosition = buffer.getLong();
        Song song = new Song(songName.trim().length() > 0 ? songName : fileName);
        song.length = songLength;
        song.looping = loop > 0;
        song.loopCount = loopCount;
        song.loopPosition = loopPosition;
        long time = 0L;
        while ((noteId = buffer.getShort()) >= 0 && noteId < 400) {
            song.add(new Note(noteId, time += SPConverter.getVarLong(buffer)));
        }
        if ((noteId & 0xFFFF) != 65535) {
            throw new IOException("Song contains invalid note id of " + noteId);
        }
        return song;
    }

    public static byte[] getBytesFromSong(Song song) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream os = new GZIPOutputStream(byteArrayOutputStream);
        int version = 1;
        ((OutputStream)os).write(FILE_TYPE_SIGNATURE);
        ((OutputStream)os).write(version);
        SPConverter.writeLong(os, song.length);
        SPConverter.writeString(os, song.name);
        ((OutputStream)os).write(song.looping ? 1 : 0);
        ((OutputStream)os).write(Math.min(song.loopCount, 255));
        SPConverter.writeLong(os, song.loopPosition);
        song.sort();
        long prevTime = 0L;
        for (Note note : song.notes) {
            if (note.velocity < Config.getConfig().velocityThreshold) continue;
            SPConverter.writeShort(os, note.noteId);
            SPConverter.writeVarLong(os, note.time - prevTime);
            prevTime = note.time;
        }
        SPConverter.writeShort(os, 65535);
        ((OutputStream)os).close();
        return byteArrayOutputStream.toByteArray();
    }

    private static String getString(ByteBuffer buffer, int maxSize) throws IOException {
        int length = buffer.getInt();
        if (length > maxSize) {
            throw new IOException("String is too large");
        }
        byte[] arr = new byte[length];
        buffer.get(arr, 0, length);
        System.out.println(new String(arr, StandardCharsets.UTF_8));
        return new String(arr, StandardCharsets.UTF_8);
    }

    private static void writeString(OutputStream os, String string) throws IOException {
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        SPConverter.writeInt(os, bytes.length);
        os.write(bytes);
    }

    private static long getVarLong(ByteBuffer buffer) {
        long val = 0L;
        long mult = 1L;
        int flag = 1;
        while (flag != 0) {
            int b = buffer.get() & 0xFF;
            val += (long)(b & 0x7F) * mult;
            mult <<= 7;
            flag = b >>> 7;
        }
        return val;
    }

    private static void writeVarLong(OutputStream os, long val) throws IOException {
        do {
            int b = (int)(val & 0x7FL);
            if ((val >>>= 7) > 0L) {
                b |= 0x80;
            }
            os.write((byte)b);
        } while (val > 0L);
    }

    private static void writeShort(OutputStream os, int val) throws IOException {
        os.write(val & 0xFF);
        os.write(val >>> 8 & 0xFF);
    }

    private static void writeInt(OutputStream os, int val) throws IOException {
        os.write(val & 0xFF);
        os.write(val >>> 8 & 0xFF);
        os.write(val >>> 16 & 0xFF);
        os.write(val >>> 24 & 0xFF);
    }

    private static void writeLong(OutputStream os, long val) throws IOException {
        os.write((int)val & 0xFF);
        os.write((int)(val >>> 8) & 0xFF);
        os.write((int)(val >>> 16) & 0xFF);
        os.write((int)(val >>> 24) & 0xFF);
        os.write((int)(val >>> 32) & 0xFF);
        os.write((int)(val >>> 40) & 0xFF);
        os.write((int)(val >>> 48) & 0xFF);
        os.write((int)(val >>> 56) & 0xFF);
    }
}

