/*
 * Decompiled with CFR 0.152.
 */
package com.github.hhhzzzsss.songplayer.item;

import com.github.hhhzzzsss.songplayer.Util;
import com.github.hhhzzzsss.songplayer.item.SongItemLoaderThread;
import com.github.hhhzzzsss.songplayer.playing.SongHandler;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5489;

public class SongItemConfirmationScreen
extends class_437 {
    private class_1799 stack;
    private SongItemLoaderThread loaderThread;
    private class_5489 unloadedText;
    private class_5489 loadedText;
    private boolean loaded = false;
    private static final class_2561 CONFIRM = class_2561.method_43470((String)"Play");
    private static final class_2561 CANCEL = class_2561.method_43470((String)"Cancel");

    public SongItemConfirmationScreen(class_1799 stack) throws IOException, IllegalArgumentException {
        super((class_2561)class_2561.method_43470((String)"Use song item"));
        this.stack = stack;
        this.loaderThread = new SongItemLoaderThread(stack);
        this.loaderThread.start();
    }

    protected void method_25426() {
        super.method_25426();
        String unloadedMessage = "\u00a77Loading song...";
        this.unloadedText = class_5489.method_30892((class_327)this.field_22793, (class_2561[])new class_2561[]{class_2561.method_43470((String)unloadedMessage)});
    }

    private void addButtons(int y) {
        int centerX = this.field_22789 / 2;
        this.method_37063((class_364)class_4185.method_46430((class_2561)CONFIRM, button -> {
            SongHandler.getInstance().loadSong(this.loaderThread);
            this.field_22787.method_1507(null);
        }).method_46434(centerX - 105, y, 100, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)CANCEL, button -> this.field_22787.method_1507(null)).method_46434(centerX + 5, y, 100, 20).method_46431());
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 40, 0xFFFFFF);
        if (!this.loaderThread.isAlive()) {
            if (this.loaderThread.exception != null) {
                Util.showChatMessage("\u00a7cError loading song item: \u00a74" + this.loaderThread.exception.getMessage());
                this.field_22787.method_1507(null);
                return;
            }
            if (this.loadedText == null) {
                String[] loadedMessages = new String[]{"\u00a73" + this.loaderThread.song.name, String.format("\u00a77Max notes per second: %s%d", this.getNumberColor(this.loaderThread.maxNotesPerSecond), this.loaderThread.maxNotesPerSecond), String.format("\u00a77Avg notes per second: %s%.2f", this.getNumberColor(this.loaderThread.avgNotesPerSecond), this.loaderThread.avgNotesPerSecond)};
                class_2561[] messageList = (class_2561[])Arrays.stream(loadedMessages).map(class_2561::method_43470).toArray(class_2561[]::new);
                this.loadedText = class_5489.method_30892((class_327)this.field_22793, (class_2561[])messageList);
                int n = this.loadedText.method_30887();
                Objects.requireNonNull(this.field_22793);
                int loadedTextHeight = n * 9;
                this.addButtons(60 + loadedTextHeight + 12);
                this.loaded = true;
            }
        }
        if (this.loaded) {
            this.loadedText.method_30888(context, this.field_22789 / 2, 60);
        } else {
            this.unloadedText.method_30888(context, this.field_22789 / 2, 60);
        }
    }

    public String getNumberColor(double number) {
        if (number < 50.0) {
            return "\u00a7a";
        }
        if (number < 100.0) {
            return "\u00a7e";
        }
        if (number < 300.0) {
            return "\u00a76";
        }
        if (number < 600.0) {
            return "\u00a7c";
        }
        return "\u00a74";
    }
}

