/*
 * Decompiled with CFR 0.152.
 */
package com.github.hhhzzzsss.songplayer.item;

import com.github.hhhzzzsss.songplayer.conversion.SPConverter;
import com.github.hhhzzzsss.songplayer.item.SongItemUtils;
import com.github.hhhzzzsss.songplayer.song.Note;
import com.github.hhhzzzsss.songplayer.song.SongLoaderThread;
import java.io.IOException;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

public class SongItemLoaderThread
extends SongLoaderThread {
    public byte[] songData;
    public String displayName;
    public int maxNotesPerSecond = 0;
    public double avgNotesPerSecond = 0.0;

    public SongItemLoaderThread(class_1799 stack) throws IOException, IllegalArgumentException {
        this.songData = SongItemUtils.getSongData(stack);
        if (this.songData == null) {
            throw new IOException("Song data is missing");
        }
        class_2487 songItemNbt = SongItemUtils.getSongItemTag(stack).orElseThrow(() -> new IOException("Song item tag is missing"));
        this.filename = this.displayName = (String)songItemNbt.method_10558("DisplayName").orElse(null);
    }

    @Override
    public void run() {
        try {
            this.song = SPConverter.getSongFromBytes(this.songData, this.filename);
            if (this.displayName != null && this.displayName.length() > 0) {
                this.song.name = this.displayName;
            }
            if (this.song.name == null || this.song.name.length() == 0) {
                this.song.name = "unnamed";
            }
            this.song.sort();
            int j = 0;
            int notesInSecond = 0;
            for (Note currNote : this.song.notes) {
                ++notesInSecond;
                while (this.song.notes.get((int)j).time + 1000L < currNote.time) {
                    ++j;
                    --notesInSecond;
                }
                this.maxNotesPerSecond = Math.max(notesInSecond, this.maxNotesPerSecond);
            }
            this.avgNotesPerSecond = (double)this.song.notes.size() * 1000.0 / (double)this.song.length;
        }
        catch (Exception e) {
            this.exception = e;
            e.printStackTrace();
        }
    }
}

