/*
 * Decompiled with CFR 0.152.
 */
package com.github.hhhzzzsss.songplayer.item;

import com.github.hhhzzzsss.songplayer.Util;
import java.util.Base64;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.minecraft.class_9334;

public class SongItemUtils {
    public static final String SONG_ITEM_KEY = "SongItemData";
    public static final String SONG_DATA_KEY = "SongData";
    public static final String FILE_NAME_KEY = "FileName";
    public static final String DISPLAY_NAME_KEY = "DisplayName";

    public static class_1799 createSongItem(class_1799 stack, byte[] songData, String filename, String displayName) {
        class_2487 songItemTag = new class_2487();
        songItemTag.method_10582(SONG_DATA_KEY, Base64.getEncoder().encodeToString(songData));
        songItemTag.method_10582(FILE_NAME_KEY, filename);
        songItemTag.method_10582(DISPLAY_NAME_KEY, displayName);
        class_9279.method_57452((class_9331)class_9334.field_49628, (class_1799)stack, nbt -> nbt.method_10566(SONG_ITEM_KEY, (class_2520)songItemTag));
        SongItemUtils.addSongItemDisplay(stack);
        return stack;
    }

    public static void addSongItemDisplay(class_1799 stack) {
        SongItemUtils.getSongItemTag(stack).ifPresent(songItemTag -> {
            String name = songItemTag.method_10558(DISPLAY_NAME_KEY).or(() -> songItemTag.method_10558(FILE_NAME_KEY)).orElse("unnamed");
            Util.setItemName(stack, (class_2561)Util.getStyledText(name, class_2583.field_24360.method_10977(class_124.field_1062).method_10978(Boolean.valueOf(false))));
            Util.setItemLore(stack, new class_2561[]{Util.getStyledText("Song Item", class_2583.field_24360.method_10977(class_124.field_1054).method_10978(Boolean.valueOf(false))), Util.getStyledText("Right click to play", class_2583.field_24360.method_10977(class_124.field_1075).method_10978(Boolean.valueOf(false))), Util.getStyledText("Requires SongPlayer 3.0+", class_2583.field_24360.method_10977(class_124.field_1065).method_10978(Boolean.valueOf(false))), Util.getStyledText("https://github.com/hhhzzzsss/SongPlayer", class_2583.field_24360.method_10977(class_124.field_1080).method_10978(Boolean.valueOf(false)))});
        });
    }

    public static void updateSongItemTag(class_1799 stack, Consumer<class_2487> nbtSetter) {
        class_9279.method_57452((class_9331)class_9334.field_49628, (class_1799)stack, itemNbt -> itemNbt.method_10562(SONG_ITEM_KEY).ifPresent(nbtSetter));
    }

    public static Optional<class_2487> getSongItemTag(class_1799 stack) {
        return ((class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461().method_10562(SONG_ITEM_KEY);
    }

    public static boolean isSongItem(class_1799 stack) {
        return SongItemUtils.getSongItemTag(stack).isPresent();
    }

    public static byte[] getSongData(class_1799 stack) throws IllegalArgumentException {
        return SongItemUtils.getSongItemTag(stack).flatMap(songItemTag -> songItemTag.method_10558(SONG_DATA_KEY)).map(songData -> Base64.getDecoder().decode((String)songData)).orElse(null);
    }
}

