/*
 * Decompiled with CFR 0.152.
 */
package com.github.hhhzzzsss.songplayer.playing;

import com.github.hhhzzzsss.songplayer.Config;
import com.github.hhhzzzsss.songplayer.FakePlayerEntity;
import com.github.hhhzzzsss.songplayer.SongPlayer;
import com.github.hhhzzzsss.songplayer.Util;
import com.github.hhhzzzsss.songplayer.mixin.ClientPlayerInteractionManagerAccessor;
import com.github.hhhzzzsss.songplayer.playing.ProgressDisplay;
import com.github.hhhzzzsss.songplayer.playing.Stage;
import com.github.hhhzzzsss.songplayer.song.Instrument;
import com.github.hhhzzzsss.songplayer.song.Note;
import com.github.hhhzzzsss.songplayer.song.Playlist;
import com.github.hhhzzzsss.songplayer.song.Song;
import com.github.hhhzzzsss.songplayer.song.SongLoaderThread;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2828;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import net.minecraft.class_9275;
import net.minecraft.class_9334;

public class SongHandler {
    private static SongHandler instance = null;
    public SongLoaderThread loaderThread = null;
    public LinkedList<Song> songQueue = new LinkedList();
    public Song currentSong = null;
    public Playlist currentPlaylist = null;
    public Stage stage = null;
    public Stage lastStage = null;
    public FakePlayerEntity fakePlayer;
    public HashMap<class_2338, class_2680> originalBlocks = new HashMap();
    public boolean building = false;
    public boolean cleaningUp = false;
    public boolean dirty = false;
    public boolean wasFlying = false;
    public class_1934 originalGamemode = class_1934.field_9220;
    boolean playlistChecked = false;
    private int buildStartDelay = 0;
    private int buildEndDelay = 0;
    private int buildSlot = -1;
    private class_1799 prevHeldItem = null;
    private int cleanupTotalBlocksToPlace = 0;
    private LinkedList<class_2338> cleanupBreakList = new LinkedList();
    private LinkedList<class_2338> cleanupPlaceList = new LinkedList();
    private ArrayList<class_2338> cleanupUnplaceableBlocks = new ArrayList();
    private int lastCleanupHash = 0;
    private long lastCommandTime = System.currentTimeMillis();
    private String cachedCommand = null;
    private String cachedMessage = null;
    private final String[] instrumentNames = new String[]{"harp", "basedrum", "snare", "hat", "bass", "flute", "bell", "guitar", "chime", "xylophone", "iron_xylophone", "cow_bell", "didgeridoo", "bit", "banjo", "pling"};
    private double breakAllowance = 0.0;
    private double placeAllowance = 0.0;

    public static SongHandler getInstance() {
        if (instance == null) {
            instance = new SongHandler();
        }
        return instance;
    }

    private SongHandler() {
    }

    public void onUpdate(boolean tick) {
        if (!this.cleaningUp) {
            if (this.currentSong == null && this.currentPlaylist != null && this.currentPlaylist.loaded) {
                if (!this.playlistChecked) {
                    this.playlistChecked = true;
                    if (this.currentPlaylist.songsFailedToLoad.size() > 0) {
                        Util.showChatMessage("\u00a7cFailed to load the following songs from the playlist: \u00a74" + String.join((CharSequence)" ", this.currentPlaylist.songsFailedToLoad));
                    }
                }
                Song nextSong = this.currentPlaylist.getNext();
                if (this.currentPlaylist.songs.size() == 0) {
                    Util.showChatMessage("\u00a7cPlaylist has no playable songs");
                    this.currentPlaylist = null;
                } else if (nextSong == null) {
                    Util.showChatMessage("\u00a76Playlist has finished playing");
                    this.currentPlaylist = null;
                } else {
                    nextSong.reset();
                    this.setSong(nextSong);
                }
            }
            if (this.currentSong == null && this.currentPlaylist == null && this.songQueue.size() > 0) {
                this.setSong(this.songQueue.poll());
            }
            if (this.loaderThread != null && !this.loaderThread.isAlive()) {
                if (this.loaderThread.exception != null) {
                    Util.showChatMessage("\u00a7cFailed to load song: \u00a74" + this.loaderThread.exception.getMessage());
                } else if (this.currentSong == null) {
                    this.setSong(this.loaderThread.song);
                } else {
                    this.queueSong(this.loaderThread.song);
                }
                this.loaderThread = null;
            }
        }
        this.checkCommandCache();
        if (this.cleaningUp || this.currentSong != null) {
            if (Config.getConfig().showFakePlayer && this.fakePlayer == null) {
                this.fakePlayer = new FakePlayerEntity();
                this.fakePlayer.copyStagePosAndPlayerLook();
            }
            if (!Config.getConfig().showFakePlayer && this.fakePlayer != null) {
                this.removeFakePlayer();
            }
            if (this.fakePlayer != null) {
                this.fakePlayer.method_31548().method_7377(SongPlayer.MC.field_1724.method_31548());
            }
            this.wasFlying = SongPlayer.MC.field_1724.method_31549().field_7479;
        }
        if (this.cleaningUp) {
            if (tick) {
                this.wasFlying = SongPlayer.MC.field_1724.method_31549().field_7479;
                this.handleCleanup();
            }
        } else if (this.currentSong != null) {
            if (this.stage == null) {
                Util.showChatMessage("\u00a7cStage is null! This should not happen!");
                this.reset();
                return;
            }
            if (this.building) {
                if (tick) {
                    this.handleBuilding();
                }
            } else {
                this.handlePlaying(tick);
            }
        } else if (this.dirty) {
            if (Config.getConfig().autoCleanup && this.originalBlocks.size() != 0 && !Config.getConfig().survivalOnly) {
                this.partialResetAndCleanup();
            } else {
                this.restoreStateAndReset();
            }
        } else {
            this.originalGamemode = SongPlayer.MC.field_1761.method_2920();
        }
    }

    public void loadSong(String location) {
        if (this.loaderThread != null) {
            Util.showChatMessage("\u00a7cAlready loading a song, cannot load another");
        } else if (this.currentPlaylist != null) {
            Util.showChatMessage("\u00a7cCannot load a song while a playlist is playing");
        } else {
            try {
                this.loaderThread = new SongLoaderThread(location);
                Util.showChatMessage("\u00a76Loading \u00a73" + location);
                this.loaderThread.start();
            }
            catch (IOException e) {
                Util.showChatMessage("\u00a7cFailed to load song: \u00a74" + e.getMessage());
            }
        }
    }

    public void loadSong(SongLoaderThread thread) {
        if (this.loaderThread != null) {
            Util.showChatMessage("\u00a7cAlready loading a song, cannot load another");
        } else if (this.currentPlaylist != null) {
            Util.showChatMessage("\u00a7cCannot load a song while a playlist is playing");
        } else {
            this.loaderThread = thread;
        }
    }

    public void setSong(Song song) {
        this.dirty = true;
        this.currentSong = song;
        this.building = true;
        if (!Config.getConfig().survivalOnly) {
            this.setCreativeIfNeeded();
        }
        if (Config.getConfig().doAnnouncement) {
            this.sendMessage(Config.getConfig().announcementMessage.replaceAll("\\[name\\]", song.name));
        }
        if (!Config.getConfig().survivalOnly) {
            this.getAndSaveBuildSlot();
        }
        this.prepareStage();
        Util.showChatMessage("\u00a76Building noteblocks");
    }

    private void queueSong(Song song) {
        this.songQueue.add(song);
        Util.showChatMessage("\u00a76Added song to queue: \u00a73" + song.name);
    }

    public void setPlaylist(Path playlist) {
        if (this.loaderThread != null || this.currentSong != null || !this.songQueue.isEmpty()) {
            Util.showChatMessage("\u00a7cCannot start playing a playlist while something else is playing");
        } else {
            this.currentPlaylist = new Playlist(playlist, Config.getConfig().loopPlaylists, Config.getConfig().shufflePlaylists);
            this.playlistChecked = false;
        }
    }

    public void setPlaylistLoop(boolean loop) {
        if (this.currentPlaylist != null) {
            this.currentPlaylist.setLoop(loop);
        }
    }

    public void setPlaylistShuffle(boolean shuffle) {
        if (this.currentPlaylist != null) {
            this.currentPlaylist.setShuffle(shuffle);
        }
    }

    public void startCleanup() {
        this.dirty = true;
        this.cleaningUp = true;
        this.lastCleanupHash = 0;
        this.setCreativeIfNeeded();
        this.getAndSaveBuildSlot();
        this.lastStage.sendMovementPacketToStagePosition();
    }

    private void handleBuilding() {
        this.setBuildProgressDisplay();
        if (this.buildStartDelay > 0) {
            --this.buildStartDelay;
            return;
        }
        class_638 world = SongPlayer.MC.field_1687;
        if (!Config.getConfig().survivalOnly && SongPlayer.MC.field_1761.method_2920() != class_1934.field_9220) {
            return;
        }
        if (this.stage.nothingToBuild()) {
            if (this.buildEndDelay > 0) {
                --this.buildEndDelay;
                return;
            }
            if (!Config.getConfig().survivalOnly) {
                this.stage.checkBuildStatus(this.currentSong);
                this.recordStageBlocks();
            } else {
                try {
                    this.stage.checkSurvivalBuildStatus(this.currentSong);
                }
                catch (Stage.NotEnoughInstrumentsException e) {
                    e.giveInstrumentSummary();
                    this.restoreStateAndReset();
                    return;
                }
            }
            this.stage.sendMovementPacketToStagePosition();
        }
        if (this.stage.nothingToBuild()) {
            this.building = false;
            if (!Config.getConfig().survivalOnly) {
                this.setSurvivalIfNeeded();
                this.restoreBuildSlot();
            }
            this.stage.sendMovementPacketToStagePosition();
            Util.showChatMessage("\u00a76Now playing \u00a73" + this.currentSong.name);
        }
        if (!Config.getConfig().survivalOnly) {
            if (!this.stage.requiredBreaks.isEmpty()) {
                this.incrementBreakAllowance();
                while (this.consumeBreakAllowance()) {
                    if (this.stage.requiredBreaks.isEmpty()) continue;
                    class_2338 bp = this.stage.requiredBreaks.poll();
                    this.attackBlock(bp);
                }
                this.buildEndDelay = 20;
            } else if (!this.stage.missingNotes.isEmpty()) {
                this.incrementPlaceAllowance();
                while (this.consumePlaceAllowance()) {
                    if (this.stage.missingNotes.isEmpty()) continue;
                    int desiredNoteId = this.stage.missingNotes.pollFirst();
                    class_2338 bp = this.stage.noteblockPositions.get(desiredNoteId);
                    if (bp == null) {
                        return;
                    }
                    int blockId = class_2248.method_9507((class_2680)world.method_8320(bp));
                    int currentNoteId = (blockId - SongPlayer.NOTEBLOCK_BASE_ID) / 2;
                    if (currentNoteId == desiredNoteId) continue;
                    this.holdNoteblock(desiredNoteId, this.buildSlot);
                    if (blockId != 0) {
                        this.attackBlock(bp);
                    }
                    this.placeBlock(bp);
                }
                this.buildEndDelay = 20;
            }
        } else if (!this.stage.requiredClicks.isEmpty()) {
            class_2338 bp = this.stage.requiredClicks.pollFirst();
            if (SongPlayer.MC.field_1687.method_8320(bp).method_26204() == class_2246.field_10179) {
                this.placeBlock(bp);
            }
            this.buildEndDelay = 20;
        }
    }

    private void setBuildProgressDisplay() {
        class_5250 buildText = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Building noteblocks | ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)(this.stage.totalMissingNotes - this.stage.missingNotes.size() + "/" + this.stage.totalMissingNotes)).method_27692(class_124.field_1062));
        class_5250 playlistText = class_2561.method_43473();
        if (this.currentPlaylist != null && this.currentPlaylist.loaded) {
            playlistText = playlistText.method_10852((class_2561)class_2561.method_43470((String)"Playlist: ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)this.currentPlaylist.name).method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" | ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)String.format(" (%s/%s)", this.currentPlaylist.songNumber, this.currentPlaylist.songs.size())).method_27692(class_124.field_1062));
            if (this.currentPlaylist.loop) {
                playlistText.method_10852((class_2561)class_2561.method_43470((String)" | Looping").method_27692(class_124.field_1065));
            }
            if (this.currentPlaylist.shuffle) {
                playlistText.method_10852((class_2561)class_2561.method_43470((String)" | Shuffled").method_27692(class_124.field_1065));
            }
        }
        ProgressDisplay.getInstance().setText(buildText, playlistText);
    }

    private void handlePlaying(boolean tick) {
        if (tick) {
            this.setPlayProgressDisplay();
        }
        if (SongPlayer.MC.field_1761.method_2920() != class_1934.field_9215) {
            this.currentSong.pause();
            return;
        }
        if (tick) {
            if (this.stage.hasBreakingModification()) {
                if (!Config.getConfig().survivalOnly) {
                    this.stage.checkBuildStatus(this.currentSong);
                    this.recordStageBlocks();
                } else {
                    try {
                        this.stage.checkSurvivalBuildStatus(this.currentSong);
                    }
                    catch (Stage.NotEnoughInstrumentsException e) {
                        Util.showChatMessage("\u00a76Stopped because stage is missing instruments required for song.");
                        this.restoreStateAndReset();
                        return;
                    }
                }
            }
            if (!this.stage.nothingToBuild()) {
                this.building = true;
                if (!Config.getConfig().survivalOnly) {
                    this.setCreativeIfNeeded();
                }
                this.stage.sendMovementPacketToStagePosition();
                this.currentSong.pause();
                this.buildStartDelay = 20;
                System.out.println("Total missing notes: " + this.stage.missingNotes.size());
                for (int note : this.stage.missingNotes) {
                    int pitch = note % 25;
                    int instrumentId = note / 25;
                    System.out.println("Missing note: " + Instrument.getInstrumentFromId(instrumentId).name() + ":" + pitch);
                }
                if (!Config.getConfig().survivalOnly) {
                    this.getAndSaveBuildSlot();
                }
                Util.showChatMessage("\u00a76Stage was altered. Rebuilding!");
                return;
            }
        }
        this.currentSong.play();
        boolean somethingPlayed = false;
        this.currentSong.advanceTime();
        while (this.currentSong.reachedNextNote()) {
            class_2338 bp;
            Note note = this.currentSong.getNextNote();
            if (note.velocity < Config.getConfig().velocityThreshold || (bp = this.stage.noteblockPositions.get(note.noteId)) == null) continue;
            this.attackBlock(bp);
            somethingPlayed = true;
        }
        if (somethingPlayed) {
            this.stopAttack();
        }
        if (this.currentSong.finished()) {
            Util.showChatMessage("\u00a76Done playing \u00a73" + this.currentSong.name);
            this.currentSong = null;
        }
    }

    private void setPlayProgressDisplay() {
        long currentTime = Math.min(this.currentSong.time, this.currentSong.length);
        long totalTime = this.currentSong.length;
        class_5250 songText = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Now playing: ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)this.currentSong.name).method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" | ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)String.format("%s/%s", Util.formatTime(currentTime), Util.formatTime(totalTime))).method_27692(class_124.field_1062));
        if (this.currentSong.looping) {
            if (this.currentSong.loopCount > 0) {
                songText.method_10852((class_2561)class_2561.method_43470((String)String.format(" | Loop (%d/%d)", this.currentSong.currentLoop, this.currentSong.loopCount)).method_27692(class_124.field_1065));
            } else {
                songText.method_10852((class_2561)class_2561.method_43470((String)" | Looping enabled").method_27692(class_124.field_1065));
            }
        }
        class_5250 playlistText = class_2561.method_43473();
        if (this.currentPlaylist != null && this.currentPlaylist.loaded) {
            playlistText = playlistText.method_10852((class_2561)class_2561.method_43470((String)"Playlist: ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)this.currentPlaylist.name).method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" | ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)String.format(" (%s/%s)", this.currentPlaylist.songNumber, this.currentPlaylist.songs.size())).method_27692(class_124.field_1062));
            if (this.currentPlaylist.loop) {
                playlistText.method_10852((class_2561)class_2561.method_43470((String)" | Looping").method_27692(class_124.field_1065));
            }
            if (this.currentPlaylist.shuffle) {
                playlistText.method_10852((class_2561)class_2561.method_43470((String)" | Shuffled").method_27692(class_124.field_1065));
            }
        }
        ProgressDisplay.getInstance().setText(songText, playlistText);
    }

    private void handleCleanup() {
        this.setCleanupProgressDisplay();
        if (this.buildStartDelay > 0) {
            --this.buildStartDelay;
            return;
        }
        class_638 world = SongPlayer.MC.field_1687;
        if (SongPlayer.MC.field_1761.method_2920() != class_1934.field_9220) {
            return;
        }
        if (this.cleanupBreakList.isEmpty() && this.cleanupPlaceList.isEmpty()) {
            if (this.buildEndDelay > 0) {
                --this.buildEndDelay;
                return;
            }
            this.checkCleanupStatus();
            int cleanupHash = 31 * this.cleanupBreakList.hashCode() + this.cleanupPlaceList.hashCode();
            if (cleanupHash == this.lastCleanupHash) {
                this.cleaningUp = false;
                Util.showChatMessage("\u00a76Stopped restoring original blocks due to infinite loop being detected");
                if (!this.cleanupUnplaceableBlocks.isEmpty()) {
                    Util.showChatMessage(String.format("\u00a73%d \u00a76blocks could not be restored", this.cleanupUnplaceableBlocks.size()));
                }
                return;
            }
            this.lastCleanupHash = cleanupHash;
            this.lastStage.sendMovementPacketToStagePosition();
        }
        if (!this.cleanupBreakList.isEmpty()) {
            this.incrementBreakAllowance();
            while (this.consumeBreakAllowance()) {
                if (this.cleanupBreakList.isEmpty()) continue;
                class_2338 bp = this.cleanupBreakList.poll();
                this.attackBlock(bp);
            }
            this.buildEndDelay = 20;
        } else if (!this.cleanupPlaceList.isEmpty()) {
            this.incrementPlaceAllowance();
            while (this.consumePlaceAllowance()) {
                class_2680 desiredBlockState;
                class_2338 bp;
                class_2680 actualBlockState;
                if (this.cleanupPlaceList.isEmpty() || (actualBlockState = world.method_8320(bp = this.cleanupPlaceList.pollFirst())) == (desiredBlockState = this.originalBlocks.get(bp))) continue;
                this.holdBlock(desiredBlockState, this.buildSlot);
                if (!actualBlockState.method_26215() && !actualBlockState.method_51176()) {
                    this.attackBlock(bp);
                }
                this.placeBlock(bp);
            }
            this.buildEndDelay = 20;
        } else {
            this.originalBlocks.clear();
            this.cleaningUp = false;
            Util.showChatMessage("\u00a76Finished restoring original blocks");
            if (!this.cleanupUnplaceableBlocks.isEmpty()) {
                Util.showChatMessage(String.format("\u00a73%d \u00a76blocks could not be restored", this.cleanupUnplaceableBlocks.size()));
            }
        }
    }

    private void checkCleanupStatus() {
        class_638 world = SongPlayer.MC.field_1687;
        this.cleanupPlaceList.clear();
        this.cleanupBreakList.clear();
        this.cleanupUnplaceableBlocks.clear();
        for (class_2338 bp2 : this.originalBlocks.keySet()) {
            class_2680 desiredBlockState;
            class_2680 actualBlockState = world.method_8320(bp2);
            if (actualBlockState == (desiredBlockState = this.originalBlocks.get(bp2))) continue;
            if (this.isPlaceable(desiredBlockState)) {
                this.cleanupPlaceList.add(bp2);
            }
            if (actualBlockState.method_26215() || actualBlockState.method_51176()) continue;
            this.cleanupBreakList.add(bp2);
        }
        this.cleanupBreakList = this.cleanupBreakList.stream().sorted((a, b) -> {
            double b_angle;
            int b_dz;
            int b_dy;
            int b_dx;
            int b_dist;
            int a_dz;
            int a_dy;
            int a_dx;
            int a_dist;
            boolean a_grav = SongPlayer.MC.field_1687.method_8320(a).method_26204() instanceof class_2346;
            boolean b_grav = SongPlayer.MC.field_1687.method_8320(b).method_26204() instanceof class_2346;
            if (a_grav && !b_grav) {
                return 1;
            }
            if (!a_grav && b_grav) {
                return -1;
            }
            if (a_grav && b_grav) {
                if (a.method_10264() < b.method_10264()) {
                    return -1;
                }
                if (a.method_10264() > b.method_10264()) {
                    return 1;
                }
            }
            if ((a_dist = (a_dx = a.method_10263() - this.lastStage.position.method_10263()) * a_dx + (a_dy = a.method_10264() - this.lastStage.position.method_10264()) * a_dy + (a_dz = a.method_10260() - this.lastStage.position.method_10260()) * a_dz) < (b_dist = (b_dx = b.method_10263() - this.lastStage.position.method_10263()) * b_dx + (b_dy = b.method_10264() - this.lastStage.position.method_10264()) * b_dy + (b_dz = b.method_10260() - this.lastStage.position.method_10260()) * b_dz)) {
                return -1;
            }
            if (a_dist > b_dist) {
                return 1;
            }
            double a_angle = Math.atan2(a_dz, a_dx);
            if (a_angle < (b_angle = Math.atan2(b_dz, b_dx))) {
                return -1;
            }
            if (a_angle > b_angle) {
                return 1;
            }
            return 0;
        }).collect(Collectors.toCollection(LinkedList::new));
        this.cleanupPlaceList = this.cleanupPlaceList.stream().sorted((a, b) -> {
            double b_angle;
            int b_dz;
            int b_dy;
            int b_dx;
            int b_dist;
            int a_dz;
            int a_dy;
            int a_dx;
            int a_dist;
            boolean a_grav = this.originalBlocks.get(a).method_26204() instanceof class_2346;
            boolean b_grav = this.originalBlocks.get(b).method_26204() instanceof class_2346;
            if (a_grav && !b_grav) {
                return -1;
            }
            if (!a_grav && b_grav) {
                return 1;
            }
            if (a_grav && b_grav) {
                if (a.method_10264() < b.method_10264()) {
                    return 1;
                }
                if (a.method_10264() > b.method_10264()) {
                    return -1;
                }
            }
            if ((a_dist = (a_dx = a.method_10263() - this.lastStage.position.method_10263()) * a_dx + (a_dy = a.method_10264() - this.lastStage.position.method_10264()) * a_dy + (a_dz = a.method_10260() - this.lastStage.position.method_10260()) * a_dz) < (b_dist = (b_dx = b.method_10263() - this.lastStage.position.method_10263()) * b_dx + (b_dy = b.method_10264() - this.lastStage.position.method_10264()) * b_dy + (b_dz = b.method_10260() - this.lastStage.position.method_10260()) * b_dz)) {
                return -1;
            }
            if (a_dist > b_dist) {
                return 1;
            }
            double a_angle = Math.atan2(a_dz, a_dx);
            if (a_angle < (b_angle = Math.atan2(b_dz, b_dx))) {
                return 1;
            }
            if (a_angle > b_angle) {
                return -1;
            }
            return 0;
        }).collect(Collectors.toCollection(LinkedList::new));
        this.cleanupPlaceList = this.cleanupPlaceList.reversed();
        this.cleanupTotalBlocksToPlace = this.cleanupPlaceList.size();
        boolean noNecessaryBreaks = this.cleanupBreakList.stream().allMatch(bp -> world.method_8320(bp).method_26204().method_9564().equals((Object)this.originalBlocks.get(bp).method_26204().method_9564()));
        boolean noNecessaryPlacements = this.cleanupPlaceList.stream().allMatch(bp -> bp.equals((Object)this.lastStage.position) || bp.equals((Object)this.lastStage.position.method_10084()) || world.method_8320(bp).method_26204().method_9564().equals((Object)this.originalBlocks.get(bp).method_26204().method_9564()));
        if (noNecessaryBreaks && noNecessaryPlacements) {
            this.cleanupUnplaceableBlocks.addAll(this.cleanupPlaceList);
            this.cleanupPlaceList.clear();
        }
    }

    private void setCleanupProgressDisplay() {
        class_5250 buildText = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Rebuilding original blocks | ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)(this.cleanupTotalBlocksToPlace - this.cleanupPlaceList.size() + "/" + this.cleanupTotalBlocksToPlace)).method_27692(class_124.field_1062));
        ProgressDisplay.getInstance().setText(buildText, class_2561.method_43473());
    }

    public void reset() {
        this.currentSong = null;
        this.currentPlaylist = null;
        this.songQueue.clear();
        this.stage = null;
        this.buildSlot = -1;
        this.removeFakePlayer();
        this.cleaningUp = false;
        this.dirty = false;
    }

    public void restoreStateAndReset() {
        this.restoreStateAndReset(true);
    }

    public void restoreStateAndReset(boolean returnToStage) {
        if (returnToStage && this.lastStage != null) {
            this.lastStage.movePlayerToStagePosition();
        }
        if (this.originalGamemode != SongPlayer.MC.field_1761.method_2920() && !Config.getConfig().survivalOnly) {
            if (this.originalGamemode == class_1934.field_9220) {
                this.sendGamemodeCommand(Config.getConfig().creativeCommand);
            } else if (this.originalGamemode == class_1934.field_9215) {
                this.sendGamemodeCommand(Config.getConfig().survivalCommand);
            }
        }
        if (!SongPlayer.MC.field_1724.method_31549().field_7478) {
            SongPlayer.MC.field_1724.method_31549().field_7479 = false;
        }
        if (!Config.getConfig().survivalOnly) {
            this.restoreBuildSlot();
        }
        this.reset();
    }

    public void partialResetAndCleanup() {
        this.restoreBuildSlot();
        this.currentSong = null;
        this.currentPlaylist = null;
        this.songQueue.clear();
        this.stage = null;
        this.buildSlot = -1;
        this.startCleanup();
    }

    public void removeFakePlayer() {
        if (this.fakePlayer != null) {
            this.fakePlayer.method_5650(class_1297.class_5529.field_26999);
            this.fakePlayer = null;
        }
    }

    public void onNotIngame() {
        this.currentSong = null;
        this.currentPlaylist = null;
        this.songQueue.clear();
    }

    private void prepareStage() {
        if (this.stage == null) {
            this.lastStage = this.stage = new Stage();
            this.originalBlocks.clear();
            this.stage.movePlayerToStagePosition();
        } else {
            this.stage.sendMovementPacketToStagePosition();
        }
    }

    private void sendGamemodeCommand(String command) {
        this.cachedCommand = command;
    }

    private void sendMessage(String message) {
        this.cachedMessage = message;
    }

    private void checkCommandCache() {
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.lastCommandTime + 1500L && this.cachedCommand != null) {
            Util.sendCommand(this.cachedCommand);
            this.cachedCommand = null;
            this.lastCommandTime = currentTime;
        } else if (currentTime >= this.lastCommandTime + 500L && this.cachedMessage != null) {
            if (this.cachedMessage.startsWith("/")) {
                Util.sendCommand(this.cachedMessage.substring(1));
            } else {
                Util.sendChatMessage(this.cachedMessage);
            }
            this.cachedMessage = null;
            this.lastCommandTime = currentTime;
        }
    }

    private void setCreativeIfNeeded() {
        this.cachedCommand = null;
        if (SongPlayer.MC.field_1761.method_2920() != class_1934.field_9220) {
            this.sendGamemodeCommand(Config.getConfig().creativeCommand);
        }
    }

    private void setSurvivalIfNeeded() {
        this.cachedCommand = null;
        if (SongPlayer.MC.field_1761.method_2920() != class_1934.field_9215) {
            this.sendGamemodeCommand(Config.getConfig().survivalCommand);
        }
    }

    private void holdNoteblock(int id, int slot) {
        class_1661 inventory = SongPlayer.MC.field_1724.method_31548();
        inventory.method_61496(slot);
        ((ClientPlayerInteractionManagerAccessor)SongPlayer.MC.field_1761).invokeSyncSelectedSlot();
        int instrument = id / 25;
        int note = id % 25;
        class_1799 noteblockStack = class_1802.field_8643.method_7854();
        noteblockStack.method_57379(class_9334.field_49623, (Object)new class_9275(Map.of("instrument", this.instrumentNames[instrument], "note", Integer.toString(note))));
        inventory.method_67533().set(slot, (Object)noteblockStack);
        SongPlayer.MC.field_1761.method_2909(noteblockStack, 36 + slot);
    }

    private void holdBlock(class_2680 bs, int slot) {
        class_1661 inventory = SongPlayer.MC.field_1724.method_31548();
        inventory.method_61496(slot);
        ((ClientPlayerInteractionManagerAccessor)SongPlayer.MC.field_1761).invokeSyncSelectedSlot();
        class_1799 stack = new class_1799((class_1935)bs.method_26204());
        TreeMap<String, String> stateMap = new TreeMap<String, String>();
        for (Map.Entry entry : bs.method_11656().entrySet()) {
            class_2769 property = (class_2769)entry.getKey();
            Comparable value = (Comparable)entry.getValue();
            stateMap.put(property.method_11899(), class_156.method_650((class_2769)property, (Object)value));
        }
        stack.method_57379(class_9334.field_49623, (Object)new class_9275(stateMap));
        inventory.method_67533().set(slot, (Object)stack);
        SongPlayer.MC.field_1761.method_2909(stack, 36 + slot);
    }

    private void placeBlock(class_2338 bp) {
        double fx = Math.max(0.0, Math.min(1.0, (double)this.lastStage.position.method_10263() + 0.5 - (double)bp.method_10263()));
        double fy = Math.max(0.0, Math.min(1.0, (double)this.lastStage.position.method_10264() + 0.0 - (double)bp.method_10264()));
        double fz = Math.max(0.0, Math.min(1.0, (double)this.lastStage.position.method_10260() + 0.5 - (double)bp.method_10260()));
        this.doRotateIfNeeded(fx += (double)bp.method_10263(), fy += (double)bp.method_10264(), fz += (double)bp.method_10260());
        SongPlayer.MC.field_1761.method_2896(SongPlayer.MC.field_1724, class_1268.field_5808, new class_3965(new class_243(fx, fy, fz), class_2350.field_11036, bp, false));
        this.doSwingIfNeeded();
    }

    private void attackBlock(class_2338 bp) {
        this.doRotateIfNeeded((double)bp.method_10263() + 0.5, (double)bp.method_10264() + 0.5, (double)bp.method_10260() + 0.5);
        SongPlayer.MC.field_1761.method_2910(bp, class_2350.field_11036);
        this.doSwingIfNeeded();
    }

    private void stopAttack() {
        SongPlayer.MC.field_1761.method_2925();
    }

    private void recordBlocks(Iterable<class_2338> bpList) {
        for (class_2338 bp : bpList) {
            if (this.originalBlocks.containsKey(bp)) continue;
            class_2680 bs = SongPlayer.MC.field_1687.method_8320(bp);
            this.originalBlocks.put(bp, bs);
        }
    }

    private void recordStageBlocks() {
        this.recordBlocks(this.stage.requiredBreaks);
        this.recordBlocks(this.stage.missingNotes.stream().map(noteId -> this.stage.noteblockPositions.get(noteId)).filter(Objects::nonNull).toList());
    }

    private boolean isPlaceable(class_2680 bs) {
        Map entries = bs.method_11656();
        for (Map.Entry entry : entries.entrySet()) {
            class_2769 property = (class_2769)entry.getKey();
            Comparable value = (Comparable)entry.getValue();
            String propertyName = property.method_11899();
            String valueName = class_156.method_650((class_2769)property, (Object)value);
            if (!propertyName.equals("half") || !valueName.equals("upper")) continue;
            return false;
        }
        class_2248 block = bs.method_26204();
        if (bs.method_26215() || bs.method_51176()) {
            return false;
        }
        if (new class_1799((class_1935)block).method_7960()) {
            return false;
        }
        return !(block instanceof class_2323) && !(block instanceof class_2244);
    }

    private void doRotateIfNeeded(double lookX, double lookY, double lookZ) {
        if (Config.getConfig().rotate) {
            double d = lookX - ((double)this.lastStage.position.method_10263() + 0.5);
            double e = lookY - (double)((float)this.lastStage.position.method_10264() + SongPlayer.MC.field_1724.method_5751());
            double f = lookZ - ((double)this.lastStage.position.method_10260() + 0.5);
            double g = Math.sqrt(d * d + f * f);
            float pitch = class_3532.method_15393((float)((float)(-(class_3532.method_15349((double)e, (double)g) * 57.2957763671875))));
            float yaw = class_3532.method_15393((float)((float)(class_3532.method_15349((double)f, (double)d) * 57.2957763671875) - 90.0f));
            if (this.fakePlayer != null) {
                this.fakePlayer.method_36457(pitch);
                this.fakePlayer.method_36456(yaw);
                this.fakePlayer.method_5847(yaw);
            }
            SongPlayer.MC.field_1724.field_3944.method_48296().method_10743((class_2596)new class_2828.class_2830((double)this.lastStage.position.method_10263() + 0.5, (double)this.lastStage.position.method_10264(), (double)this.lastStage.position.method_10260() + 0.5, yaw, pitch, true, false));
        }
    }

    private void doSwingIfNeeded() {
        if (Config.getConfig().swing) {
            SongPlayer.MC.field_1724.method_6104(class_1268.field_5808);
            if (this.fakePlayer != null) {
                this.fakePlayer.method_6104(class_1268.field_5808);
            }
        }
    }

    private void getAndSaveBuildSlot() {
        this.buildSlot = SongPlayer.MC.field_1724.method_31548().method_7386();
        this.prevHeldItem = SongPlayer.MC.field_1724.method_31548().method_5438(this.buildSlot);
    }

    private void restoreBuildSlot() {
        if (this.buildSlot != -1) {
            SongPlayer.MC.field_1724.method_31548().method_5447(this.buildSlot, this.prevHeldItem);
            SongPlayer.MC.field_1761.method_2909(this.prevHeldItem, 36 + this.buildSlot);
            this.buildSlot = -1;
        }
    }

    private void incrementBreakAllowance() {
        this.breakAllowance += Config.getConfig().breakSpeed / 20.0;
    }

    private boolean consumeBreakAllowance() {
        if (this.breakAllowance >= 1.0) {
            this.breakAllowance -= 1.0;
            return true;
        }
        return false;
    }

    private void incrementPlaceAllowance() {
        this.placeAllowance += Config.getConfig().placeSpeed / 20.0;
    }

    private boolean consumePlaceAllowance() {
        if (this.placeAllowance >= 1.0) {
            this.placeAllowance -= 1.0;
            return true;
        }
        return false;
    }

    public boolean isIdle() {
        return this.currentSong == null && this.currentPlaylist == null && this.songQueue.isEmpty() && !this.cleaningUp && !this.dirty;
    }
}

