/*
 * Decompiled with CFR 0.152.
 */
package com.github.hhhzzzsss.songplayer.playing;

import com.github.hhhzzzsss.songplayer.Config;
import com.github.hhhzzzsss.songplayer.SongPlayer;
import com.github.hhhzzzsss.songplayer.Util;
import com.github.hhhzzzsss.songplayer.song.Instrument;
import com.github.hhhzzzsss.songplayer.song.Song;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2828;
import net.minecraft.class_310;

public class Stage {
    private final class_310 MC = SongPlayer.MC;
    public String worldName;
    public String serverIdentifier;
    public class_2338 position;
    public HashMap<Integer, class_2338> noteblockPositions = new HashMap();
    public LinkedList<class_2338> requiredBreaks = new LinkedList();
    public TreeSet<Integer> missingNotes = new TreeSet();
    public int totalMissingNotes = 0;
    public LinkedList<class_2338> requiredClicks = new LinkedList();

    public Stage() {
        this.position = this.MC.field_1724.method_24515();
        this.worldName = Util.getWorldName();
        this.serverIdentifier = Util.getServerIdentifier();
        System.out.println("Server identifier: " + this.serverIdentifier);
    }

    public void movePlayerToStagePosition() {
        this.MC.field_1724.method_5808((double)this.position.method_10263() + 0.5, (double)this.position.method_10264() + 0.0, (double)this.position.method_10260() + 0.5, this.MC.field_1724.method_36454(), this.MC.field_1724.method_36455());
        this.MC.field_1724.method_18799(class_243.field_1353);
        this.sendMovementPacketToStagePosition();
    }

    public void sendMovementPacketToStagePosition() {
        SongPlayer.MC.method_1562().method_52787((class_2596)new class_2828.class_2830((double)this.position.method_10263() + 0.5, (double)this.position.method_10264(), (double)this.position.method_10260() + 0.5, SongPlayer.MC.field_1724.method_36454(), SongPlayer.MC.field_1724.method_36455(), true, false));
    }

    public void checkBuildStatus(Song song) {
        this.noteblockPositions.clear();
        this.missingNotes.clear();
        for (int i = 0; i < 400; ++i) {
            if (!song.requiredNotes[i]) continue;
            this.missingNotes.add(i);
        }
        ArrayList<class_2338> noteblockLocations = new ArrayList<class_2338>();
        HashSet<class_2338> breakLocations = new HashSet<class_2338>();
        switch (Config.getConfig().stageType.ordinal()) {
            case 0: {
                this.loadDefaultBlocks(noteblockLocations, breakLocations);
                break;
            }
            case 1: {
                this.loadWideBlocks(noteblockLocations, breakLocations);
                break;
            }
            case 2: {
                this.loadSphericalBlocks(noteblockLocations, breakLocations);
            }
        }
        noteblockLocations.sort((a, b) -> {
            double b_angle;
            int b_dz;
            int b_dx;
            int b_dist;
            int a_dz;
            int a_dy = a.method_10264() - this.position.method_10264();
            int b_dy = b.method_10264() - this.position.method_10264();
            if (a_dy == -1) {
                a_dy = 0;
            }
            if (b_dy == -1) {
                b_dy = 0;
            }
            if (Math.abs(a_dy) < Math.abs(b_dy)) {
                return -1;
            }
            if (Math.abs(a_dy) > Math.abs(b_dy)) {
                return 1;
            }
            int a_dx = a.method_10263() - this.position.method_10263();
            int a_dist = a_dx * a_dx + (a_dz = a.method_10260() - this.position.method_10260()) * a_dz;
            if (a_dist < (b_dist = (b_dx = b.method_10263() - this.position.method_10263()) * b_dx + (b_dz = b.method_10260() - this.position.method_10260()) * b_dz)) {
                return -1;
            }
            if (a_dist > b_dist) {
                return 1;
            }
            double a_angle = Math.atan2(a_dz, a_dx);
            if (a_angle < (b_angle = Math.atan2(b_dz, b_dx))) {
                return -1;
            }
            if (a_angle > b_angle) {
                return 1;
            }
            return 0;
        });
        ArrayList<class_2338> unusedNoteblockLocations = new ArrayList<class_2338>();
        for (class_2338 nbPos : noteblockLocations) {
            class_2680 bs = SongPlayer.MC.field_1687.method_8320(nbPos);
            int blockId = class_2248.method_9507((class_2680)bs);
            if (blockId >= SongPlayer.NOTEBLOCK_BASE_ID && blockId < SongPlayer.NOTEBLOCK_BASE_ID + 800) {
                int noteId = (blockId - SongPlayer.NOTEBLOCK_BASE_ID) / 2;
                if (this.missingNotes.contains(noteId)) {
                    this.missingNotes.remove(noteId);
                    this.noteblockPositions.put(noteId, nbPos);
                    continue;
                }
                unusedNoteblockLocations.add(nbPos);
                continue;
            }
            unusedNoteblockLocations.add(nbPos);
        }
        if (this.missingNotes.size() > unusedNoteblockLocations.size()) {
            while (this.missingNotes.size() > unusedNoteblockLocations.size()) {
                this.missingNotes.pollLast();
            }
        }
        int idx = 0;
        for (int noteId : this.missingNotes) {
            class_2338 bp2 = (class_2338)unusedNoteblockLocations.get(idx++);
            this.noteblockPositions.put(noteId, bp2);
        }
        for (class_2338 bp3 : this.noteblockPositions.values()) {
            breakLocations.add(bp3.method_10084());
        }
        this.requiredBreaks = breakLocations.stream().filter(bp -> {
            class_2680 bs = SongPlayer.MC.field_1687.method_8320(bp);
            return !bs.method_26215() && !bs.method_51176();
        }).sorted((a, b) -> {
            double b_angle;
            int b_dz;
            int b_dx;
            int b_dist;
            int a_dz;
            if (a.method_10264() < b.method_10264()) {
                return -1;
            }
            if (a.method_10264() > b.method_10264()) {
                return 1;
            }
            int a_dx = a.method_10263() - this.position.method_10263();
            int a_dist = a_dx * a_dx + (a_dz = a.method_10260() - this.position.method_10260()) * a_dz;
            if (a_dist < (b_dist = (b_dx = b.method_10263() - this.position.method_10263()) * b_dx + (b_dz = b.method_10260() - this.position.method_10260()) * b_dz)) {
                return -1;
            }
            if (a_dist > b_dist) {
                return 1;
            }
            double a_angle = Math.atan2(a_dz, a_dx);
            if (a_angle < (b_angle = Math.atan2(b_dz, b_dx))) {
                return -1;
            }
            if (a_angle > b_angle) {
                return 1;
            }
            return 0;
        }).collect(Collectors.toCollection(LinkedList::new));
        if (this.requiredBreaks.stream().allMatch(bp -> !this.withinBreakingDist(bp.method_10263() - this.position.method_10263(), bp.method_10264() - this.position.method_10264(), bp.method_10260() - this.position.method_10260()))) {
            this.requiredBreaks.clear();
        }
        this.totalMissingNotes = this.missingNotes.size();
    }

    public void checkSurvivalBuildStatus(Song song) throws NotEnoughInstrumentsException {
        this.noteblockPositions.clear();
        Map<class_2338, Integer>[] instrumentMap = this.loadSurvivalBlocks();
        int[] requiredInstruments = new int[16];
        boolean hasMissing = false;
        for (int instrumentId = 0; instrumentId < 16; ++instrumentId) {
            for (int pitch = 0; pitch < 25; ++pitch) {
                int noteId = instrumentId * 25 + pitch;
                if (!song.requiredNotes[noteId]) continue;
                int n = instrumentId;
                requiredInstruments[n] = requiredInstruments[n] + 1;
            }
            if (requiredInstruments[instrumentId] <= instrumentMap[instrumentId].size()) continue;
            hasMissing = true;
        }
        if (hasMissing) {
            int[] foundInstruments = new int[16];
            for (int i = 0; i < 16; ++i) {
                foundInstruments[i] = instrumentMap[i].size();
            }
            throw new NotEnoughInstrumentsException(requiredInstruments, foundInstruments);
        }
        for (int noteid = 0; noteid < 400; ++noteid) {
            if (!song.requiredNotes[noteid]) continue;
            int instrumentId = noteid / 25;
            int targetPitch = noteid % 25;
            Map.Entry closest = (Map.Entry)instrumentMap[instrumentId].entrySet().stream().min((a, b) -> {
                int adist = (targetPitch - (Integer)a.getValue() + 25) % 25;
                int bdist = (targetPitch - (Integer)b.getValue() + 25) % 25;
                return Integer.compare(adist, bdist);
            }).get();
            class_2338 bp = (class_2338)closest.getKey();
            int closestPitch = (Integer)closest.getValue();
            instrumentMap[instrumentId].remove(bp);
            this.noteblockPositions.put(noteid, bp);
            int repetitions = (targetPitch - closestPitch + 25) % 25;
            for (int i = 0; i < repetitions; ++i) {
                this.requiredClicks.add(bp);
            }
        }
    }

    void loadDefaultBlocks(Collection<class_2338> noteblockLocations, Collection<class_2338> breakLocations) {
        int dz;
        int dx;
        for (dx = -4; dx <= 4; ++dx) {
            for (dz = -4; dz <= 4; ++dz) {
                if (Math.abs(dx) == 4 && Math.abs(dz) == 4) {
                    noteblockLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + 0, this.position.method_10260() + dz));
                    noteblockLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + 2, this.position.method_10260() + dz));
                    breakLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + 1, this.position.method_10260() + dz));
                    continue;
                }
                noteblockLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() - 1, this.position.method_10260() + dz));
                noteblockLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + 2, this.position.method_10260() + dz));
                breakLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + 0, this.position.method_10260() + dz));
                breakLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + 1, this.position.method_10260() + dz));
            }
        }
        for (dx = -4; dx <= 4; ++dx) {
            for (dz = -4; dz <= 4; ++dz) {
                if (this.withinBreakingDist(dx, -3, dz)) {
                    noteblockLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() - 3, this.position.method_10260() + dz));
                }
                if (!this.withinBreakingDist(dx, 4, dz)) continue;
                noteblockLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + 4, this.position.method_10260() + dz));
            }
        }
    }

    void loadWideBlocks(Collection<class_2338> noteblockLocations, Collection<class_2338> breakLocations) {
        for (int dx = -5; dx <= 5; ++dx) {
            for (int dz = -5; dz <= 5; ++dz) {
                if (this.withinBreakingDist(dx, 2, dz)) {
                    noteblockLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + 2, this.position.method_10260() + dz));
                    if (this.withinBreakingDist(dx, -1, dz)) {
                        noteblockLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() - 1, this.position.method_10260() + dz));
                        breakLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + 0, this.position.method_10260() + dz));
                        breakLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + 1, this.position.method_10260() + dz));
                    } else if (this.withinBreakingDist(dx, 0, dz)) {
                        noteblockLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + 0, this.position.method_10260() + dz));
                        breakLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + 1, this.position.method_10260() + dz));
                    }
                }
                if (this.withinBreakingDist(dx, -3, dz)) {
                    noteblockLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() - 3, this.position.method_10260() + dz));
                }
                if (!this.withinBreakingDist(dx, 4, dz)) continue;
                noteblockLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + 4, this.position.method_10260() + dz));
            }
        }
    }

    void loadSphericalBlocks(Collection<class_2338> noteblockLocations, Collection<class_2338> breakLocations) {
        int[] yLayers = new int[]{-4, -2, -1, 0, 1, 2, 3, 4, 5, 6};
        for (int dx = -5; dx <= 5; ++dx) {
            for (int dz = -5; dz <= 5; ++dz) {
                block14: for (int dy : yLayers) {
                    int adx = Math.abs(dx);
                    int adz = Math.abs(dz);
                    switch (dy) {
                        case -4: {
                            if (adx < 3 && adz < 3) {
                                noteblockLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + dy, this.position.method_10260() + dz));
                                continue block14;
                            }
                            if (!(adx == 3 ^ adz == 3) || !(adx == 0 ^ adz == 0)) continue block14;
                            noteblockLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + dy, this.position.method_10260() + dz));
                            continue block14;
                        }
                        case -2: {
                            if (adz == 0 && adx == 0 || adz * adx > 9) continue block14;
                            if (adz + adx == 5 && adx != 0 && adz != 0) {
                                noteblockLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + dy + 1, this.position.method_10260() + dz));
                                noteblockLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + dy - 1, this.position.method_10260() + dz));
                                continue block14;
                            }
                            if (adz * adx == 3) {
                                noteblockLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + dy + 1, this.position.method_10260() + dz));
                                noteblockLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + dy - 1, this.position.method_10260() + dz));
                                continue block14;
                            }
                            if (adx < 3 && adz < 3 && adx + adz > 0) {
                                noteblockLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + dy, this.position.method_10260() + dz));
                                breakLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + dy + 2, this.position.method_10260() + dz));
                                continue block14;
                            }
                            if (adz == 0 ^ adx == 0) {
                                noteblockLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + dy, this.position.method_10260() + dz));
                                breakLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + dy + 2, this.position.method_10260() + dz));
                                continue block14;
                            }
                            if (adz * adx == 10) {
                                noteblockLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + dy, this.position.method_10260() + dz));
                                breakLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + dy + 2, this.position.method_10260() + dz));
                                continue block14;
                            }
                            if (adz + adx != 6) continue block14;
                            noteblockLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + dy, this.position.method_10260() + dz));
                            if (!(adx == 5 ^ adz == 5)) continue block14;
                            breakLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + dy + 2, this.position.method_10260() + dz));
                            continue block14;
                        }
                        case -1: {
                            if (adx + adz != 7 && adx + adz != 0) continue block14;
                            noteblockLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + dy, this.position.method_10260() + dz));
                            continue block14;
                        }
                        case 0: {
                            int check = adx + adz;
                            if (check != 8 && check != 6 || adx * adz <= 5) continue block14;
                            noteblockLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + dy, this.position.method_10260() + dz));
                            continue block14;
                        }
                        case 1: {
                            int addl1 = adx + adz;
                            if (addl1 == 7 || addl1 == 3 || addl1 == 2) {
                                noteblockLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + dy, this.position.method_10260() + dz));
                                continue block14;
                            }
                            if (adx == 5 ^ adz == 5 && addl1 < 7) {
                                noteblockLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + dy, this.position.method_10260() + dz));
                                continue block14;
                            }
                            if (addl1 == 4 && adx * adz != 0) {
                                noteblockLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + dy, this.position.method_10260() + dz));
                                continue block14;
                            }
                            if (adx + adz >= 7) continue block14;
                            breakLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + dy, this.position.method_10260() + dz));
                            continue block14;
                        }
                        case 2: {
                            int addl2 = adx + adz;
                            if (adx == 5 || adz == 5) continue block14;
                            if (addl2 == 8 || addl2 == 6 || addl2 == 5 || addl2 == 1) {
                                noteblockLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + dy, this.position.method_10260() + dz));
                                continue block14;
                            }
                            if (addl2 == 4 && adx == 0 ^ adz == 0) {
                                noteblockLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + dy, this.position.method_10260() + dz));
                                continue block14;
                            }
                            if (addl2 != 0) continue block14;
                            breakLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + dy, this.position.method_10260() + dz));
                            continue block14;
                        }
                        case 3: {
                            if (adx * adz == 12 || adx + adz == 0) {
                                noteblockLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + dy, this.position.method_10260() + dz));
                                continue block14;
                            }
                            if (adx == 5 ^ adz == 5 && adx < 2 ^ adz < 2) {
                                noteblockLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + dy, this.position.method_10260() + dz));
                                continue block14;
                            }
                            if (adx > 3 || adz > 3 || adx + adz <= 1 || adx + adz >= 5) continue block14;
                            noteblockLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + dy, this.position.method_10260() + dz));
                            continue block14;
                        }
                        case 4: {
                            if (adx == 5 || adz == 5) continue block14;
                            if (adx + adz == 4 && adx * adz == 0) {
                                noteblockLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + dy, this.position.method_10260() + dz));
                                continue block14;
                            }
                            int addl4 = adx + adz;
                            if (addl4 != 1 && addl4 != 5 && addl4 != 6) continue block14;
                            noteblockLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + dy, this.position.method_10260() + dz));
                            continue block14;
                        }
                        case 5: {
                            int addl5;
                            if (adx > 3 || adz > 3 || (addl5 = adx + adz) <= 1 || addl5 >= 5) continue block14;
                            noteblockLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + dy, this.position.method_10260() + dz));
                            continue block14;
                        }
                        case 6: {
                            if (adx + adz >= 2) continue block14;
                            noteblockLocations.add(new class_2338(this.position.method_10263() + dx, this.position.method_10264() + dy, this.position.method_10260() + dz));
                        }
                    }
                }
            }
        }
    }

    Map<class_2338, Integer>[] loadSurvivalBlocks() {
        Map[] instrumentMap = new Map[16];
        for (int i = 0; i < 16; ++i) {
            instrumentMap[i] = new TreeMap();
        }
        for (int dx = -5; dx <= 5; ++dx) {
            for (int dz = -5; dz <= 5; ++dz) {
                for (int dy : new int[]{-1, 0, 1, 2, -2, 3, -3, 4, -4, 5, 6}) {
                    class_2338 bp = this.position.method_10069(dx, dy, dz);
                    class_2680 bs = SongPlayer.MC.field_1687.method_8320(bp);
                    class_2680 aboveBs = SongPlayer.MC.field_1687.method_8320(bp.method_10084());
                    int blockId = class_2248.method_9507((class_2680)bs);
                    if (blockId < SongPlayer.NOTEBLOCK_BASE_ID || blockId >= SongPlayer.NOTEBLOCK_BASE_ID + 800 || !aboveBs.method_26215()) continue;
                    int noteId = (blockId - SongPlayer.NOTEBLOCK_BASE_ID) / 2;
                    int instrument = noteId / 25;
                    int pitch = noteId % 25;
                    instrumentMap[instrument].put(bp, pitch);
                }
            }
        }
        return instrumentMap;
    }

    boolean withinBreakingDist(int dx, int dy, int dz) {
        double dy1 = (double)dy + 0.5 - 1.62;
        double dy2 = (double)dy + 0.5 - 1.27;
        return (double)(dx * dx) + dy1 * dy1 + (double)(dz * dz) < 35.999880000100006 && (double)(dx * dx) + dy2 * dy2 + (double)(dz * dz) < 35.999880000100006;
    }

    public boolean nothingToBuild() {
        if (!Config.getConfig().survivalOnly) {
            return this.requiredBreaks.isEmpty() && this.missingNotes.isEmpty();
        }
        return this.requiredClicks.isEmpty();
    }

    public boolean hasBreakingModification() {
        for (Map.Entry<Integer, class_2338> entry : this.noteblockPositions.entrySet()) {
            class_2680 bs = SongPlayer.MC.field_1687.method_8320(entry.getValue());
            int blockId = class_2248.method_9507((class_2680)bs);
            int actualNoteId = (blockId - SongPlayer.NOTEBLOCK_BASE_ID) / 2;
            if (actualNoteId < 0 || actualNoteId >= 400) {
                return true;
            }
            int actualInstrument = actualNoteId / 25;
            int actualPitch = actualNoteId % 25;
            int targetInstrument = entry.getKey() / 25;
            int targetPitch = entry.getKey() % 25;
            if (targetPitch != actualPitch) {
                return true;
            }
            if (targetInstrument != actualInstrument) {
                return true;
            }
            class_2680 aboveBs = SongPlayer.MC.field_1687.method_8320(entry.getValue().method_10084());
            if (aboveBs.method_26215() || aboveBs.method_51176()) continue;
            return true;
        }
        return false;
    }

    public class_243 getOriginBottomCenter() {
        return class_243.method_24955((class_2382)this.position);
    }

    public static enum StageType {
        DEFAULT,
        WIDE,
        SPHERICAL;

    }

    public class NotEnoughInstrumentsException
    extends Exception {
        public int[] requiredInstruments;
        public int[] foundInstruments;

        public NotEnoughInstrumentsException(int[] requiredInstruments, int[] foundInstruments) {
            this.requiredInstruments = requiredInstruments;
            this.foundInstruments = foundInstruments;
        }

        public void giveInstrumentSummary() {
            Util.showChatMessage("\u00a7c------------------------------");
            Util.showChatMessage("\u00a7cMissing instruments required to play song:");
            for (int instrumentId = 0; instrumentId < 16; ++instrumentId) {
                if (this.requiredInstruments[instrumentId] <= 0) continue;
                Instrument instrument = Instrument.getInstrumentFromId(instrumentId);
                Util.showChatMessage(String.format("    \u00a73%s (%s): \u00a7%s%d/%d", instrument.name(), instrument.material, this.foundInstruments[instrumentId] < this.requiredInstruments[instrumentId] ? "c" : "a", this.foundInstruments[instrumentId], this.requiredInstruments[instrumentId]));
            }
            Util.showChatMessage("\u00a7c------------------------------");
        }
    }
}

