/*
 * Decompiled with CFR 0.152.
 */
package com.github.hhhzzzsss.songplayer.song;

import com.github.hhhzzzsss.songplayer.SongPlayer;
import com.github.hhhzzzsss.songplayer.Util;
import com.github.hhhzzzsss.songplayer.song.Song;
import com.github.hhhzzzsss.songplayer.song.SongLoaderThread;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Playlist {
    public static final String INDEX_FILE_NAME = "index.json";
    private static final Gson gson = new Gson();
    public String name;
    public boolean loop = false;
    public boolean shuffle = false;
    public List<String> index;
    public List<Path> songFiles;
    public List<Song> songs = new ArrayList<Song>();
    public List<Integer> ordering = null;
    public int songNumber = 0;
    public boolean loaded = false;
    public ArrayList<String> songsFailedToLoad = new ArrayList();

    public Playlist(Path directory, boolean loop, boolean shuffle) {
        this.name = directory.getFileName().toString();
        this.loop = loop;
        this.shuffle = shuffle;
        this.setShuffle(this.shuffle);
        if (Files.isDirectory(directory, new LinkOption[0])) {
            this.index = Playlist.validateAndLoadIndex(directory);
            this.songFiles = this.index.stream().map(name -> directory.resolve((String)name)).collect(Collectors.toList());
            new PlaylistLoaderThread().start();
        } else {
            this.ordering = new ArrayList<Integer>();
            this.loaded = true;
        }
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    public void setShuffle(boolean shuffle) {
        if (this.shuffle != shuffle && this.loaded) {
            this.loadOrdering(shuffle);
        }
        this.shuffle = shuffle;
    }

    public void loadOrdering(boolean shouldShuffle) {
        this.songNumber = 0;
        this.ordering = new ArrayList<Integer>();
        for (int i = 0; i < this.songs.size(); ++i) {
            this.ordering.add(i);
        }
        if (shouldShuffle) {
            Collections.shuffle(this.ordering);
        }
    }

    public Song getNext() {
        if (this.songs.isEmpty()) {
            return null;
        }
        if (this.songNumber >= this.songs.size()) {
            if (this.loop) {
                this.loadOrdering(this.shuffle);
            } else {
                return null;
            }
        }
        return this.songs.get(this.ordering.get(this.songNumber++));
    }

    private static List<String> validateAndLoadIndex(Path directory) {
        List<String> songNames = Playlist.getSongFiles(directory).map(Path::getFileName).map(Path::toString).collect(Collectors.toList());
        if (!Files.exists(Playlist.getIndexFile(directory), new LinkOption[0])) {
            Playlist.saveIndexSilently(directory, songNames);
            return songNames;
        }
        try {
            List<String> index = Playlist.loadIndex(directory);
            boolean modified = false;
            HashSet<String> songSet = new HashSet<String>(songNames);
            ListIterator<String> indexItr = index.listIterator();
            while (indexItr.hasNext()) {
                if (songSet.contains(indexItr.next())) continue;
                indexItr.remove();
                modified = true;
            }
            HashSet<String> indexSet = new HashSet<String>(index);
            for (String name : songNames) {
                if (indexSet.contains(name)) continue;
                index.add(name);
                indexSet.add(name);
                modified = true;
            }
            if (modified) {
                Playlist.saveIndexSilently(directory, index);
            }
            return index;
        }
        catch (Exception e) {
            return songNames;
        }
    }

    public static Path getIndexFile(Path directory) {
        return directory.resolve(INDEX_FILE_NAME);
    }

    public static Stream<Path> getSongFiles(Path directory) {
        try {
            Stream<Path> files = Files.list(directory);
            return files.filter(file -> !file.getFileName().toString().equals(INDEX_FILE_NAME));
        }
        catch (IOException e) {
            return null;
        }
    }

    private static List<String> loadIndex(Path directory) throws IOException {
        Path indexFile = Playlist.getIndexFile(directory);
        BufferedReader reader = Files.newBufferedReader(indexFile);
        Type type = new TypeToken<ArrayList<String>>(){}.getType();
        List index = (List)gson.fromJson((Reader)reader, type);
        reader.close();
        return index;
    }

    private static void saveIndex(Path directory, List<String> index) throws IOException {
        Path indexFile = Playlist.getIndexFile(directory);
        BufferedWriter writer = Files.newBufferedWriter(indexFile, new OpenOption[0]);
        writer.write(gson.toJson(index));
        writer.close();
    }

    private static void saveIndexSilently(Path directory, List<String> index) {
        try {
            Playlist.saveIndex(directory, index);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<String> listSongs(Path directory) throws IOException {
        if (!Files.exists(directory, new LinkOption[0])) {
            throw new IOException("Playlist does not exist");
        }
        return Playlist.validateAndLoadIndex(directory);
    }

    public static void createPlaylist(String playlist) throws IOException {
        Path playlistDir = Util.resolveWithIOException(SongPlayer.PLAYLISTS_DIR, playlist);
        Files.createDirectories(playlistDir, new FileAttribute[0]);
    }

    public static void addSong(Path directory, Path songFile) throws IOException {
        if (!Files.exists(directory, new LinkOption[0])) {
            throw new IOException("Playlist does not exist");
        }
        if (!Files.exists(songFile, new LinkOption[0])) {
            throw new IOException("Could not find specified song");
        }
        List<String> index = Playlist.validateAndLoadIndex(directory);
        if (index.contains(songFile.getFileName().toString())) {
            throw new IOException("Playlist already contains a song by this name");
        }
        Files.copy(songFile, Util.resolveWithIOException(directory, songFile.getFileName().toString()), new CopyOption[0]);
        index.add(songFile.getFileName().toString());
        Playlist.saveIndex(directory, index);
    }

    public static void removeSong(Path directory, String songName) throws IOException {
        if (!Files.exists(directory, new LinkOption[0])) {
            throw new IOException("Playlist does not exist");
        }
        Path songFile = Util.resolveWithIOException(directory, songName);
        if (!Files.exists(songFile, new LinkOption[0])) {
            throw new IOException("Playlist does not contain a song by this name");
        }
        List<String> index = Playlist.validateAndLoadIndex(directory);
        Files.delete(songFile);
        index.remove(songName);
        Playlist.saveIndex(directory, index);
    }

    public static void deletePlaylist(Path directory) throws IOException {
        if (!Files.exists(directory, new LinkOption[0])) {
            throw new IOException("Playlist does not exist");
        }
        Files.walk(directory, new FileVisitOption[0]).map(Path::toFile).sorted(Comparator.reverseOrder()).forEach(File::delete);
    }

    public static String renameSong(Path directory, int pos, String newName) throws IOException {
        List<String> index = Playlist.validateAndLoadIndex(directory);
        if (pos < 0 || pos >= index.size()) {
            throw new IOException("Index out of bounds");
        }
        Path oldPath = Util.resolveWithIOException(directory, index.get(pos));
        Files.move(oldPath, Util.resolveWithIOException(directory, newName), new CopyOption[0]);
        index.set(pos, newName);
        Playlist.saveIndex(directory, index);
        return oldPath.getFileName().toString();
    }

    private class PlaylistLoaderThread
    extends Thread {
        private PlaylistLoaderThread() {
        }

        @Override
        public void run() {
            for (Path file : Playlist.this.songFiles) {
                SongLoaderThread slt = new SongLoaderThread(file);
                slt.run();
                if (slt.exception != null) {
                    Playlist.this.songsFailedToLoad.add(file.getFileName().toString());
                    continue;
                }
                Playlist.this.songs.add(slt.song);
            }
            SongPlayer.MC.execute(() -> {
                Playlist.this.loadOrdering(Playlist.this.shuffle);
                Playlist.this.loaded = true;
            });
        }
    }
}

