/*
 * Decompiled with CFR 0.152.
 */
package com.github.hhhzzzsss.songplayer.song;

import com.github.hhhzzzsss.songplayer.song.Note;
import java.util.ArrayList;
import java.util.Collections;

public class Song {
    public ArrayList<Note> notes = new ArrayList();
    public String name;
    public int position = 0;
    public boolean[] requiredNotes = new boolean[400];
    public boolean looping = false;
    public boolean paused = true;
    public long startTime = 0L;
    public long length = 0L;
    public long time = 0L;
    public long loopPosition = 0L;
    public int loopCount = 0;
    public int currentLoop = 0;

    public Song(String name) {
        this.name = name;
    }

    public Note get(int i) {
        return this.notes.get(i);
    }

    public void add(Note e) {
        this.notes.add(e);
        this.requiredNotes[e.noteId] = true;
    }

    public void sort() {
        Collections.sort(this.notes);
    }

    public void play() {
        if (this.paused) {
            this.paused = false;
            this.startTime = System.currentTimeMillis() - this.time;
        }
    }

    public void pause() {
        if (!this.paused) {
            this.paused = true;
            this.advanceTime();
        }
    }

    public void reset() {
        this.paused = true;
        this.setTime(0L);
        this.currentLoop = 0;
    }

    public void setTime(long t) {
        this.time = t;
        this.startTime = System.currentTimeMillis() - this.time;
        this.position = 0;
        while (this.position < this.notes.size() && this.notes.get((int)this.position).time < t) {
            ++this.position;
        }
    }

    public void advanceTime() {
        this.time = System.currentTimeMillis() - this.startTime;
    }

    public boolean reachedNextNote() {
        if (this.position < this.notes.size()) {
            return this.notes.get((int)this.position).time <= this.time;
        }
        if (this.time > this.length && this.shouldLoop()) {
            this.loop();
            if (this.position < this.notes.size()) {
                return this.notes.get((int)this.position).time <= this.time;
            }
            return false;
        }
        return false;
    }

    public Note getNextNote() {
        if (this.position >= this.notes.size()) {
            if (this.shouldLoop()) {
                this.loop();
            } else {
                return null;
            }
        }
        return this.notes.get(this.position++);
    }

    public boolean finished() {
        return this.time > this.length && !this.shouldLoop();
    }

    private void loop() {
        this.position = 0;
        this.startTime += this.length - this.loopPosition;
        this.time -= this.length - this.loopPosition;
        while (this.position < this.notes.size() && this.notes.get((int)this.position).time < this.loopPosition) {
            ++this.position;
        }
        ++this.currentLoop;
    }

    private boolean shouldLoop() {
        if (this.looping) {
            if (this.loopCount == 0) {
                return true;
            }
            return this.currentLoop < this.loopCount;
        }
        return false;
    }

    public int size() {
        return this.notes.size();
    }
}

