/*
 * Decompiled with CFR 0.152.
 */
package com.github.hhhzzzsss.songplayer.song;

import com.github.hhhzzzsss.songplayer.SongPlayer;
import com.github.hhhzzzsss.songplayer.Util;
import com.github.hhhzzzsss.songplayer.conversion.MidiConverter;
import com.github.hhhzzzsss.songplayer.conversion.NBSConverter;
import com.github.hhhzzzsss.songplayer.conversion.TxtConverter;
import com.github.hhhzzzsss.songplayer.song.DownloadUtils;
import com.github.hhhzzzsss.songplayer.song.Song;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class SongLoaderThread
extends Thread {
    private String location;
    private Path songPath;
    private URL songUrl;
    public Exception exception;
    public Song song;
    public String filename;
    private boolean isUrl = false;

    protected SongLoaderThread() {
    }

    public SongLoaderThread(String location) throws IOException {
        this.location = location;
        if (location.startsWith("http://") || location.startsWith("https://")) {
            this.isUrl = true;
            this.songUrl = new URL(location);
        } else if (Files.exists(this.getSongFile(location), new LinkOption[0])) {
            this.songPath = this.getSongFile(location);
        } else if (Files.exists(this.getSongFile(location + ".mid"), new LinkOption[0])) {
            this.songPath = this.getSongFile(location + ".mid");
        } else if (Files.exists(this.getSongFile(location + ".midi"), new LinkOption[0])) {
            this.songPath = this.getSongFile(location + ".midi");
        } else if (Files.exists(this.getSongFile(location + ".nbs"), new LinkOption[0])) {
            this.songPath = this.getSongFile(location + ".nbs");
        } else {
            throw new IOException("Could not find song: " + location);
        }
    }

    public SongLoaderThread(Path file) {
        this.songPath = file;
    }

    @Override
    public void run() {
        try {
            byte[] bytes;
            if (this.isUrl) {
                bytes = DownloadUtils.DownloadToByteArray(this.songUrl, 0xA00000);
                this.filename = Paths.get(this.songUrl.toURI().getPath(), new String[0]).getFileName().toString();
            } else {
                bytes = Files.readAllBytes(this.songPath);
                this.filename = this.songPath.getFileName().toString();
            }
            try {
                this.song = MidiConverter.getSongFromBytes(bytes, this.filename);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.song == null) {
                try {
                    this.song = NBSConverter.getSongFromBytes(bytes, this.filename);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.song == null) {
                try {
                    this.song = TxtConverter.getSongFromBytes(bytes, this.filename);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.song == null) {
                throw new IOException("Invalid song format");
            }
        }
        catch (Exception e) {
            this.exception = e;
        }
    }

    private Path getSongFile(String name) throws IOException {
        return Util.resolveWithIOException(SongPlayer.SONG_DIR, name);
    }
}

