/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.effecttimerplus.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.terminalmc.effecttimerplus.EffectTimerPlus;
import dev.terminalmc.effecttimerplus.platform.Services;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Config {
    public final int version = 1;
    private static final Path DIR_PATH = Services.PLATFORM.getConfigDir();
    private static final String FILE_NAME = "effecttimerplus.json";
    private static final String BACKUP_FILE_NAME = "effecttimerplus.unreadable.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final double defaultScale = 1.0;
    public double scale = 1.0;
    public static final double defaultPotencyScale = (double)0.7f;
    public double potencyScale = 0.7f;
    public static final double defaultTimerScale = (double)0.7f;
    public double timerScale = 0.7f;
    public static final boolean defaultPotencyEnabled = true;
    public boolean potencyEnabled = true;
    public static final boolean defaultTimerEnabled = true;
    public boolean timerEnabled = true;
    public static final boolean defaultTimerEnabledAmbient = false;
    public boolean timerEnabledAmbient = false;
    public static final boolean defaultTimerWarnEnabled = true;
    public boolean timerWarnEnabled = true;
    public static final boolean defaultTimerFlashEnabled = true;
    public boolean timerFlashEnabled = true;
    public static final int defaultTimerWarnTime = 20;
    public int timerWarnTime = 20;
    public static final int defaultPotencyColor = -1140850689;
    public int potencyColor = -1140850689;
    public static final boolean defaultPotencyShadow = true;
    public boolean potencyShadow = true;
    public static final boolean defaultPotencyBack = false;
    public boolean potencyBack = false;
    public static final int defaultPotencyBackColor = -1140850689;
    public int potencyBackColor = -1140850689;
    public static final int defaultTimerColor = -1711276033;
    public int timerColor = -1711276033;
    public static final int defaultTimerWarnColor = -65536;
    public int timerWarnColor = -65536;
    public static final boolean defaultTimerShadow = true;
    public boolean timerShadow = true;
    public static final boolean defaultTimerBack = false;
    public boolean timerBack = false;
    public static final int defaultTimerBackColor = -1776213727;
    public int timerBackColor = -1776213727;
    public static final Integer[] locations = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7};
    public static final int defaultPotencyLocation = 2;
    public int potencyLocation = 2;
    public static final int defaultTimerLocation = 6;
    public int timerLocation = 6;
    private static Config instance = null;

    public static Config get() {
        if (instance == null) {
            instance = Config.load();
        }
        return instance;
    }

    public static Config getAndSave() {
        Config.get();
        Config.save();
        return instance;
    }

    public static Config reloadAndSave() {
        instance = Config.load();
        Config.save();
        return instance;
    }

    public static Config resetAndSave() {
        instance = new Config();
        Config.save();
        return instance;
    }

    private void validate() {
    }

    @NotNull
    public static Config load() {
        Path file = DIR_PATH.resolve(FILE_NAME);
        @Nullable Config config = null;
        if (Files.exists(file, new LinkOption[0]) && (config = Config.load(file, GSON)) == null) {
            Config.backup();
            EffectTimerPlus.LOG.warn("Resetting config", new Object[0]);
        }
        if (config == null) {
            config = new Config();
        }
        config.validate();
        return config;
    }

    @Nullable
    private static Config load(Path file, Gson gson) {
        Config config;
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file.toFile()), StandardCharsets.UTF_8);
        try {
            config = (Config)gson.fromJson((Reader)reader, Config.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                EffectTimerPlus.LOG.error("Unable to load config", e);
                return null;
            }
        }
        reader.close();
        return config;
    }

    private static void backup() {
        try {
            EffectTimerPlus.LOG.warn("Copying {} to {}", FILE_NAME, BACKUP_FILE_NAME);
            if (!Files.isDirectory(DIR_PATH, new LinkOption[0])) {
                Files.createDirectories(DIR_PATH, new FileAttribute[0]);
            }
            Path file = DIR_PATH.resolve(FILE_NAME);
            Path backupFile = file.resolveSibling(BACKUP_FILE_NAME);
            Files.move(file, backupFile, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            EffectTimerPlus.LOG.error("Unable to copy config file", e);
        }
    }

    public static void save() {
        if (instance == null) {
            return;
        }
        instance.validate();
        try {
            if (!Files.isDirectory(DIR_PATH, new LinkOption[0])) {
                Files.createDirectories(DIR_PATH, new FileAttribute[0]);
            }
            Path file = DIR_PATH.resolve(FILE_NAME);
            Path tempFile = file.resolveSibling(String.valueOf(file.getFileName()) + ".tmp");
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile.toFile()), StandardCharsets.UTF_8);){
                writer.write(GSON.toJson((Object)instance));
            }
            catch (IOException e) {
                throw new IOException(e);
            }
            Files.move(tempFile, file, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            EffectTimerPlus.onConfigSaved(instance);
        }
        catch (IOException e) {
            EffectTimerPlus.LOG.error("Unable to save config", e);
        }
    }
}

