/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.effecttimerplus.gui.screen;

import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.ColorControllerBuilder;
import dev.isxander.yacl3.api.controller.CyclingListControllerBuilder;
import dev.isxander.yacl3.api.controller.DoubleSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import dev.isxander.yacl3.gui.image.ImageRenderer;
import dev.terminalmc.effecttimerplus.config.Config;
import dev.terminalmc.effecttimerplus.mixin.accessor.GuiAccessor;
import dev.terminalmc.effecttimerplus.util.IndicatorUtil;
import dev.terminalmc.effecttimerplus.util.Localization;
import java.awt.Color;
import java.util.Objects;
import java.util.function.IntBinaryOperator;
import java.util.function.IntUnaryOperator;
import net.minecraft.class_10799;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_6880;
import net.minecraft.class_9848;
import org.joml.Matrix3x2fStack;

public class YaclScreenProvider {
    private static final IntUnaryOperator toAlpha = value -> value >> 24 & 0xFF;
    private static final IntUnaryOperator fromAlpha = value -> value * 0x1000000;
    private static final IntBinaryOperator withAlpha = (value, alpha) -> value - fromAlpha.applyAsInt(toAlpha.applyAsInt(value)) + alpha;

    static class_437 getConfigScreen(class_437 parent) {
        Config options = Config.get();
        Preview preview = new Preview();
        YetAnotherConfigLib.Builder builder = YetAnotherConfigLib.createBuilder().title((class_2561)Localization.localized("name", new Object[0])).save(Config::save);
        ConfigCategory.Builder timerCat = ConfigCategory.createBuilder().name((class_2561)Localization.localized("option", "timer", new Object[0]));
        timerCat.option(Option.createBuilder().name((class_2561)Localization.localized("option", "timer.enabled", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.timerEnabled = (Boolean)option.pendingValue();
        }).binding((Object)true, () -> options.timerEnabled, val -> {
            options.timerEnabled = val;
        }).controller(option -> BooleanControllerBuilder.create((Option)option).coloured(true)).build());
        timerCat.option(Option.createBuilder().name((class_2561)Localization.localized("option", "timer.ambient.enabled", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.timerEnabledAmbient = (Boolean)option.pendingValue();
        }).binding((Object)false, () -> options.timerEnabledAmbient, val -> {
            options.timerEnabledAmbient = val;
        }).controller(option -> BooleanControllerBuilder.create((Option)option).coloured(true)).build());
        timerCat.option(Option.createBuilder().name((class_2561)Localization.localized("option", "timer.warn.enabled", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.timerWarnEnabled = (Boolean)option.pendingValue();
        }).binding((Object)true, () -> options.timerWarnEnabled, val -> {
            options.timerWarnEnabled = val;
        }).controller(option -> BooleanControllerBuilder.create((Option)option).coloured(true)).build());
        timerCat.option(Option.createBuilder().name((class_2561)Localization.localized("option", "timer.warn.flash.enabled", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.timerFlashEnabled = (Boolean)option.pendingValue();
        }).binding((Object)true, () -> options.timerFlashEnabled, val -> {
            options.timerFlashEnabled = val;
        }).controller(option -> BooleanControllerBuilder.create((Option)option).coloured(true)).build());
        timerCat.option(Option.createBuilder().name((class_2561)Localization.localized("option", "timer.color", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.timerColor = YaclScreenProvider.fixAlpha(((Color)option.pendingValue()).getRGB());
        }).binding((Object)YaclScreenProvider.fromArgb(-1711276033), () -> YaclScreenProvider.fromArgb(options.timerColor), val -> {
            options.timerColor = YaclScreenProvider.fixAlpha(val.getRGB());
        }).controller(option -> ColorControllerBuilder.create((Option)option).allowAlpha(true)).build());
        timerCat.option(Option.createBuilder().name((class_2561)Localization.localized("option", "timer.shadow.enabled", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.timerShadow = (Boolean)option.pendingValue();
        }).binding((Object)true, () -> options.timerShadow, val -> {
            options.timerShadow = val;
        }).controller(option -> BooleanControllerBuilder.create((Option)option).coloured(true)).build());
        timerCat.option(Option.createBuilder().name((class_2561)Localization.localized("option", "timer.back.enabled", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.timerBack = (Boolean)option.pendingValue();
        }).binding((Object)false, () -> options.timerBack, val -> {
            options.timerBack = val;
        }).controller(option -> BooleanControllerBuilder.create((Option)option).coloured(true)).build());
        timerCat.option(Option.createBuilder().name((class_2561)Localization.localized("option", "timer.back.color", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.timerBackColor = YaclScreenProvider.fixAlpha(((Color)option.pendingValue()).getRGB());
        }).binding((Object)YaclScreenProvider.fromArgb(-1776213727), () -> YaclScreenProvider.fromArgb(options.timerBackColor), val -> {
            options.timerBackColor = YaclScreenProvider.fixAlpha(val.getRGB());
        }).controller(option -> ColorControllerBuilder.create((Option)option).allowAlpha(true)).build());
        timerCat.option(Option.createBuilder().name((class_2561)Localization.localized("option", "timer.warn.color", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.timerWarnColor = YaclScreenProvider.fixAlpha(((Color)option.pendingValue()).getRGB());
        }).binding((Object)YaclScreenProvider.fromArgb(-65536), () -> YaclScreenProvider.fromArgb(options.timerWarnColor), val -> {
            options.timerWarnColor = YaclScreenProvider.fixAlpha(val.getRGB());
        }).controller(option -> ColorControllerBuilder.create((Option)option).allowAlpha(true)).build());
        timerCat.option(Option.createBuilder().name((class_2561)Localization.localized("option", "timer.warn.time", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.timerWarnTime = (Integer)option.pendingValue();
        }).binding((Object)20, () -> options.timerWarnTime, val -> {
            options.timerWarnTime = val;
        }).controller(option -> ((IntegerSliderControllerBuilder)((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)option).range((Number)0, (Number)60)).step((Number)1)).formatValue(val -> Localization.localized("option", "timer.warn.time.value", val))).build());
        timerCat.option(Option.createBuilder().name((class_2561)Localization.localized("option", "timer.location", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.timerLocation = (Integer)option.pendingValue();
        }).binding((Object)6, () -> options.timerLocation, val -> {
            options.timerLocation = val;
        }).controller(option -> CyclingListControllerBuilder.create((Option)option).values((Object[])Config.locations).formatValue(val -> Localization.localized("option", "location." + val, new Object[0]))).build());
        ConfigCategory.Builder potencyCat = ConfigCategory.createBuilder().name((class_2561)Localization.localized("option", "potency", new Object[0]));
        potencyCat.option(Option.createBuilder().name((class_2561)Localization.localized("option", "potency.enabled", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.potencyEnabled = (Boolean)option.pendingValue();
        }).binding((Object)true, () -> options.potencyEnabled, val -> {
            options.potencyEnabled = val;
        }).controller(option -> BooleanControllerBuilder.create((Option)option).coloured(true)).build());
        potencyCat.option(Option.createBuilder().name((class_2561)Localization.localized("option", "potency.color", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.potencyColor = YaclScreenProvider.fixAlpha(((Color)option.pendingValue()).getRGB());
        }).binding((Object)YaclScreenProvider.fromArgb(-1140850689), () -> YaclScreenProvider.fromArgb(options.potencyColor), val -> {
            options.potencyColor = YaclScreenProvider.fixAlpha(val.getRGB());
        }).controller(option -> ColorControllerBuilder.create((Option)option).allowAlpha(true)).build());
        potencyCat.option(Option.createBuilder().name((class_2561)Localization.localized("option", "potency.shadow.enabled", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.potencyShadow = (Boolean)option.pendingValue();
        }).binding((Object)true, () -> options.potencyShadow, val -> {
            options.potencyShadow = val;
        }).controller(option -> BooleanControllerBuilder.create((Option)option).coloured(true)).build());
        potencyCat.option(Option.createBuilder().name((class_2561)Localization.localized("option", "potency.back.enabled", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.potencyBack = (Boolean)option.pendingValue();
        }).binding((Object)false, () -> options.potencyBack, val -> {
            options.potencyBack = val;
        }).controller(option -> BooleanControllerBuilder.create((Option)option).coloured(true)).build());
        potencyCat.option(Option.createBuilder().name((class_2561)Localization.localized("option", "potency.back.color", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.potencyBackColor = YaclScreenProvider.fixAlpha(((Color)option.pendingValue()).getRGB());
        }).binding((Object)YaclScreenProvider.fromArgb(-1140850689), () -> YaclScreenProvider.fromArgb(options.potencyBackColor), val -> {
            options.potencyBackColor = YaclScreenProvider.fixAlpha(val.getRGB());
        }).controller(option -> ColorControllerBuilder.create((Option)option).allowAlpha(true)).build());
        potencyCat.option(Option.createBuilder().name((class_2561)Localization.localized("option", "potency.location", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.potencyLocation = (Integer)option.pendingValue();
        }).binding((Object)2, () -> options.potencyLocation, val -> {
            options.potencyLocation = val;
        }).controller(option -> CyclingListControllerBuilder.create((Option)option).values((Object[])Config.locations).formatValue(val -> Localization.localized("option", "location." + val, new Object[0]))).build());
        ConfigCategory.Builder scaleCat = ConfigCategory.createBuilder().name((class_2561)Localization.localized("option", "scale", new Object[0]));
        scaleCat.option(Option.createBuilder().name((class_2561)Localization.localized("option", "scale.icon", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.scale = (Double)option.pendingValue();
        }).binding((Object)1.0, () -> options.scale, val -> {
            options.scale = val;
        }).controller(option -> ((DoubleSliderControllerBuilder)DoubleSliderControllerBuilder.create((Option)option).range((Number)0.5, (Number)1.5)).step((Number)0.1)).build());
        scaleCat.option(Option.createBuilder().name((class_2561)Localization.localized("option", "scale.timer", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.timerScale = (Double)option.pendingValue();
        }).binding((Object)0.7f, () -> options.timerScale, val -> {
            options.timerScale = val;
        }).controller(option -> ((DoubleSliderControllerBuilder)DoubleSliderControllerBuilder.create((Option)option).range((Number)0.5, (Number)1.5)).step((Number)0.1)).build());
        scaleCat.option(Option.createBuilder().name((class_2561)Localization.localized("option", "scale.potency", new Object[0])).description(OptionDescription.createBuilder().customImage((ImageRenderer)preview).build()).addListener((option, event) -> {
            preview.potencyScale = (Double)option.pendingValue();
        }).binding((Object)0.7f, () -> options.potencyScale, val -> {
            options.potencyScale = val;
        }).controller(option -> ((DoubleSliderControllerBuilder)DoubleSliderControllerBuilder.create((Option)option).range((Number)0.5, (Number)1.5)).step((Number)0.1)).build());
        builder.category(timerCat.build());
        builder.category(potencyCat.build());
        builder.category(scaleCat.build());
        YetAnotherConfigLib yacl = builder.build();
        return yacl.generateScreen(parent);
    }

    private static Color fromArgb(int i) {
        return new Color(i >> 16 & 0xFF, i >> 8 & 0xFF, i & 0xFF, i >> 24 & 0xFF);
    }

    private static int fixAlpha(int color) {
        if (toAlpha.applyAsInt(color) < 4) {
            return withAlpha.applyAsInt(color, fromAlpha.applyAsInt(4));
        }
        return color;
    }

    private static class Preview
    implements ImageRenderer {
        Config options = Config.get();
        public double scale;
        public double potencyScale;
        public double timerScale;
        public boolean potencyEnabled;
        public boolean timerEnabled;
        public boolean timerEnabledAmbient;
        public boolean timerWarnEnabled;
        public boolean timerFlashEnabled;
        public int timerWarnTime;
        public int potencyColor;
        public boolean potencyShadow;
        public boolean potencyBack;
        public int potencyBackColor;
        public int timerColor;
        public int timerWarnColor;
        public boolean timerShadow;
        public boolean timerBack;
        public int timerBackColor;
        public int potencyLocation;
        public int timerLocation;
        private final class_1293[] DEMO_EFFECTS;

        private Preview() {
            this.scale = this.options.scale;
            this.potencyScale = this.options.potencyScale;
            this.timerScale = this.options.potencyScale;
            this.potencyEnabled = this.options.potencyEnabled;
            this.timerEnabled = this.options.timerEnabled;
            this.timerEnabledAmbient = this.options.timerEnabledAmbient;
            this.timerWarnEnabled = this.options.timerWarnEnabled;
            this.timerFlashEnabled = this.options.timerFlashEnabled;
            this.timerWarnTime = this.options.timerWarnTime;
            this.potencyColor = this.options.potencyColor;
            this.potencyShadow = this.options.potencyShadow;
            this.potencyBack = this.options.potencyBack;
            this.potencyBackColor = this.options.potencyBackColor;
            this.timerColor = this.options.timerColor;
            this.timerWarnColor = this.options.timerWarnColor;
            this.timerShadow = this.options.timerShadow;
            this.timerBack = this.options.timerBack;
            this.timerBackColor = this.options.timerBackColor;
            this.potencyLocation = this.options.potencyLocation;
            this.timerLocation = this.options.timerLocation;
            this.DEMO_EFFECTS = new class_1293[]{new class_1293(class_1294.field_5917, 111, 1, true, true), new class_1293(class_1294.field_5907, 211, 1, false, true), new class_1293(class_1294.field_5904, 411, 2, false, true), new class_1293(class_1294.field_5910, 811, 9, false, true), new class_1293(class_1294.field_5913, 1251, 4, false, true), new class_1293(class_1294.field_5909, 2131, 0, false, true), new class_1293(class_1294.field_5911, 3500, 1, false, true), new class_1293(class_1294.field_5918, 9600, 0, false, true), new class_1293(class_1294.field_5905, 144000, 0, false, true), new class_1293(class_1294.field_5927, -1, 0, false, true)};
        }

        public int render(class_332 graphics, int x, int y, int width, float delta) {
            int space;
            float scale = (float)this.scale;
            graphics.method_51448().pushMatrix();
            graphics.method_51448().translate((float)x * (1.0f - scale), (float)y * (1.0f - scale));
            graphics.method_51448().scale(scale, scale);
            class_310 mc = class_310.method_1551();
            int movingX = x;
            int movingY = y;
            int targetHeight = space = 27;
            int maxX = (int)((float)x + (float)width / scale);
            int spriteSize = 24;
            int iconSize = 18;
            for (class_1293 effect : this.DEMO_EFFECTS) {
                int pY;
                int pX;
                int labelWidth;
                String label;
                if (effect.method_5591()) {
                    graphics.method_52706(class_10799.field_56883, GuiAccessor.etp$getEffectBackgroundAmbientSprite(), movingX, movingY, spriteSize, spriteSize);
                } else {
                    graphics.method_52706(class_10799.field_56883, GuiAccessor.etp$getEffectBackgroundSprite(), movingX, movingY, spriteSize, spriteSize);
                }
                graphics.method_52707(class_10799.field_56883, class_329.method_71644((class_6880)effect.method_5579()), movingX + 3, movingY + 3, iconSize, iconSize, class_9848.method_61317((float)1.0f));
                if (this.potencyEnabled && effect.method_5578() > 0) {
                    label = IndicatorUtil.getAmplifierAsString(effect.method_5578());
                    labelWidth = mc.field_1772.method_1727(label);
                    pX = movingX + IndicatorUtil.getTextOffsetX(this.potencyLocation, labelWidth, spriteSize);
                    Objects.requireNonNull(mc.field_1772);
                    pY = movingY + IndicatorUtil.getTextOffsetY(this.potencyLocation, 9, spriteSize);
                    graphics.method_51448().pushMatrix();
                    graphics.method_51448().translate((float)((double)pX * (1.0 - this.potencyScale)), (float)((double)pY * (1.0 - this.potencyScale)));
                    Matrix3x2fStack matrix3x2fStack = graphics.method_51448();
                    float f = IndicatorUtil.getScaleTranslateX(this.potencyLocation, labelWidth, (float)this.potencyScale);
                    Objects.requireNonNull(mc.field_1772);
                    matrix3x2fStack.translate(f, IndicatorUtil.getScaleTranslateY(this.potencyLocation, 9, (float)this.potencyScale));
                    graphics.method_51448().scale((float)this.potencyScale, (float)this.potencyScale);
                    if (this.potencyBack) {
                        Objects.requireNonNull(mc.field_1772);
                        graphics.method_25294(pX - 1, pY - 1, pX + labelWidth, pY + 9 - 1, this.potencyBackColor);
                    }
                    graphics.method_51433(mc.field_1772, label, pX, pY, this.potencyColor, this.potencyShadow);
                    graphics.method_51448().popMatrix();
                }
                if (this.timerEnabled && (this.timerEnabledAmbient || !effect.method_5591())) {
                    label = IndicatorUtil.getDurationAsString(effect.method_5584());
                    labelWidth = mc.field_1772.method_1727(label);
                    pX = movingX + IndicatorUtil.getTextOffsetX(this.timerLocation, labelWidth, spriteSize);
                    Objects.requireNonNull(mc.field_1772);
                    pY = movingY + IndicatorUtil.getTextOffsetY(this.timerLocation, 9, spriteSize);
                    graphics.method_51448().pushMatrix();
                    graphics.method_51448().translate((float)((double)pX * (1.0 - this.timerScale)), (float)((double)pY * (1.0 - this.timerScale)));
                    Matrix3x2fStack matrix3x2fStack = graphics.method_51448();
                    float f = IndicatorUtil.getScaleTranslateX(this.timerLocation, labelWidth, (float)this.timerScale);
                    Objects.requireNonNull(mc.field_1772);
                    matrix3x2fStack.translate(f, IndicatorUtil.getScaleTranslateY(this.timerLocation, 9, (float)this.timerScale));
                    graphics.method_51448().scale((float)this.timerScale, (float)this.timerScale);
                    if (this.timerBack) {
                        Objects.requireNonNull(mc.field_1772);
                        graphics.method_25294(pX - 1, pY - 1, pX + labelWidth, pY + 9 - 1, this.timerBackColor);
                    }
                    graphics.method_51433(mc.field_1772, label, pX, pY, IndicatorUtil.getTimerColor(effect, this.timerColor, this.timerWarnEnabled, this.timerWarnTime, this.timerWarnColor, this.timerFlashEnabled), this.timerShadow);
                    graphics.method_51448().popMatrix();
                }
                if ((movingX += space) + space <= maxX) continue;
                movingX = x;
                movingY += space;
                targetHeight += space;
            }
            graphics.method_51448().popMatrix();
            return (int)((float)targetHeight * scale);
        }

        public void close() {
        }
    }
}

