/*
 * Decompiled with CFR 0.152.
 */
package igentuman.mbtool.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import igentuman.mbtool.client.render.MultiblockRenderer;
import igentuman.mbtool.container.MultibuilderSelectStructureContainer;
import igentuman.mbtool.util.MultiblockStructure;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class MultiblockButton
extends AbstractButton {
    private MultiblockStructure structure;
    private final OnPress onPress;
    private boolean renderBackground = true;
    private int backgroundColor = -7631989;
    private int hoveredBackgroundColor = -6250336;
    private int pressedBackgroundColor = -10461088;
    private MultibuilderSelectStructureContainer container;
    private boolean hasAllIngredients = false;

    public MultiblockButton(int x, int y, int width, int height, MultiblockStructure structure, OnPress onPress) {
        this(x, y, width, height, structure, onPress, (Component)Component.m_237119_());
    }

    public MultiblockButton(int x, int y, int width, int height, MultiblockStructure structure, OnPress onPress, Component message) {
        super(x, y, width, height, message);
        this.structure = structure;
        this.onPress = onPress;
        this.m_257936_();
    }

    public void setStructure(MultiblockStructure structure) {
        this.structure = structure;
        this.m_257936_();
    }

    private void setContainer(MultibuilderSelectStructureContainer container) {
        this.container = container;
    }

    public MultiblockStructure getStructure() {
        return this.structure;
    }

    public void setRenderBackground(boolean renderBackground) {
        this.renderBackground = renderBackground;
    }

    public void setBackgroundColors(int normal, int hovered, int pressed) {
        this.backgroundColor = normal;
        this.hoveredBackgroundColor = hovered;
        this.pressedBackgroundColor = pressed;
    }

    void m_257936_() {
        this.hasAllIngredients = true;
        if (this.structure != null && this.structure.getName() != null && !this.structure.getName().isEmpty()) {
            MutableComponent tooltip = Component.m_237115_((String)this.structure.getName()).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237110_((String)"gui.mbtool.multiblock_button.dimensions", (Object[])new Object[]{this.structure.getWidth(), this.structure.getHeight(), this.structure.getDepth()}).m_130938_(style -> style.m_178520_(0x808080)));
            ArrayList<MutableComponent> itemsTooltip = new ArrayList<MutableComponent>();
            if (this.container != null) {
                for (ItemStack itemStack : this.structure.getNeededItems()) {
                    boolean hasEnough = this.container.hasEnough(itemStack);
                    if (!hasEnough) {
                        this.hasAllIngredients = false;
                    }
                    ChatFormatting style2 = hasEnough ? ChatFormatting.GREEN : ChatFormatting.RED;
                    itemsTooltip.add(Component.m_237113_((String)(itemStack.m_41613_() + "x " + itemStack.m_41786_().getString())).m_130940_(style2));
                }
            }
            if (!itemsTooltip.isEmpty()) {
                tooltip = tooltip.m_6881_().m_7220_((Component)Component.m_237113_((String)"\n"));
                for (Component component : itemsTooltip) {
                    tooltip = tooltip.m_6881_().m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_(component);
                }
            }
            this.m_257544_(Tooltip.m_257550_((Component)tooltip));
        } else {
            this.m_257544_(null);
        }
    }

    public void m_5691_() {
        this.onPress.onPress(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.f_93624_) {
            return;
        }
        if (this.renderBackground) {
            int bgColor = this.backgroundColor;
            if (!this.f_93623_) {
                bgColor = -10461088;
            } else if (this.m_198029_()) {
                bgColor = this.hoveredBackgroundColor;
            }
            guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, bgColor);
            int borderColor = this.container != null && this.structure != null && !this.structure.getNeededItems().isEmpty() ? (this.hasAllIngredients ? -16711936 : -65536) : (this.m_198029_() ? -1 : -16777216);
            guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + 1, borderColor);
            guiGraphics.m_280509_(this.m_252754_(), this.m_252907_() + this.f_93619_ - 1, this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, borderColor);
            guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + 1, this.m_252907_() + this.f_93619_, borderColor);
            guiGraphics.m_280509_(this.m_252754_() + this.f_93618_ - 1, this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, borderColor);
        }
        if (this.structure != null && !this.structure.getBlocks().isEmpty()) {
            guiGraphics.m_280168_().m_85836_();
            try {
                double guiScale = Minecraft.m_91087_().m_91268_().m_85449_();
                int scaledX = (int)((double)this.m_252754_() * guiScale);
                int scaledY = (int)((double)this.m_252907_() * guiScale);
                int scaledWidth = (int)((double)this.f_93618_ * guiScale);
                int scaledHeight = (int)((double)this.f_93619_ * guiScale);
                int screenHeight = Minecraft.m_91087_().m_91268_().m_85442_();
                scaledY = screenHeight - scaledY - scaledHeight;
                RenderSystem.enableScissor((int)scaledX, (int)scaledY, (int)scaledWidth, (int)scaledHeight);
                int padding = this.renderBackground ? 3 : 1;
                int renderX = this.m_252754_() + padding;
                int renderY = this.m_252907_() + padding;
                int renderWidth = Math.max(1, this.f_93618_ - padding * 2);
                int renderHeight = Math.max(1, this.f_93619_ - padding * 2);
                MultiblockRenderer.render(this.structure, guiGraphics.m_280168_(), renderX, renderY, renderWidth, renderHeight);
            }
            catch (Exception e) {
                System.err.println("Failed to render multiblock structure: " + e.getMessage());
                e.printStackTrace();
            }
            finally {
                RenderSystem.disableScissor();
                guiGraphics.m_280168_().m_85849_();
            }
        } else if (this.renderBackground) {
            int centerX = this.m_252754_() + this.f_93618_ / 2;
            int centerY = this.m_252907_() + this.f_93619_ / 2;
            guiGraphics.m_280653_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"gui.mbtool.no_structure"), centerX, centerY - 4, 0x808080);
        }
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        if (this.structure != null) {
            narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)Component.m_237110_((String)"gui.mbtool.multiblock_button.narration", (Object[])new Object[]{this.structure.getWidth(), this.structure.getHeight(), this.structure.getDepth()}));
        } else {
            narrationElementOutput.m_169146_(NarratedElementType.TITLE, this.m_6035_());
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    @FunctionalInterface
    public static interface OnPress {
        public void onPress(MultiblockButton var1);
    }

    public static class Builder {
        private int x;
        private int y;
        private int width;
        private int height;
        private MultiblockStructure structure;
        private OnPress onPress;
        private Component message = Component.m_237119_();
        private boolean renderBackground = true;
        private int backgroundColor = -7631989;
        private int hoveredBackgroundColor = -6250336;
        private int pressedBackgroundColor = -10461088;
        private MultibuilderSelectStructureContainer container;

        public Builder bounds(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder structure(MultiblockStructure structure) {
            this.structure = structure;
            return this;
        }

        public Builder onPress(OnPress onPress) {
            this.onPress = onPress;
            return this;
        }

        public Builder message(Component message) {
            this.message = message;
            return this;
        }

        public Builder renderBackground(boolean renderBackground) {
            this.renderBackground = renderBackground;
            return this;
        }

        public Builder backgroundColors(int normal, int hovered, int pressed) {
            this.backgroundColor = normal;
            this.hoveredBackgroundColor = hovered;
            this.pressedBackgroundColor = pressed;
            return this;
        }

        public MultiblockButton build() {
            MultiblockButton button = new MultiblockButton(this.x, this.y, this.width, this.height, this.structure, this.onPress, this.message);
            button.setRenderBackground(this.renderBackground);
            button.setBackgroundColors(this.backgroundColor, this.hoveredBackgroundColor, this.pressedBackgroundColor);
            button.setContainer(this.container);
            button.m_257936_();
            return button;
        }

        public Builder container(MultibuilderSelectStructureContainer menu) {
            this.container = menu;
            return this;
        }
    }
}

