/*
 * Decompiled with CFR 0.152.
 */
package igentuman.mbtool.client.gui;

import igentuman.mbtool.client.gui.MultiblockButton;
import igentuman.mbtool.util.MultiblockStructure;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class MultiblockButtonStyles {
    public static final int STANDARD_NORMAL = -7631989;
    public static final int STANDARD_HOVERED = -6250336;
    public static final int STANDARD_PRESSED = -10461088;
    public static final int DARK_NORMAL = -12566464;
    public static final int DARK_HOVERED = -11513776;
    public static final int DARK_PRESSED = -13619152;
    public static final int LIGHT_NORMAL = -2039584;
    public static final int LIGHT_HOVERED = -986896;
    public static final int LIGHT_PRESSED = -3092272;
    public static final int BLUE_NORMAL = -11890462;
    public static final int BLUE_HOVERED = -10772238;
    public static final int BLUE_PRESSED = -12943150;
    public static final int GREEN_NORMAL = -10700708;
    public static final int GREEN_HOVERED = -9648020;
    public static final int GREEN_PRESSED = -11753396;
    public static final int RED_NORMAL = -2534577;
    public static final int RED_HOVERED = -1481889;
    public static final int RED_PRESSED = -3587265;

    public static MultiblockButton createStandard(int x, int y, int width, int height, MultiblockStructure structure, MultiblockButton.OnPress onPress) {
        return MultiblockButton.builder().bounds(x, y, width, height).structure(structure).onPress(onPress).backgroundColors(-7631989, -6250336, -10461088).build();
    }

    public static MultiblockButton createDark(int x, int y, int width, int height, MultiblockStructure structure, MultiblockButton.OnPress onPress) {
        return MultiblockButton.builder().bounds(x, y, width, height).structure(structure).onPress(onPress).backgroundColors(-12566464, -11513776, -13619152).build();
    }

    public static MultiblockButton createLight(int x, int y, int width, int height, MultiblockStructure structure, MultiblockButton.OnPress onPress) {
        return MultiblockButton.builder().bounds(x, y, width, height).structure(structure).onPress(onPress).backgroundColors(-2039584, -986896, -3092272).build();
    }

    public static MultiblockButton createTransparent(int x, int y, int width, int height, MultiblockStructure structure, MultiblockButton.OnPress onPress) {
        return MultiblockButton.builder().bounds(x, y, width, height).structure(structure).onPress(onPress).renderBackground(false).build();
    }

    public static MultiblockButton createBlueAccent(int x, int y, int width, int height, MultiblockStructure structure, MultiblockButton.OnPress onPress) {
        return MultiblockButton.builder().bounds(x, y, width, height).structure(structure).onPress(onPress).backgroundColors(-11890462, -10772238, -12943150).build();
    }

    public static MultiblockButton createGreenAccent(int x, int y, int width, int height, MultiblockStructure structure, MultiblockButton.OnPress onPress) {
        return MultiblockButton.builder().bounds(x, y, width, height).structure(structure).onPress(onPress).backgroundColors(-10700708, -9648020, -11753396).build();
    }

    public static MultiblockButton createRedAccent(int x, int y, int width, int height, MultiblockStructure structure, MultiblockButton.OnPress onPress) {
        return MultiblockButton.builder().bounds(x, y, width, height).structure(structure).onPress(onPress).backgroundColors(-2534577, -1481889, -3587265).build();
    }

    public static MultiblockButton createSmallSquare(int x, int y, MultiblockStructure structure, MultiblockButton.OnPress onPress) {
        return MultiblockButtonStyles.createStandard(x, y, 32, 32, structure, onPress);
    }

    public static MultiblockButton createMediumSquare(int x, int y, MultiblockStructure structure, MultiblockButton.OnPress onPress) {
        return MultiblockButtonStyles.createStandard(x, y, 64, 64, structure, onPress);
    }

    public static MultiblockButton createLargeSquare(int x, int y, MultiblockStructure structure, MultiblockButton.OnPress onPress) {
        return MultiblockButtonStyles.createStandard(x, y, 96, 96, structure, onPress);
    }

    public static MultiblockButton createRectangular(int x, int y, MultiblockStructure structure, MultiblockButton.OnPress onPress) {
        return MultiblockButtonStyles.createStandard(x, y, 120, 60, structure, onPress);
    }

    public static MultiblockButton createWithStructureTooltip(int x, int y, int width, int height, MultiblockStructure structure, MultiblockButton.OnPress onPress, String structureName) {
        MultiblockButton button = MultiblockButtonStyles.createStandard(x, y, width, height, structure, onPress);
        if (structure != null && !structure.getBlocks().isEmpty()) {
            MutableComponent tooltip = Component.m_237110_((String)"gui.mbtool.multiblock_button.structure_info", (Object[])new Object[]{structureName, structure.getWidth(), structure.getHeight(), structure.getDepth(), structure.getBlocks().size()});
            button.m_257544_(Tooltip.m_257550_((Component)tooltip));
        }
        return button;
    }
}

