/*
 * Decompiled with CFR 0.152.
 */
package igentuman.mbtool.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import igentuman.mbtool.util.MultiblockStructure;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Quaternionf;

public class MultiblockRenderer {
    public static MultiblockStructure structure;

    public static Vec3i getSize(MultiblockStructure structure) {
        if (structure == null || structure.getBlocks().isEmpty()) {
            return new Vec3i(1, 1, 1);
        }
        return new Vec3i(structure.getWidth(), structure.getHeight(), structure.getDepth());
    }

    public static void render(MultiblockStructure blocksMap, PoseStack stack, int x, int y, int w, int h) {
        structure = blocksMap;
        MultiblockRenderer.render(stack, x, y, w, h);
    }

    public static void render(PoseStack stack, int x, int y, int w, int h) {
        if (structure == null || structure.getBlocks().isEmpty()) {
            return;
        }
        stack.m_85836_();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        stack.m_252880_((float)x + (float)w / 2.0f, (float)y + (float)h / 2.0f, 100.0f);
        float maxDimension = Math.max(Math.max(structure.getWidth(), structure.getHeight()), structure.getDepth());
        float baseScale = (float)Math.min(w, h) * 0.9f;
        float scale = baseScale / maxDimension;
        stack.m_85841_(scale, -scale, scale);
        stack.m_252781_(new Quaternionf().rotationX((float)Math.toRadians(30.0)));
        stack.m_252781_(new Quaternionf().rotationY((float)Math.toRadians(-45.0)));
        MultiblockRenderer.renderStructure(structure, stack);
        RenderSystem.disableBlend();
        stack.m_85849_();
    }

    private static void renderStructure(MultiblockStructure structure, PoseStack stack) {
        Minecraft minecraft = Minecraft.m_91087_();
        BlockRenderDispatcher blockRenderer = minecraft.m_91289_();
        Map<BlockPos, BlockState> blocks = structure.getBlocks();
        if (blocks.isEmpty()) {
            return;
        }
        int width = structure.getWidth();
        int height = structure.getHeight();
        int depth = structure.getDepth();
        float scale = (float)((double)1.2f / Math.log10(Math.max(Math.max(width, height), depth) + 105));
        stack.m_85841_(scale, scale, scale);
        float centerX = (float)structure.getMinX() + (float)width / 2.0f;
        float centerY = (float)structure.getMinY() + (float)height / 2.0f;
        float centerZ = (float)structure.getMinZ() + (float)depth / 2.0f;
        stack.m_252880_(-centerX, -centerY, -centerZ);
        MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
        for (Map.Entry<BlockPos, BlockState> entry : blocks.entrySet()) {
            BlockPos pos = entry.getKey();
            BlockState state = entry.getValue();
            stack.m_85836_();
            stack.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
            try {
                ModelData modelData = ModelData.EMPTY;
                try {
                    BakedModel model = blockRenderer.m_110910_(state);
                    modelData = model.getModelData((BlockAndTintGetter)minecraft.f_91073_, pos, state, ModelData.EMPTY);
                }
                catch (Exception e) {
                    modelData = ModelData.EMPTY;
                }
                blockRenderer.renderSingleBlock(state, stack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, modelData, null);
            }
            catch (Exception e) {
                System.err.print(e.getMessage());
            }
            stack.m_85849_();
        }
        bufferSource.m_109911_();
    }
}

