/*
 * Decompiled with CFR 0.152.
 */
package igentuman.mbtool.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import igentuman.mbtool.Mbtool;
import igentuman.mbtool.client.handler.ClientHandler;
import igentuman.mbtool.item.MultibuilderItem;
import igentuman.mbtool.util.MultiblockStructure;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class PreviewRenderer {
    private static float interpolatedAlpha = 0.5f;
    private static MultiblockStructure structure = null;
    private static final Minecraft mc = Minecraft.m_91087_();
    private static int height;
    private static int length;
    private static int width;
    private static int rotation;
    private static BlockPos hit;
    private static float dir;

    public static BlockPos getRayTraceHit() {
        boolean off;
        Vec3 lookVec;
        Vec3 endPos;
        LocalPlayer player = PreviewRenderer.mc.f_91074_;
        ClientLevel world = PreviewRenderer.mc.f_91073_;
        if (player == null || world == null) {
            return null;
        }
        Vec3 eyePos = player.m_20299_(1.0f);
        BlockHitResult rayTrace = world.m_45547_(new ClipContext(eyePos, endPos = eyePos.m_82549_((lookVec = player.m_20252_(1.0f)).m_82490_(20.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        if (rayTrace.m_6662_() != HitResult.Type.BLOCK) {
            return null;
        }
        ItemStack mainItem = player.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack offItem = player.m_21120_(InteractionHand.OFF_HAND);
        boolean main = !mainItem.m_41619_() && mainItem.m_150930_((Item)Mbtool.MBTOOL.get()) && ClientHandler.hasStructure(mainItem);
        boolean bl = off = !offItem.m_41619_() && offItem.m_150930_((Item)Mbtool.MBTOOL.get()) && ClientHandler.hasStructure(offItem);
        if (!main && !off) {
            return null;
        }
        hit = rayTrace.m_82425_();
        BlockState state = world.m_8055_(hit);
        ItemStack multibuilderStack = main ? mainItem : offItem;
        structure = ((MultibuilderItem)multibuilderStack.m_41720_()).getCurrentStructure(multibuilderStack);
        if (structure == null) {
            return null;
        }
        rotation = multibuilderStack.m_41784_().m_128451_("rotation");
        Direction hitSide = rayTrace.m_82434_();
        int maxSize = Math.max(structure.getWidth(), structure.getDepth()) - 1;
        switch (hitSide) {
            case DOWN: {
                hit = hit.m_7918_(0, -structure.getHeight(), 0);
                break;
            }
            case UP: {
                if (state.m_247087_()) break;
                hit = hit.m_7918_(0, 1, 0);
                break;
            }
            case EAST: {
                hit = hit.m_7918_(maxSize, 0, 0);
                break;
            }
            case WEST: {
                hit = hit.m_7918_(-maxSize, 0, 0);
                break;
            }
            case NORTH: {
                hit = hit.m_7918_(0, 0, -maxSize);
                break;
            }
            case SOUTH: {
                hit = hit.m_7918_(0, 0, maxSize);
            }
        }
        hit = rotation == 0 || rotation == 2 ? hit.m_7918_(-structure.getWidth() / 2, 0, -structure.getDepth() / 2) : hit.m_7918_(-structure.getDepth() / 2, 0, -structure.getWidth() / 2);
        return hit;
    }

    public static boolean renderPreview(PoseStack poseStack, float partialTicks) {
        BlockPos hitPos = PreviewRenderer.getRayTraceHit();
        if (hitPos == null || structure == null) {
            return false;
        }
        poseStack.m_85836_();
        height = structure.getHeight();
        length = structure.getDepth();
        width = structure.getWidth();
        Vec3 cameraPos = PreviewRenderer.mc.f_91063_.m_109153_().m_90583_();
        poseStack.m_85837_((double)hitPos.m_123341_() - cameraPos.f_82479_, (double)hitPos.m_123342_() - cameraPos.f_82480_, (double)hitPos.m_123343_() - cameraPos.f_82481_);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        PreviewRenderer.renderPreviewBlocks(poseStack, partialTicks);
        PreviewRenderer.renderBoundaries(poseStack);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        poseStack.m_85849_();
        return true;
    }

    private static void renderBoundaries(PoseStack poseStack) {
        ClientLevel world = PreviewRenderer.mc.f_91073_;
        if (world == null) {
            return;
        }
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        RenderSystem.defaultBlendFunc();
        RenderSystem.lineWidth((float)2.0f);
        buffer.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        int bWidth = length;
        int bLength = width;
        for (int h = 0; h < height; ++h) {
            for (int l = 0; l < bLength; ++l) {
                for (int w = 0; w < bWidth; ++w) {
                    int xo = l;
                    int zo = w;
                    switch (rotation) {
                        case 1: {
                            zo = l;
                            xo = bWidth - w - 1;
                            break;
                        }
                        case 2: {
                            xo = bLength - l - 1;
                            zo = bWidth - w - 1;
                            break;
                        }
                        case 3: {
                            zo = bLength - l - 1;
                            xo = w;
                        }
                    }
                    BlockPos actualPos = hit.m_7918_(xo, h, zo);
                    boolean isEmpty = world.m_8055_(actualPos).m_247087_();
                    if (isEmpty && (w != 0 && w != bWidth - 1 || l != 0 && l != bLength - 1 || h != 0 && h != height - 1)) continue;
                    float r = isEmpty ? 0.0f : 1.0f;
                    float g = isEmpty ? 1.0f : 0.0f;
                    float b = 0.0f;
                    float alpha = 0.4f;
                    float x = (float)xo + 0.5f;
                    float y = (float)h + 0.5f;
                    float z = (float)zo + 0.5f;
                    if (!isEmpty || h == height - 1) {
                        buffer.m_252986_(matrix, x - 0.5f, y + 0.5f, z - 0.5f).m_85950_(r, g, b, alpha).m_5752_();
                        buffer.m_252986_(matrix, x + 0.5f, y + 0.5f, z - 0.5f).m_85950_(r, g, b, alpha).m_5752_();
                        buffer.m_252986_(matrix, x + 0.5f, y + 0.5f, z - 0.5f).m_85950_(r, g, b, alpha).m_5752_();
                        buffer.m_252986_(matrix, x + 0.5f, y + 0.5f, z + 0.5f).m_85950_(r, g, b, alpha).m_5752_();
                        buffer.m_252986_(matrix, x + 0.5f, y + 0.5f, z + 0.5f).m_85950_(r, g, b, alpha).m_5752_();
                        buffer.m_252986_(matrix, x - 0.5f, y + 0.5f, z + 0.5f).m_85950_(r, g, b, alpha).m_5752_();
                        buffer.m_252986_(matrix, x - 0.5f, y + 0.5f, z + 0.5f).m_85950_(r, g, b, alpha).m_5752_();
                        buffer.m_252986_(matrix, x - 0.5f, y + 0.5f, z - 0.5f).m_85950_(r, g, b, alpha).m_5752_();
                    }
                    if (!isEmpty) {
                        buffer.m_252986_(matrix, x - 0.5f, y + 0.5f, z - 0.5f).m_85950_(r, g, b, alpha).m_5752_();
                        buffer.m_252986_(matrix, x - 0.5f, y - 0.5f, z - 0.5f).m_85950_(r, g, b, alpha).m_5752_();
                        buffer.m_252986_(matrix, x + 0.5f, y + 0.5f, z - 0.5f).m_85950_(r, g, b, alpha).m_5752_();
                        buffer.m_252986_(matrix, x + 0.5f, y - 0.5f, z - 0.5f).m_85950_(r, g, b, alpha).m_5752_();
                        buffer.m_252986_(matrix, x - 0.5f, y + 0.5f, z + 0.5f).m_85950_(r, g, b, alpha).m_5752_();
                        buffer.m_252986_(matrix, x - 0.5f, y - 0.5f, z + 0.5f).m_85950_(r, g, b, alpha).m_5752_();
                        buffer.m_252986_(matrix, x + 0.5f, y + 0.5f, z + 0.5f).m_85950_(r, g, b, alpha).m_5752_();
                        buffer.m_252986_(matrix, x + 0.5f, y - 0.5f, z + 0.5f).m_85950_(r, g, b, alpha).m_5752_();
                    }
                    if (isEmpty && h != 0) continue;
                    buffer.m_252986_(matrix, x - 0.5f, y - 0.5f, z - 0.5f).m_85950_(r, g, b, alpha).m_5752_();
                    buffer.m_252986_(matrix, x + 0.5f, y - 0.5f, z - 0.5f).m_85950_(r, g, b, alpha).m_5752_();
                    buffer.m_252986_(matrix, x + 0.5f, y - 0.5f, z - 0.5f).m_85950_(r, g, b, alpha).m_5752_();
                    buffer.m_252986_(matrix, x + 0.5f, y - 0.5f, z + 0.5f).m_85950_(r, g, b, alpha).m_5752_();
                    buffer.m_252986_(matrix, x + 0.5f, y - 0.5f, z + 0.5f).m_85950_(r, g, b, alpha).m_5752_();
                    buffer.m_252986_(matrix, x - 0.5f, y - 0.5f, z + 0.5f).m_85950_(r, g, b, alpha).m_5752_();
                    buffer.m_252986_(matrix, x - 0.5f, y - 0.5f, z + 0.5f).m_85950_(r, g, b, alpha).m_5752_();
                    buffer.m_252986_(matrix, x - 0.5f, y - 0.5f, z - 0.5f).m_85950_(r, g, b, alpha).m_5752_();
                }
            }
        }
        tessellator.m_85914_();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
    }

    private static void renderPreviewBlocks(PoseStack poseStack, float partialTicks) {
        ClientLevel world = PreviewRenderer.mc.f_91073_;
        if (world == null || structure == null) {
            return;
        }
        BlockRenderDispatcher blockRenderer = mc.m_91289_();
        if ((interpolatedAlpha += partialTicks * dir) >= 0.8f) {
            dir = -0.005f;
        }
        if (interpolatedAlpha <= 0.5f) {
            dir = 0.005f;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
        Map<BlockPos, BlockState> blocks = structure.getBlocks();
        for (Map.Entry<BlockPos, BlockState> entry : blocks.entrySet()) {
            BlockPos worldPos;
            BlockPos structurePos = entry.getKey();
            BlockState blockState = entry.getValue();
            if (blockState.m_60795_()) continue;
            int xo = structurePos.m_123341_() - structure.getMinX();
            int yo = structurePos.m_123342_() - structure.getMinY();
            int zo = structurePos.m_123343_() - structure.getMinZ();
            int rotatedX = xo;
            int rotatedZ = zo;
            switch (rotation) {
                case 1: {
                    rotatedZ = xo;
                    rotatedX = structure.getDepth() - zo - 1;
                    break;
                }
                case 2: {
                    rotatedX = structure.getWidth() - xo - 1;
                    rotatedZ = structure.getDepth() - zo - 1;
                    break;
                }
                case 3: {
                    rotatedZ = structure.getWidth() - xo - 1;
                    rotatedX = zo;
                }
            }
            if (!world.m_8055_(worldPos = hit.m_7918_(rotatedX, yo, rotatedZ)).m_247087_()) continue;
            poseStack.m_85836_();
            poseStack.m_252880_((float)rotatedX, (float)yo, (float)rotatedZ);
            BlockState rotatedBlockState = PreviewRenderer.rotateBlockState(blockState, rotation);
            try {
                PreviewRenderer.renderTranslucentBlock(rotatedBlockState, poseStack, (MultiBufferSource)bufferSource, interpolatedAlpha);
            }
            catch (Exception e) {
                PreviewRenderer.renderSimpleCube(poseStack, (MultiBufferSource)bufferSource);
            }
            poseStack.m_85849_();
        }
        bufferSource.m_109911_();
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
    }

    private static void renderTranslucentBlock(BlockState blockState, PoseStack poseStack, MultiBufferSource bufferSource, float alpha) {
        BlockRenderDispatcher blockRenderer = mc.m_91289_();
        BakedModel model = blockRenderer.m_110910_(blockState);
        RandomSource random = RandomSource.m_216335_((long)42L);
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110466_());
        for (Direction direction : Direction.values()) {
            List quads = model.m_213637_(blockState, direction, random);
            PreviewRenderer.renderQuadsWithAlpha(poseStack, buffer, quads, alpha, 0xF000F0, OverlayTexture.f_118083_);
        }
        List generalQuads = model.m_213637_(blockState, null, random);
        PreviewRenderer.renderQuadsWithAlpha(poseStack, buffer, generalQuads, alpha, 0xF000F0, OverlayTexture.f_118083_);
    }

    private static void renderQuadsWithAlpha(PoseStack poseStack, VertexConsumer buffer, List<BakedQuad> quads, float alpha, int light, int overlay) {
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        for (BakedQuad quad : quads) {
            int[] vertices = quad.m_111303_();
            Vec3 quadNormal = new Vec3((double)quad.m_111306_().m_122436_().m_123341_(), (double)quad.m_111306_().m_122436_().m_123342_(), (double)quad.m_111306_().m_122436_().m_123343_());
            for (int i = 0; i < 4; ++i) {
                int vertexIndex = i * 8;
                float x = Float.intBitsToFloat(vertices[vertexIndex]);
                float y = Float.intBitsToFloat(vertices[vertexIndex + 1]);
                float z = Float.intBitsToFloat(vertices[vertexIndex + 2]);
                int color = vertices[vertexIndex + 3];
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                float u = Float.intBitsToFloat(vertices[vertexIndex + 4]);
                float v = Float.intBitsToFloat(vertices[vertexIndex + 5]);
                buffer.m_252986_(pose, x, y, z).m_85950_(r, g, b, alpha).m_7421_(u, v).m_86008_(overlay).m_85969_(light).m_252939_(normal, (float)quadNormal.f_82479_, (float)quadNormal.f_82480_, (float)quadNormal.f_82481_).m_5752_();
            }
        }
    }

    private static BlockState rotateBlockState(BlockState blockState, int rotation) {
        if (rotation == 0) {
            return blockState;
        }
        BlockState rotatedState = blockState;
        boolean hasDirectionalProperty = false;
        for (Property property : blockState.m_61147_()) {
            if (!(property instanceof DirectionProperty)) continue;
            hasDirectionalProperty = true;
            DirectionProperty dirProperty = (DirectionProperty)property;
            Direction currentDirection = (Direction)blockState.m_61143_((Property)dirProperty);
            Direction rotatedDirection = PreviewRenderer.rotateDirection(currentDirection, rotation, dirProperty);
            if (!dirProperty.m_6908_().contains(rotatedDirection)) continue;
            rotatedState = (BlockState)rotatedState.m_61124_((Property)dirProperty, (Comparable)rotatedDirection);
        }
        return rotatedState;
    }

    private static Direction rotateDirection(Direction direction, int rotation, DirectionProperty property) {
        rotation = (rotation % 4 + 4) % 4;
        boolean isHorizontalOnly = property.m_6908_().stream().allMatch(dir -> dir.m_122434_() != Direction.Axis.Y);
        if (isHorizontalOnly && (direction == Direction.UP || direction == Direction.DOWN)) {
            return direction;
        }
        Direction result = direction;
        for (int i = 0; i < rotation; ++i) {
            result = PreviewRenderer.rotateDirectionClockwise(result, isHorizontalOnly);
        }
        return result;
    }

    private static Direction rotateDirectionClockwise(Direction direction, boolean horizontalOnly) {
        switch (direction) {
            case NORTH: {
                return Direction.EAST;
            }
            case EAST: {
                return Direction.SOUTH;
            }
            case SOUTH: {
                return Direction.WEST;
            }
            case WEST: {
                return Direction.NORTH;
            }
            case UP: {
                return horizontalOnly ? Direction.UP : Direction.UP;
            }
            case DOWN: {
                return horizontalOnly ? Direction.DOWN : Direction.DOWN;
            }
        }
        return direction;
    }

    private static void renderSimpleCube(PoseStack poseStack, MultiBufferSource bufferSource) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float alpha = interpolatedAlpha;
        float r = 0.8f;
        float g = 0.8f;
        float b = 0.8f;
        buffer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 1.0f, 0.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 1.0f, 0.0f, 1.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 0.0f, 1.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 1.0f, 1.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 1.0f, 1.0f, 1.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 1.0f, 1.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 1.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 1.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 1.0f, 1.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 1.0f, 0.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 1.0f, 0.0f, 1.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 1.0f, 1.0f, 1.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 1.0f, 1.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 0.0f, 1.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 0.0f, 1.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 1.0f, 1.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 1.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 1.0f, 0.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 1.0f, 1.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 1.0f, 1.0f, 1.0f).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, 1.0f, 0.0f, 1.0f).m_85950_(r, g, b, alpha).m_5752_();
        tessellator.m_85914_();
    }

    static {
        rotation = 0;
        dir = 0.005f;
    }
}

