/*
 * Decompiled with CFR 0.152.
 */
package igentuman.mbtool.client.screen;

import igentuman.mbtool.Mbtool;
import igentuman.mbtool.client.render.MultiblockRenderer;
import igentuman.mbtool.client.screen.MultibuilderSelectStructureScreen;
import igentuman.mbtool.container.MultibuilderContainer;
import igentuman.mbtool.container.MultibuilderSelectStructureContainer;
import igentuman.mbtool.integration.nc.ReactorDesignParser;
import igentuman.mbtool.item.MultibuilderItem;
import igentuman.mbtool.util.ModUtil;
import igentuman.mbtool.util.MultiblockStructure;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class MultibuilderScreen
extends AbstractContainerScreen<MultibuilderContainer> {
    private static final ResourceLocation TEXTURE = Mbtool.rl("textures/gui/container/mbtool_inventory.png");
    private static final ResourceLocation PASTE_ICON = Mbtool.rl("textures/gui/paste.png");
    private Button chooseButton;
    private ImageButton pasteButton;
    public int selectedStructure = -1;

    public MultibuilderScreen(MultibuilderContainer pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 216;
        this.f_97727_ = 206;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.loadSelectedStructure();
        int x = this.f_97735_ + 150;
        int y = this.f_97736_ + 67;
        int buttonWidth = 57;
        int buttonHeight = 17;
        this.chooseButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.mbtool.choose"), this::onChooseButtonClick).m_252987_(x, y, buttonWidth, buttonHeight).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.mbtool.select_structure"))).m_253136_();
        this.m_142416_((GuiEventListener)this.chooseButton);
        int pasteX = this.f_97735_ + 170 + (buttonWidth - 18) / 2;
        int pasteY = this.f_97736_ + 67 + buttonHeight + 2;
        this.pasteButton = new ImageButton(pasteX, pasteY, 18, 18, 0, 0, 18, PASTE_ICON, 18, 36, this::onPasteButtonClick);
        this.pasteButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.mbtool.paste_reactor_tooltip")));
        if (!ModUtil.isNCNLoaded()) {
            this.pasteButton.f_93624_ = false;
        }
        this.m_142416_((GuiEventListener)this.pasteButton);
    }

    private void loadSelectedStructure() {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            LocalPlayer player = this.f_96541_.f_91074_;
            ItemStack multibuilderStack = player.m_150109_().m_8020_(player.m_150109_().f_35977_);
            this.selectedStructure = -1;
            Item item = multibuilderStack.m_41720_();
            if (item instanceof MultibuilderItem) {
                MultibuilderItem multibuilderItem = (MultibuilderItem)item;
                this.selectedStructure = multibuilderItem.getSelectedStructureId(multibuilderStack);
            }
        }
    }

    private void onChooseButtonClick(Button button) {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            LocalPlayer player = this.f_96541_.f_91074_;
            int slot = player.m_150109_().f_35977_;
            MultibuilderSelectStructureContainer container = new MultibuilderSelectStructureContainer(0, player.m_20183_(), player.m_150109_(), slot);
            MultibuilderSelectStructureScreen newScreen = new MultibuilderSelectStructureScreen(container, player.m_150109_(), (Component)Component.m_237115_((String)"gui.mbtool.select_structure"), (Screen)this);
            this.f_96541_.m_91152_((Screen)newScreen);
        }
    }

    private void onPasteButtonClick(Button button) {
        block29: {
            String jsonText = Minecraft.m_91087_().f_91068_.m_90876_();
            if (jsonText == null || jsonText.trim().isEmpty()) {
                if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                    this.f_96541_.f_91074_.m_213846_((Component)Component.m_237115_((String)"message.mbtool.clipboard_empty"));
                }
                return;
            }
            try {
                String input = jsonText.trim();
                String inputType = "JSON";
                if (input.startsWith("http://") || input.startsWith("https://")) {
                    inputType = "URL";
                } else if (input.startsWith("file://") || !input.startsWith("{") && (input.contains("/") || input.contains("\\") || input.endsWith(".json"))) {
                    inputType = "file";
                }
                MultiblockStructure structure = ReactorDesignParser.parseNuclearCraftReactorDesign(input);
                if (structure != null) {
                    if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                        LocalPlayer player = this.f_96541_.f_91074_;
                        ItemStack multibuilderStack = player.m_150109_().m_8020_(player.m_150109_().f_35977_);
                        Item item = multibuilderStack.m_41720_();
                        if (item instanceof MultibuilderItem) {
                            MultibuilderItem multibuilderItem = (MultibuilderItem)item;
                            multibuilderItem.setRuntimeStructure(multibuilderStack, structure);
                            String messageKey = switch (inputType) {
                                case "URL" -> "message.mbtool.reactor_loaded_url";
                                case "file" -> "message.mbtool.reactor_loaded_file";
                                default -> "message.mbtool.reactor_loaded_json";
                            };
                            player.m_213846_((Component)Component.m_237115_((String)messageKey));
                        } else {
                            player.m_213846_((Component)Component.m_237115_((String)"message.mbtool.no_multibuilder_item"));
                        }
                    }
                } else if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                    String messageKey = switch (inputType) {
                        case "URL" -> "message.mbtool.reactor_parse_failed_url";
                        case "file" -> "message.mbtool.reactor_parse_failed_file";
                        default -> "message.mbtool.reactor_parse_failed_json";
                    };
                    this.f_96541_.f_91074_.m_213846_((Component)Component.m_237115_((String)messageKey));
                }
            }
            catch (Exception e) {
                if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) break block29;
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237110_((String)"message.mbtool.clipboard_parse_error", (Object[])new Object[]{e.getMessage()}));
            }
        }
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        pGuiGraphics.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
        ItemStack multibuilderStack = Minecraft.m_91087_().f_91074_.m_150109_().m_8020_(Minecraft.m_91087_().f_91074_.m_150109_().f_35977_);
        if (!multibuilderStack.m_150930_((Item)Mbtool.MBTOOL.get())) {
            return;
        }
        MultibuilderItem multibuilderItem = (MultibuilderItem)multibuilderStack.m_41720_();
        MultiblockStructure structure = multibuilderItem.getCurrentStructure(multibuilderStack);
        if (structure == null) {
            return;
        }
        MultiblockRenderer.render(structure, pGuiGraphics.m_280168_(), x + 148, y + 9, 60, 60);
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(pGuiGraphics);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.m_280072_(pGuiGraphics, pMouseX, pMouseY);
    }

    protected void m_280003_(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97730_, 3, 0x404040, false);
    }
}

