/*
 * Decompiled with CFR 0.152.
 */
package igentuman.mbtool.container;

import igentuman.mbtool.Mbtool;
import igentuman.mbtool.container.CustomSlotHandler;
import igentuman.mbtool.item.MultibuilderItem;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class MultibuilderContainer
extends AbstractContainerMenu {
    private static final int INVENTORY_SIZE = 40;
    private final IItemHandler itemHandler;
    private final int playerSlot;
    private final UUID uuid;

    public MultibuilderContainer(@Nullable MenuType<?> pMenuType, int pContainerId) {
        super(pMenuType, pContainerId);
        this.itemHandler = null;
        this.playerSlot = -1;
        this.uuid = UUID.randomUUID();
    }

    public MultibuilderContainer(int pContainerId, BlockPos pos, Inventory pPlayerInventory, int slot) {
        super((MenuType)Mbtool.MULTIBUILDER_CONTAINER.get(), pContainerId);
        this.playerSlot = slot;
        ItemStack multibuilderStack = slot == 40 ? (ItemStack)pPlayerInventory.f_35976_.get(0) : (ItemStack)pPlayerInventory.f_35974_.get(slot);
        Item item = multibuilderStack.m_41720_();
        if (item instanceof MultibuilderItem) {
            MultibuilderItem multibuilderItem = (MultibuilderItem)item;
            this.itemHandler = multibuilderItem.getInventory(multibuilderStack);
            this.uuid = multibuilderItem.getUUID(multibuilderStack);
        } else {
            this.itemHandler = null;
            this.uuid = UUID.randomUUID();
        }
        if (this.itemHandler != null) {
            this.addMultibuilderInventory();
        }
        this.addPlayerInventory(pPlayerInventory);
        this.addPlayerHotbar(pPlayerInventory);
    }

    private void addMultibuilderInventory() {
        for (int row = 0; row < 5; ++row) {
            for (int col = 0; col < 8; ++col) {
                int index = row * 8 + col;
                this.m_38897_((Slot)new CustomSlotHandler(this.itemHandler, index, 5 + col * 18, 13 + row * 18));
            }
        }
    }

    private void addPlayerInventory(Inventory playerInventory) {
        int yOffset = 107;
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 5 + l * 18, yOffset + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        int yOffset = 165;
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 5 + i * 18, yOffset));
        }
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            if (pPlayer.m_21120_(InteractionHand.MAIN_HAND).equals(itemstack1)) {
                return ItemStack.f_41583_;
            }
            itemstack = itemstack1.m_41777_();
            if (pIndex < 40 ? !this.m_38903_(itemstack1, 40, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, 40, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(pPlayer, itemstack1);
        }
        return itemstack;
    }

    protected boolean m_38903_(ItemStack pStack, int pStartIndex, int pEndIndex, boolean pReverseDirection) {
        boolean flag = false;
        int i = pStartIndex;
        if (pReverseDirection) {
            i = pEndIndex - 1;
        }
        if (pStack.m_41753_()) {
            while (!pStack.m_41619_() && !(!pReverseDirection ? i >= pEndIndex : i < pStartIndex)) {
                Slot slot = (Slot)this.f_38839_.get(i);
                ItemStack itemstack = slot.m_7993_();
                if (!itemstack.m_41619_() && ItemStack.m_150942_((ItemStack)pStack, (ItemStack)itemstack)) {
                    int maxSize;
                    int j = itemstack.m_41613_() + pStack.m_41613_();
                    if (j <= (maxSize = slot.m_6641_())) {
                        pStack.m_41764_(0);
                        itemstack.m_41764_(j);
                        slot.m_6654_();
                        flag = true;
                    } else if (itemstack.m_41613_() < maxSize) {
                        pStack.m_41774_(maxSize - itemstack.m_41613_());
                        itemstack.m_41764_(maxSize);
                        slot.m_6654_();
                        flag = true;
                    }
                }
                if (pReverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!pStack.m_41619_()) {
            i = pReverseDirection ? pEndIndex - 1 : pStartIndex;
            while (!(!pReverseDirection ? i >= pEndIndex : i < pStartIndex)) {
                Slot slot1 = (Slot)this.f_38839_.get(i);
                ItemStack itemstack1 = slot1.m_7993_();
                if (itemstack1.m_41619_() && slot1.m_5857_(pStack)) {
                    if (pStack.m_41613_() > slot1.m_6641_()) {
                        slot1.m_269060_(pStack.m_41620_(slot1.m_6641_()));
                    } else {
                        slot1.m_269060_(pStack.m_41620_(pStack.m_41613_()));
                    }
                    slot1.m_6654_();
                    flag = true;
                    break;
                }
                if (pReverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public boolean m_6875_(Player pPlayer) {
        ItemStack stack = pPlayer.m_21120_(InteractionHand.MAIN_HAND);
        Item item = stack.m_41720_();
        if (item instanceof MultibuilderItem) {
            MultibuilderItem multibuilderItem = (MultibuilderItem)item;
            return multibuilderItem.getUUID(stack).equals(this.uuid);
        }
        return false;
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }
}

