/*
 * Decompiled with CFR 0.152.
 */
package igentuman.mbtool.item;

import igentuman.mbtool.Mbtool;
import igentuman.mbtool.config.MbtoolConfig;
import igentuman.mbtool.container.MultibuilderContainer;
import igentuman.mbtool.network.NetworkHandler;
import igentuman.mbtool.network.SyncMultibuilderParamsPacket;
import igentuman.mbtool.network.SyncRuntimeStructurePacket;
import igentuman.mbtool.util.CapabilityUtils;
import igentuman.mbtool.util.CustomEnergyStorage;
import igentuman.mbtool.util.GTUtils;
import igentuman.mbtool.util.ItemCapabilityProvider;
import igentuman.mbtool.util.ItemInventoryHandler;
import igentuman.mbtool.util.ModUtil;
import igentuman.mbtool.util.MultiblockStructure;
import igentuman.mbtool.util.MultiblocksProvider;
import igentuman.mbtool.util.TextUtils;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;

public class MultibuilderItem
extends Item {
    public static final int INVENTORY_SIZE = 40;
    private static final int STACK_SIZE = 512;
    public int delay = 0;

    public MultibuilderItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        int slot;
        ItemStack itemStack = player.m_21120_(hand);
        int n = slot = hand == InteractionHand.MAIN_HAND ? player.m_150109_().f_35977_ : 40;
        if (player.m_20161_()) {
            if (!level.f_46443_) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                    public Component m_5446_() {
                        return Component.m_237115_((String)"gui.mbtool.multibuilder");
                    }

                    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
                        return new MultibuilderContainer(containerId, player.m_20183_(), playerInventory, slot);
                    }
                }, buf -> {
                    buf.m_130064_(player.m_20183_());
                    buf.writeInt(slot);
                });
            }
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        if (this.delay > 0) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        this.delay = 40;
        if (level.f_46443_) {
            int rotation = this.getRotation(itemStack);
            MultiblockStructure runtimeStructure = this.getRuntimeStructure(itemStack);
            if (runtimeStructure != null) {
                NetworkHandler.INSTANCE.sendToServer((Object)new SyncRuntimeStructurePacket(runtimeStructure.getStructureNbt(), rotation, hand));
                if (itemStack.m_41784_().m_128451_("recipe") > 0) {
                    this.setRuntimeStructure(itemStack, null);
                }
                return InteractionResultHolder.m_19090_((Object)itemStack);
            }
            if (this.hasRecipe(itemStack)) {
                int recipeIndex = itemStack.m_41784_().m_128451_("recipe");
                if (MultiblocksProvider.structures.isEmpty()) {
                    MultiblocksProvider.getStructures();
                }
                if (recipeIndex >= 0 && recipeIndex < MultiblocksProvider.structures.size()) {
                    this.setRuntimeStructure(itemStack, null);
                    NetworkHandler.INSTANCE.sendToServer((Object)new SyncMultibuilderParamsPacket(recipeIndex, rotation, hand));
                    return InteractionResultHolder.m_19090_((Object)itemStack);
                }
                player.m_213846_((Component)Component.m_237115_((String)"message.mbtool.invalid_recipe"));
                return InteractionResultHolder.m_19100_((Object)itemStack);
            }
            player.m_213846_((Component)Component.m_237115_((String)"message.mbtool.no_recipe"));
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        return InteractionResultHolder.m_19098_((Object)itemStack);
    }

    public boolean isRepairable(@Nonnull ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, Entity entity) {
        return false;
    }

    public int m_142159_(ItemStack pStack) {
        return Mth.m_14169_((float)(Math.max(0.0f, (float)this.m_142158_(pStack) / 13.0f) / 3.0f), (float)1.0f, (float)1.0f);
    }

    protected int getEnergyMaxStorage() {
        return MbtoolConfig.getMaxEnergy();
    }

    protected int getEnergyTransferRate() {
        return MbtoolConfig.getEnergyTransferRate();
    }

    public static int getInventorySize() {
        return 40;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new ItemCapabilityProvider(stack, this.getEnergyMaxStorage(), this.getEnergyTransferRate(), MultibuilderItem.getInventorySize(), 512);
    }

    public CustomEnergyStorage getEnergy(ItemStack stack) {
        return (CustomEnergyStorage)((Object)CapabilityUtils.getPresentCapability((ICapabilityProvider)stack, ForgeCapabilities.ENERGY));
    }

    public IItemHandler getInventory(ItemStack stack) {
        return (IItemHandler)CapabilityUtils.getPresentCapability((ICapabilityProvider)stack, ForgeCapabilities.ITEM_HANDLER);
    }

    public ItemInventoryHandler getInventoryHandler(ItemStack stack) {
        IItemHandler handler = this.getInventory(stack);
        if (handler instanceof ItemInventoryHandler) {
            return (ItemInventoryHandler)handler;
        }
        return null;
    }

    public int m_142158_(ItemStack stack) {
        CustomEnergyStorage energyStorage = this.getEnergy(stack);
        if (energyStorage == null) {
            return 0;
        }
        float chargeRatio = (float)energyStorage.getEnergyStored() / (float)this.getEnergyMaxStorage();
        return (int)Math.min(13.0f, 13.0f * chargeRatio);
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        IItemHandler inventory;
        CustomEnergyStorage energyStorage = this.getEnergy(stack);
        if (energyStorage != null) {
            if (ModUtil.isGtLoaded()) {
                list.add((Component)TextUtils.__("tooltip.mbtool.energy_stored", GTUtils.formatEUEnergy(energyStorage.getEnergyStored()), GTUtils.formatEUEnergy(this.getEnergyMaxStorage())).m_130940_(ChatFormatting.BLUE));
            } else {
                list.add((Component)TextUtils.__("tooltip.mbtool.energy_stored", TextUtils.formatEnergy(energyStorage.getEnergyStored()), TextUtils.formatEnergy(this.getEnergyMaxStorage())).m_130940_(ChatFormatting.BLUE));
            }
        }
        if ((inventory = this.getInventory(stack)) != null) {
            int usedSlots = 0;
            for (int i = 0; i < inventory.getSlots(); ++i) {
                if (inventory.getStackInSlot(i).m_41619_()) continue;
                ++usedSlots;
            }
            list.add((Component)Component.m_237110_((String)"tooltip.mbtool.inventory_slots", (Object[])new Object[]{usedSlots, MultibuilderItem.getInventorySize()}).m_130940_(ChatFormatting.GRAY));
        }
    }

    public boolean hasEnergy(ItemStack stack, int amount) {
        CustomEnergyStorage energyStorage = this.getEnergy(stack);
        return energyStorage != null && energyStorage.getEnergyStored() >= amount;
    }

    public boolean consumeEnergy(ItemStack stack, int amount) {
        CustomEnergyStorage energyStorage = this.getEnergy(stack);
        if (energyStorage != null && energyStorage.getEnergyStored() >= amount) {
            energyStorage.extractEnergy(amount, false);
            return true;
        }
        return false;
    }

    public int addEnergy(ItemStack stack, int amount) {
        CustomEnergyStorage energyStorage = this.getEnergy(stack);
        if (energyStorage != null) {
            return energyStorage.receiveEnergy(amount, false);
        }
        return 0;
    }

    public ItemStack getInventoryItem(ItemStack multibuilderStack, int slot) {
        IItemHandler inventory = this.getInventory(multibuilderStack);
        if (inventory != null && slot >= 0 && slot < inventory.getSlots()) {
            return inventory.getStackInSlot(slot);
        }
        return ItemStack.f_41583_;
    }

    public ItemStack insertInventoryItem(ItemStack multibuilderStack, ItemStack itemToInsert, boolean simulate) {
        IItemHandler inventory = this.getInventory(multibuilderStack);
        if (inventory != null) {
            for (int i = 0; i < inventory.getSlots() && !(itemToInsert = inventory.insertItem(i, itemToInsert, simulate)).m_41619_(); ++i) {
            }
        }
        return itemToInsert;
    }

    public ItemStack extractInventoryItem(ItemStack multibuilderStack, int slot, int amount, boolean simulate) {
        IItemHandler inventory = this.getInventory(multibuilderStack);
        if (inventory != null && slot >= 0 && slot < inventory.getSlots()) {
            return inventory.extractItem(slot, amount, simulate);
        }
        return ItemStack.f_41583_;
    }

    public int getRotation(ItemStack stack) {
        try {
            if (!stack.m_41784_().m_128441_("rotation")) {
                return 0;
            }
            return stack.m_41784_().m_128451_("rotation");
        }
        catch (Exception ignored) {
            return 0;
        }
    }

    public void rotate(ItemStack stack, int dir) {
        try {
            CompoundTag tag = stack.m_41784_();
            int rotation = this.getRotation(stack);
            rotation = rotation + dir < 0 ? 3 : (rotation + dir) % 4;
            tag.m_128405_("rotation", rotation);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean hasRecipe(ItemStack stack) {
        try {
            int recipeIndex;
            MultibuilderItem multibuilderItem = (MultibuilderItem)stack.m_41720_();
            if (multibuilderItem.getRuntimeStructure(stack) != null) {
                return true;
            }
            CompoundTag tag = stack.m_41784_();
            if (tag == null || !tag.m_128441_("recipe")) {
                return false;
            }
            if (MultiblocksProvider.structures.isEmpty()) {
                MultiblocksProvider.getStructures();
            }
            return (recipeIndex = tag.m_128451_("recipe")) >= 0 && recipeIndex < MultiblocksProvider.structures.size();
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public MultiblockStructure getSelectedStructure(ItemStack stack) {
        try {
            if (!this.hasRecipe(stack)) {
                return null;
            }
            Item item = stack.m_41720_();
            if (item instanceof MultibuilderItem) {
                MultibuilderItem multibuilderItem = (MultibuilderItem)item;
                CompoundTag tag = stack.m_41784_();
                if (tag == null || !tag.m_128441_("recipe")) {
                    return null;
                }
                if (MultiblocksProvider.structures.isEmpty()) {
                    MultiblocksProvider.getStructures();
                }
                int recipeIndex = tag.m_128451_("recipe");
                return MultiblocksProvider.structures.get(recipeIndex);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private BlockPos getBuildPosition(Player player) {
        boolean off;
        Vec3 lookVec;
        Vec3 endPos;
        Level world = player.m_9236_();
        if (player == null || world == null) {
            return null;
        }
        Vec3 eyePos = player.m_20299_(1.0f);
        BlockHitResult rayTrace = world.m_45547_(new ClipContext(eyePos, endPos = eyePos.m_82549_((lookVec = player.m_20252_(1.0f)).m_82490_(20.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        if (rayTrace.m_6662_() != HitResult.Type.BLOCK) {
            return null;
        }
        ItemStack mainItem = player.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack offItem = player.m_21120_(InteractionHand.OFF_HAND);
        boolean main = !mainItem.m_41619_() && mainItem.m_150930_((Item)Mbtool.MBTOOL.get()) && this.hasRecipe(mainItem);
        boolean bl = off = !offItem.m_41619_() && offItem.m_150930_((Item)Mbtool.MBTOOL.get()) && this.hasRecipe(offItem);
        if (!main && !off) {
            return null;
        }
        BlockPos hit = rayTrace.m_82425_();
        BlockState state = world.m_8055_(hit);
        ItemStack multibuilderStack = main ? mainItem : offItem;
        int recipeIndex = multibuilderStack.m_41784_().m_128451_("recipe");
        if (MultiblocksProvider.structures.isEmpty()) {
            MultiblocksProvider.getStructures();
        }
        if (recipeIndex < 0 || recipeIndex >= MultiblocksProvider.structures.size()) {
            return null;
        }
        MultiblockStructure structure = MultiblocksProvider.structures.get(recipeIndex);
        if (structure == null) {
            return null;
        }
        int rotation = multibuilderStack.m_41784_().m_128451_("rotation");
        Direction hitSide = rayTrace.m_82434_();
        int maxSize = Math.max(structure.getWidth(), structure.getDepth()) - 1;
        switch (hitSide) {
            case DOWN: {
                hit = hit.m_7918_(0, -structure.getHeight(), 0);
                break;
            }
            case UP: {
                if (state.m_247087_()) break;
                hit = hit.m_7918_(0, 1, 0);
                break;
            }
            case EAST: {
                hit = hit.m_7918_(maxSize, 0, 0);
                break;
            }
            case WEST: {
                hit = hit.m_7918_(-maxSize, 0, 0);
                break;
            }
            case NORTH: {
                hit = hit.m_7918_(0, 0, -maxSize);
                break;
            }
            case SOUTH: {
                hit = hit.m_7918_(0, 0, maxSize);
            }
        }
        hit = rotation == 0 || rotation == 2 ? hit.m_7918_(-structure.getWidth() / 2, 0, -structure.getDepth() / 2) : hit.m_7918_(-structure.getDepth() / 2, 0, -structure.getWidth() / 2);
        return hit;
    }

    public void setRuntimeStructure(ItemStack stack, MultiblockStructure structure) {
        CompoundTag tag = stack.m_41784_();
        if (structure != null) {
            tag.m_128473_("recipe");
            tag.m_128365_("runtimeStructure", (Tag)structure.getStructureNbt());
        } else {
            tag.m_128473_("runtimeStructure");
        }
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (this.delay > 0) {
            --this.delay;
        }
    }

    public MultiblockStructure getRuntimeStructure(ItemStack stack) {
        try {
            CompoundTag tag = stack.m_41784_();
            if (tag != null && tag.m_128441_("runtimeStructure")) {
                CompoundTag structureNbt = tag.m_128469_("runtimeStructure");
                return new MultiblockStructure(structureNbt);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public MultiblockStructure getCurrentStructure(ItemStack stack) {
        MultiblockStructure structure = this.getRuntimeStructure(stack);
        if (structure == null) {
            structure = this.getSelectedStructure(stack);
        }
        return structure;
    }

    public int getSelectedStructureId(ItemStack multibuilderStack) {
        if (multibuilderStack.m_41784_().m_128441_("recipe")) {
            return multibuilderStack.m_41784_().m_128451_("recipe");
        }
        return -1;
    }

    public UUID getUUID(ItemStack multibuilderStack) {
        try {
            if (!multibuilderStack.m_41784_().m_128441_("uuid")) {
                multibuilderStack.m_41784_().m_128362_("uuid", UUID.randomUUID());
            }
            return multibuilderStack.m_41784_().m_128342_("uuid");
        }
        catch (Exception e) {
            return null;
        }
    }
}

