/*
 * Decompiled with CFR 0.152.
 */
package igentuman.mbtool.network;

import igentuman.mbtool.item.MultibuilderItem;
import igentuman.mbtool.util.MultiblockBuilder;
import igentuman.mbtool.util.MultiblockStructure;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class SyncRuntimeStructurePacket {
    private final CompoundTag structureNbt;
    private final int rotation;
    private final InteractionHand hand;

    public SyncRuntimeStructurePacket(CompoundTag structureNbt, int rotation, InteractionHand hand) {
        this.structureNbt = structureNbt;
        this.rotation = rotation;
        this.hand = hand;
    }

    public static void encode(SyncRuntimeStructurePacket packet, FriendlyByteBuf buffer) {
        buffer.m_130079_(packet.structureNbt);
        buffer.writeInt(packet.rotation);
        buffer.m_130068_((Enum)packet.hand);
    }

    public static SyncRuntimeStructurePacket decode(FriendlyByteBuf buffer) {
        CompoundTag structureNbt = buffer.m_130260_();
        int rotation = buffer.readInt();
        InteractionHand hand = (InteractionHand)buffer.m_130066_(InteractionHand.class);
        return new SyncRuntimeStructurePacket(structureNbt, rotation, hand);
    }

    public static void handle(SyncRuntimeStructurePacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            MultiblockStructure structure;
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            ItemStack itemStack = player.m_21120_(packet.hand);
            Item patt2061$temp = itemStack.m_41720_();
            if (!(patt2061$temp instanceof MultibuilderItem)) {
                return;
            }
            MultibuilderItem multibuilderItem = (MultibuilderItem)patt2061$temp;
            try {
                structure = new MultiblockStructure(packet.structureNbt);
            }
            catch (Exception e) {
                player.m_213846_((Component)Component.m_237115_((String)"message.mbtool.invalid_structure"));
                return;
            }
            itemStack.m_41784_().m_128405_("rotation", packet.rotation);
            BlockPos buildPos = SyncRuntimeStructurePacket.getBuildPosition(player, structure, packet.rotation);
            if (buildPos == null) {
                player.m_213846_((Component)Component.m_237115_((String)"message.mbtool.no_build_position"));
                return;
            }
            MultiblockBuilder.BuildResult result = MultiblockBuilder.buildMultiblock(player.m_9236_(), (Player)player, itemStack, structure, buildPos, packet.rotation);
            if (result.getMessage() != null) {
                // empty if block
            }
        });
        context.setPacketHandled(true);
    }

    private static BlockPos getBuildPosition(ServerPlayer player, MultiblockStructure structure, int rotation) {
        if (player == null || player.m_9236_() == null) {
            return null;
        }
        Vec3 eyePos = player.m_20299_(1.0f);
        Vec3 lookVec = player.m_20252_(1.0f);
        Vec3 endPos = eyePos.m_82549_(lookVec.m_82490_(20.0));
        BlockHitResult rayTrace = player.m_9236_().m_45547_(new ClipContext(eyePos, endPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        if (rayTrace.m_6662_() != HitResult.Type.BLOCK) {
            return null;
        }
        BlockPos hit = rayTrace.m_82425_();
        BlockState state = player.m_9236_().m_8055_(hit);
        Direction hitSide = rayTrace.m_82434_();
        int maxSize = Math.max(structure.getWidth(), structure.getDepth()) - 1;
        switch (hitSide) {
            case DOWN: {
                hit = hit.m_7918_(0, -structure.getHeight(), 0);
                break;
            }
            case UP: {
                if (state.m_247087_()) break;
                hit = hit.m_7918_(0, 1, 0);
                break;
            }
            case EAST: {
                hit = hit.m_7918_(maxSize, 0, 0);
                break;
            }
            case WEST: {
                hit = hit.m_7918_(-maxSize, 0, 0);
                break;
            }
            case NORTH: {
                hit = hit.m_7918_(0, 0, -maxSize);
                break;
            }
            case SOUTH: {
                hit = hit.m_7918_(0, 0, maxSize);
            }
        }
        hit = rotation == 0 || rotation == 2 ? hit.m_7918_(-structure.getWidth() / 2, 0, -structure.getDepth() / 2) : hit.m_7918_(-structure.getDepth() / 2, 0, -structure.getWidth() / 2);
        return hit;
    }
}

