/*
 * Decompiled with CFR 0.152.
 */
package igentuman.mbtool.util;

import igentuman.mbtool.util.CustomEnergyStorage;
import igentuman.mbtool.util.ItemInventoryHandler;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemCapabilityProvider
implements ICapabilityProvider {
    private final ItemStack stack;
    private final CustomEnergyStorage energyStorage;
    private final ItemInventoryHandler inventoryHandler;
    private final LazyOptional<CustomEnergyStorage> energyOptional;
    private final LazyOptional<IItemHandler> inventoryOptional;

    public ItemCapabilityProvider(final ItemStack stack, int energyCapacity, int energyTransferRate, int inventorySize, int stackSize) {
        this.stack = stack;
        this.energyStorage = new CustomEnergyStorage(energyCapacity, energyTransferRate, energyTransferRate){

            @Override
            public int extractEnergy(int extract, boolean simulate) {
                int amount = super.extractEnergy(extract, simulate);
                if (!simulate) {
                    stack.m_41784_().m_128405_("energy", this.energy);
                }
                return amount;
            }

            @Override
            public int receiveEnergy(int receive, boolean simulate) {
                int amount = super.receiveEnergy(receive, simulate);
                if (!simulate) {
                    stack.m_41784_().m_128405_("energy", this.energy);
                }
                return amount;
            }
        };
        this.inventoryHandler = new ItemInventoryHandler(inventorySize, stackSize){

            @Override
            public void setStackInSlot(int slot, @NotNull ItemStack stack) {
                super.setStackInSlot(slot, stack);
                ItemCapabilityProvider.this.saveToNBT();
            }

            @Override
            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                ItemStack result = super.insertItem(slot, stack, simulate);
                if (!simulate) {
                    ItemCapabilityProvider.this.saveToNBT();
                }
                return result;
            }

            @Override
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                ItemStack result = super.extractItem(slot, amount, simulate);
                if (!simulate && !result.m_41619_()) {
                    ItemCapabilityProvider.this.saveToNBT();
                }
                return result;
            }
        };
        this.energyOptional = LazyOptional.of(() -> this.energyStorage);
        this.inventoryOptional = LazyOptional.of(() -> this.inventoryHandler);
        this.loadFromNBT();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyOptional.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryOptional.cast();
        }
        return LazyOptional.empty();
    }

    private void loadFromNBT() {
        CompoundTag tag = this.stack.m_41784_();
        if (tag.m_128441_("energy")) {
            this.energyStorage.setEnergy(tag.m_128451_("energy"));
        }
        if (tag.m_128441_("Inventory")) {
            this.inventoryHandler.deserializeNBT(tag.m_128469_("Inventory"));
        }
    }

    public void saveToNBT() {
        CompoundTag tag = this.stack.m_41784_();
        tag.m_128405_("energy", this.energyStorage.getEnergyStored());
        CompoundTag inventoryNBT = this.inventoryHandler.serializeNBT();
        tag.m_128365_("Inventory", (Tag)inventoryNBT);
        this.stack.m_41751_(tag);
    }

    public CustomEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public ItemInventoryHandler getInventoryHandler() {
        return this.inventoryHandler;
    }

    public void forceSave() {
        this.saveToNBT();
    }
}

