/*
 * Decompiled with CFR 0.152.
 */
package igentuman.mbtool.util;

import igentuman.mbtool.config.MbtoolConfig;
import igentuman.mbtool.util.BlockEquivalencyManager;
import igentuman.mbtool.util.CapabilityUtils;
import igentuman.mbtool.util.CustomEnergyStorage;
import igentuman.mbtool.util.MultiblockStructure;
import igentuman.mbtool.util.TextUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;

public class MultiblockBuilder {
    public static BuildResult buildMultiblock(Level level, Player player, ItemStack multibuilderStack, MultiblockStructure structure, BlockPos centerPos, int rotation) {
        CustomEnergyStorage customEnergyStorage;
        Block requiredBlock;
        CustomEnergyStorage energyStorage2;
        if (level.f_46443_) {
            return new BuildResult(false, (Component)Component.m_237113_((String)"Cannot build on client side"));
        }
        boolean isCreative = player.m_7500_();
        Map<Block, Integer> requiredBlocks = MultiblockBuilder.calculateRequiredBlocks(structure);
        int totalEnergyCost = requiredBlocks.values().stream().mapToInt(Integer::intValue).sum() * MbtoolConfig.getEnergyPerBlock();
        if (!(isCreative || (energyStorage2 = MultiblockBuilder.getEnergyStorage(multibuilderStack)) != null && energyStorage2.getEnergyStored() >= totalEnergyCost)) {
            return new BuildResult(false, (Component)Component.m_237110_((String)"message.mbtool.insufficient_energy", (Object[])new Object[]{TextUtils.formatEnergy(totalEnergyCost)}));
        }
        HashMap<Block, Block> blockReplacements = new HashMap<Block, Block>();
        if (!isCreative) {
            IItemHandler inventory = MultiblockBuilder.getInventory(multibuilderStack);
            if (inventory == null) {
                return new BuildResult(false, (Component)Component.m_237115_((String)"message.mbtool.no_inventory"));
            }
            Map<Block, Integer> map = MultiblockBuilder.countAvailableBlocks(inventory);
            for (Map.Entry<Block, Integer> entry : requiredBlocks.entrySet()) {
                requiredBlock = entry.getKey();
                int required = entry.getValue();
                Block replacementBlock = BlockEquivalencyManager.findReplacement(requiredBlock, map);
                if (replacementBlock == null) {
                    return new BuildResult(false, (Component)Component.m_237110_((String)"message.mbtool.insufficient_blocks", (Object[])new Object[]{requiredBlock.m_49954_(), required}));
                }
                int available = map.getOrDefault(replacementBlock, 0);
                if (available < required) {
                    return new BuildResult(false, (Component)Component.m_237110_((String)"message.mbtool.insufficient_blocks", (Object[])new Object[]{requiredBlock.m_49954_(), required - available}));
                }
                blockReplacements.put(requiredBlock, replacementBlock);
            }
        }
        for (Map.Entry entry : structure.getBlocks().entrySet()) {
            BlockPos blockPos = (BlockPos)entry.getKey();
            BlockState blockState = (BlockState)entry.getValue();
            if (blockState.m_60795_()) continue;
            BlockPos rotatedRelativePos = MultiblockBuilder.rotateBlockPos(blockPos, structure, rotation);
            BlockPos worldPos = centerPos.m_121955_((Vec3i)rotatedRelativePos);
            BlockState currentState = level.m_8055_(worldPos);
            BlockState rotatedBlockState = MultiblockBuilder.rotateBlockState(blockState, rotation);
            if (!currentState.m_247087_() || !MultiblockBuilder.canPlayerPlaceBlockAt(level, player, worldPos, blockState)) {
                return new BuildResult(false, (Component)Component.m_237110_((String)"message.mbtool.cannot_place_at", (Object[])new Object[]{worldPos.m_123341_(), worldPos.m_123342_(), worldPos.m_123343_()}));
            }
            if (MultiblockBuilder.canPlayerPlaceBlockAt(level, player, worldPos, rotatedBlockState)) continue;
            return new BuildResult(false, (Component)Component.m_237110_((String)"message.mbtool.cannot_place_protected", (Object[])new Object[]{worldPos.m_123341_(), worldPos.m_123342_(), worldPos.m_123343_()}));
        }
        int blocksPlaced = 0;
        if (!isCreative) {
            IItemHandler iItemHandler = MultiblockBuilder.getInventory(multibuilderStack);
            for (Map.Entry<Block, Integer> entry : requiredBlocks.entrySet()) {
                requiredBlock = entry.getKey();
                Block replacementBlock = (Block)blockReplacements.get(requiredBlock);
                int needed = entry.getValue();
                for (int slot = 0; slot < iItemHandler.getSlots() && needed > 0; ++slot) {
                    ItemStack slotStack = iItemHandler.getStackInSlot(slot);
                    if (slotStack.m_41619_() || Block.m_49814_((Item)slotStack.m_41720_()) != replacementBlock) continue;
                    int toExtract = Math.min(needed, slotStack.m_41613_());
                    iItemHandler.extractItem(slot, toExtract, false);
                    needed -= toExtract;
                }
            }
        }
        for (Map.Entry<BlockPos, BlockState> entry : structure.getBlocks().entrySet()) {
            Block originalBlock;
            Block replacementBlock;
            BlockState rotatedBlockState;
            BlockPos blockPos = entry.getKey();
            BlockState blockState = entry.getValue();
            if (blockState.m_60795_()) continue;
            BlockPos rotatedRelativePos = MultiblockBuilder.rotateBlockPos(blockPos, structure, rotation);
            BlockPos worldPos = centerPos.m_121955_((Vec3i)rotatedRelativePos);
            BlockState finalBlockState = rotatedBlockState = MultiblockBuilder.rotateBlockState(blockState, rotation);
            if (!isCreative && (replacementBlock = (Block)blockReplacements.get(originalBlock = rotatedBlockState.m_60734_())) != null && replacementBlock != originalBlock) {
                finalBlockState = MultiblockBuilder.createReplacementBlockState(rotatedBlockState, replacementBlock);
            }
            if (!MultiblockBuilder.placeBlockAsPlayer(level, player, worldPos, finalBlockState)) continue;
            ++blocksPlaced;
            if (!finalBlockState.m_155947_()) continue;
            level.m_7702_(worldPos);
        }
        if (!isCreative && (customEnergyStorage = MultiblockBuilder.getEnergyStorage(multibuilderStack)) != null) {
            customEnergyStorage.extractEnergy(totalEnergyCost, false);
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            MultiblockBuilder.spawnSmokeParticles(serverLevel, structure, centerPos, rotation);
            MultiblockBuilder.sendPlacementSoundEvent(level, centerPos);
        }
        return new BuildResult(true, (Component)Component.m_237110_((String)"message.mbtool.multiblock_built", (Object[])new Object[]{blocksPlaced, Component.m_237115_((String)structure.getName())}));
    }

    private static void sendPlacementSoundEvent(Level level, BlockPos centerPos) {
        level.m_5594_(null, centerPos, SoundEvents.f_12200_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private static boolean canPlayerPlaceBlockAt(Level level, Player player, BlockPos pos, BlockState blockState) {
        return level.m_7966_(player, pos);
    }

    private static boolean placeBlockAsPlayer(Level level, Player player, BlockPos pos, BlockState blockState) {
        if (!MultiblockBuilder.canPlayerPlaceBlockAt(level, player, pos, blockState)) {
            return false;
        }
        boolean success = level.m_7731_(pos, blockState, 3);
        if (success && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Block block = blockState.m_60734_();
            block.m_6402_(level, pos, blockState, (LivingEntity)player, new ItemStack((ItemLike)block.m_5456_()));
        }
        return success;
    }

    private static BlockState rotateBlockState(BlockState blockState, int rotation) {
        if (rotation == 0) {
            return blockState;
        }
        BlockState rotatedState = blockState;
        for (Property property : blockState.m_61147_()) {
            if (!(property instanceof DirectionProperty)) continue;
            DirectionProperty dirProperty = (DirectionProperty)property;
            Direction currentDirection = (Direction)blockState.m_61143_((Property)dirProperty);
            Direction rotatedDirection = MultiblockBuilder.rotateDirection(currentDirection, rotation, dirProperty);
            if (!dirProperty.m_6908_().contains(rotatedDirection)) continue;
            rotatedState = (BlockState)rotatedState.m_61124_((Property)dirProperty, (Comparable)rotatedDirection);
        }
        return rotatedState;
    }

    private static Direction rotateDirection(Direction direction, int rotation, DirectionProperty property) {
        rotation = (rotation % 4 + 4) % 4;
        boolean isHorizontalOnly = property.m_6908_().stream().allMatch(dir -> dir.m_122434_() != Direction.Axis.Y);
        if (isHorizontalOnly && (direction == Direction.UP || direction == Direction.DOWN)) {
            return direction;
        }
        Direction result = direction;
        for (int i = 0; i < rotation; ++i) {
            result = MultiblockBuilder.rotateDirectionClockwise(result, isHorizontalOnly);
        }
        return result;
    }

    private static Direction rotateDirectionClockwise(Direction direction, boolean horizontalOnly) {
        switch (direction) {
            case NORTH: {
                return Direction.EAST;
            }
            case EAST: {
                return Direction.SOUTH;
            }
            case SOUTH: {
                return Direction.WEST;
            }
            case WEST: {
                return Direction.NORTH;
            }
            case UP: {
                return horizontalOnly ? Direction.UP : Direction.UP;
            }
            case DOWN: {
                return horizontalOnly ? Direction.DOWN : Direction.DOWN;
            }
        }
        return direction;
    }

    private static BlockPos rotateBlockPos(BlockPos relativePos, MultiblockStructure structure, int rotation) {
        if (rotation == 0) {
            return relativePos;
        }
        int xo = relativePos.m_123341_() - structure.getMinX();
        int yo = relativePos.m_123342_() - structure.getMinY();
        int zo = relativePos.m_123343_() - structure.getMinZ();
        int rotatedX = xo;
        int rotatedZ = zo;
        int bWidth = structure.getDepth();
        int bLength = structure.getWidth();
        switch (rotation) {
            case 1: {
                rotatedZ = xo;
                rotatedX = bWidth - zo - 1;
                break;
            }
            case 2: {
                rotatedX = bLength - xo - 1;
                rotatedZ = bWidth - zo - 1;
                break;
            }
            case 3: {
                rotatedZ = bLength - xo - 1;
                rotatedX = zo;
            }
        }
        return new BlockPos(rotatedX + structure.getMinX(), yo + structure.getMinY(), rotatedZ + structure.getMinZ());
    }

    private static Map<Block, Integer> calculateRequiredBlocks(MultiblockStructure structure) {
        HashMap<Block, Integer> requiredBlocks = new HashMap<Block, Integer>();
        for (BlockState blockState : structure.getBlocks().values()) {
            if (blockState.m_60795_()) continue;
            Block block = blockState.m_60734_();
            requiredBlocks.put(block, requiredBlocks.getOrDefault(block, 0) + 1);
        }
        return requiredBlocks;
    }

    private static Map<Block, Integer> countAvailableBlocks(IItemHandler inventory) {
        HashMap<Block, Integer> availableBlocks = new HashMap<Block, Integer>();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            Block block;
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.m_41619_() || (block = Block.m_49814_((Item)stack.m_41720_())) == Blocks.f_50016_) continue;
            availableBlocks.put(block, availableBlocks.getOrDefault(block, 0) + stack.m_41613_());
        }
        return availableBlocks;
    }

    private static CustomEnergyStorage getEnergyStorage(ItemStack stack) {
        return (CustomEnergyStorage)((Object)CapabilityUtils.getPresentCapability((ICapabilityProvider)stack, ForgeCapabilities.ENERGY));
    }

    private static IItemHandler getInventory(ItemStack stack) {
        return (IItemHandler)CapabilityUtils.getPresentCapability((ICapabilityProvider)stack, ForgeCapabilities.ITEM_HANDLER);
    }

    private static void spawnSmokeParticles(ServerLevel serverLevel, MultiblockStructure structure, BlockPos centerPos, int rotation) {
        int i;
        RandomSource random = serverLevel.m_213780_();
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (BlockPos relativePos : structure.getBlocks().keySet()) {
            BlockState blockState = structure.getBlocks().get(relativePos);
            if (blockState.m_60795_()) continue;
            BlockPos rotatedRelativePos = MultiblockBuilder.rotateBlockPos(relativePos, structure, rotation);
            BlockPos worldPos = centerPos.m_121955_((Vec3i)rotatedRelativePos);
            minX = Math.min(minX, worldPos.m_123341_());
            maxX = Math.max(maxX, worldPos.m_123341_());
            minY = Math.min(minY, worldPos.m_123342_());
            maxY = Math.max(maxY, worldPos.m_123342_());
            minZ = Math.min(minZ, worldPos.m_123343_());
            maxZ = Math.max(maxZ, worldPos.m_123343_());
        }
        int particleCount = Math.max(20, (maxX - minX + maxZ - minZ) * 2);
        for (i = 0; i < particleCount; ++i) {
            double x;
            int side = random.m_188503_(4);
            double z = switch (side) {
                case 0 -> {
                    x = (double)minX + random.m_188500_() * (double)(maxX - minX + 1);
                    yield (double)minZ - 0.5 + random.m_188500_() * 0.5;
                }
                case 1 -> {
                    x = (double)minX + random.m_188500_() * (double)(maxX - minX + 1);
                    yield (double)maxZ + 0.5 + random.m_188500_() * 0.5;
                }
                case 2 -> {
                    x = (double)minX - 0.5 + random.m_188500_() * 0.5;
                    yield (double)minZ + random.m_188500_() * (double)(maxZ - minZ + 1);
                }
                default -> {
                    x = (double)maxX + 0.5 + random.m_188500_() * 0.5;
                    yield (double)minZ + random.m_188500_() * (double)(maxZ - minZ + 1);
                }
            };
            double y = (double)minY + random.m_188500_() * (double)(maxY - minY + 2) + 0.5;
            double velocityX = (random.m_188500_() - 0.5) * 0.1;
            double velocityY = random.m_188500_() * 0.1 + 0.05;
            double velocityZ = (random.m_188500_() - 0.5) * 0.1;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123749_, x, y, z, 1, velocityX, velocityY, velocityZ, 0.02);
            if (!(random.m_188501_() < 0.3f)) continue;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123749_, x, y, z, 1, velocityX, velocityY, velocityZ, 0.02);
        }
        for (i = 0; i < 5; ++i) {
            double offsetX = (random.m_188500_() - 0.5) * 2.0;
            double offsetY = random.m_188500_() * 2.0;
            double offsetZ = (random.m_188500_() - 0.5) * 2.0;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123749_, (double)centerPos.m_123341_() + 0.5 + offsetX, (double)(centerPos.m_123342_() + 1) + offsetY, (double)centerPos.m_123343_() + 0.5 + offsetZ, 3, 0.1, 0.1, 0.1, 0.05);
        }
    }

    private static BlockState createReplacementBlockState(BlockState originalState, Block replacementBlock) {
        BlockState replacementState = replacementBlock.m_49966_();
        for (Property property : originalState.m_61147_()) {
            if (!replacementState.m_61138_(property)) continue;
            try {
                replacementState = MultiblockBuilder.copyPropertyValue(originalState, replacementState, property);
            }
            catch (Exception exception) {}
        }
        return replacementState;
    }

    private static <T extends Comparable<T>> BlockState copyPropertyValue(BlockState sourceState, BlockState targetState, Property<?> property) {
        Property<?> typedProperty = property;
        Comparable value = sourceState.m_61143_(typedProperty);
        if (typedProperty.m_6908_().contains(value)) {
            return (BlockState)targetState.m_61124_(typedProperty, value);
        }
        return targetState;
    }

    public static class BuildResult {
        private final boolean success;
        private final Component message;

        public BuildResult(boolean success, Component message) {
            this.success = success;
            this.message = message;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public Component getMessage() {
            return this.message;
        }
    }
}

