/*
 * Decompiled with CFR 0.152.
 */
package igentuman.mbtool.util;

import igentuman.mbtool.Mbtool;
import igentuman.mbtool.integration.kubejs.MbtoolKubeJsEvents;
import igentuman.mbtool.util.InitMbtoolStructuresEvent;
import igentuman.mbtool.util.ModUtil;
import igentuman.mbtool.util.MultiblockStructure;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class MultiblocksProvider
implements PreparableReloadListener {
    public static List<MultiblockStructure> structures = new ArrayList<MultiblockStructure>();
    private static MultiblocksProvider INSTANCE = new MultiblocksProvider();

    public static MultiblocksProvider getInstance() {
        return INSTANCE;
    }

    public static List<MultiblockStructure> getStructures() {
        return structures;
    }

    public static void setStructures(List<MultiblockStructure> newStructures) {
        structures.clear();
        structures.addAll(newStructures);
    }

    public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier preparationBarrier, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> MultiblocksProvider.loadMultiblockStructures(resourceManager), backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).m_6769_(arg_0))).thenAcceptAsync(loadedStructures -> {
            InitMbtoolStructuresEvent event = new InitMbtoolStructuresEvent((List<MultiblockStructure>)loadedStructures);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (ModUtil.isKubeJsLoaded()) {
                MbtoolKubeJsEvents.onInitMbtoolStructures(event);
            }
            structures.clear();
            structures.addAll((Collection<MultiblockStructure>)loadedStructures);
        }, gameExecutor);
    }

    private static List<MultiblockStructure> loadMultiblockStructures(ResourceManager resourceManager) {
        ArrayList<MultiblockStructure> loadedStructures = new ArrayList<MultiblockStructure>();
        loadedStructures.addAll(MultiblocksProvider.loadFromLocation(resourceManager, "mbtool_structures"));
        loadedStructures.addAll(MultiblocksProvider.loadFromLocation(resourceManager, "spatial_structures"));
        return loadedStructures;
    }

    private static List<MultiblockStructure> loadFromLocation(ResourceManager resourceManager, String mbtoolStructures) {
        ArrayList<MultiblockStructure> tmp = new ArrayList<MultiblockStructure>();
        Map structureFiles = resourceManager.m_214159_(mbtoolStructures, location -> location.m_135815_().endsWith(".nbt"));
        for (Map.Entry entry : structureFiles.entrySet()) {
            ResourceLocation location2 = (ResourceLocation)entry.getKey();
            Resource resource = (Resource)entry.getValue();
            try {
                CompoundTag nbt = NbtIo.m_128939_((InputStream)resource.m_215507_());
                if (MultiblocksProvider.validateStructureBlocks(nbt)) {
                    String fileName = location2.m_135815_().substring(location2.m_135815_().lastIndexOf(47) + 1);
                    tmp.add(new MultiblockStructure(location2, nbt, fileName));
                    continue;
                }
                System.out.println("Skipping structure " + location2 + " due to missing blocks");
            }
            catch (IOException e) {
                System.err.println("Failed to load structure from " + location2 + ": " + e.getMessage());
            }
        }
        if (ModUtil.isGtLoaded()) {
            // empty if block
        }
        return tmp;
    }

    @Deprecated
    public static List<MultiblockStructure> loadMultiblockStructures() {
        return MultiblocksProvider.getStructures();
    }

    private static boolean validateStructureBlocks(CompoundTag nbt) {
        if (!nbt.m_128425_("palette", 9)) {
            return false;
        }
        ListTag palette = nbt.m_128437_("palette", 10);
        for (int i = 0; i < palette.size(); ++i) {
            CompoundTag blockState = palette.m_128728_(i);
            String blockId = blockState.m_128461_("Name");
            if (blockId.isEmpty()) continue;
            try {
                ResourceLocation blockLocation = Mbtool.rlFromString(blockId);
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(blockLocation);
                if (block != null && blockLocation.m_135815_().equals(block.m_5456_().toString())) continue;
                System.out.println("Missing block in structure: " + blockId);
                return false;
            }
            catch (Exception e) {
                System.err.println("Error validating block " + blockId + ": " + e.getMessage());
                return false;
            }
        }
        return true;
    }
}

