/*
 * Decompiled with CFR 0.152.
 */
package igentuman.mbtool;

import igentuman.mbtool.client.DismantleHandler;
import igentuman.mbtool.client.screen.MultibuilderScreen;
import igentuman.mbtool.client.screen.MultibuilderSelectStructureScreen;
import igentuman.mbtool.config.MbtoolConfig;
import igentuman.mbtool.container.MultibuilderContainer;
import igentuman.mbtool.container.MultibuilderSelectStructureContainer;
import igentuman.mbtool.item.MultibuilderItem;
import igentuman.mbtool.network.NetworkHandler;
import igentuman.mbtool.util.BlockEquivalencyManager;
import igentuman.mbtool.util.MultiblocksProvider;
import igentuman.nc.handler.config.CommonConfig;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="mbtool")
@Mod.EventBusSubscriber
public class Mbtool {
    public static final String MODID = "mbtool";
    public static final Logger logger = LogManager.getLogger();
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"mbtool");
    public static final Item.Properties ONE_ITEM_PROPERTIES = new Item.Properties().m_41487_(1);
    public static final DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"mbtool");
    public static final RegistryObject<MultibuilderItem> MBTOOL = ITEMS.register("mbtool", () -> new MultibuilderItem(ONE_ITEM_PROPERTIES));
    public static final RegistryObject<MenuType<MultibuilderContainer>> MULTIBUILDER_CONTAINER = CONTAINERS.register("mbtool_container", () -> IForgeMenuType.create((windowId, inv, data) -> new MultibuilderContainer(windowId, data.m_130135_(), inv, data.readInt())));
    public static final RegistryObject<MenuType<MultibuilderSelectStructureContainer>> MULTIBUILDER_STRUCTURE_CONTAINER = CONTAINERS.register("mbtool_structure_container", () -> IForgeMenuType.create((windowId, inv, data) -> new MultibuilderSelectStructureContainer(windowId, data.m_130135_(), inv, data.readInt())));

    public Mbtool() {
        this(FMLJavaModLoadingContext.get());
    }

    public Mbtool(FMLJavaModLoadingContext context) {
        ITEMS.register(context.getModEventBus());
        CONTAINERS.register(context.getModEventBus());
        context.getModEventBus().addListener(this::commonSetup);
        context.getModEventBus().addListener(Mbtool::init);
        context.getModEventBus().addListener(this::addCreative);
        MbtoolConfig.register();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> NetworkHandler.registerPackets());
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent event) {
        if (event.getConfig().getType() == ModConfig.Type.COMMON) {
            CommonConfig.setLoaded();
            BlockEquivalencyManager.reinitialize();
        }
    }

    public static void init(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)MULTIBUILDER_CONTAINER.get()), MultibuilderScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)MULTIBUILDER_STRUCTURE_CONTAINER.get()), (container, inventory, title) -> new MultibuilderSelectStructureScreen((MultibuilderSelectStructureContainer)container, inventory, title));
        });
        MinecraftForge.EVENT_BUS.register(DismantleHandler.class);
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256869_) {
            event.accept(MBTOOL);
        }
    }

    @SubscribeEvent
    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)MultiblocksProvider.getInstance());
    }

    public static ResourceLocation rlFromString(String name) {
        return ResourceLocation.m_135820_((String)name);
    }

    public static ResourceLocation rl(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)name);
    }
}

