/*
 * Decompiled with CFR 0.152.
 */
package igentuman.mbtool.client;

import igentuman.mbtool.item.MultibuilderItem;
import igentuman.mbtool.network.DismantleStructurePacket;
import igentuman.mbtool.network.NetworkHandler;
import igentuman.mbtool.util.MultiblockStructure;
import igentuman.mbtool.util.MultiblocksProvider;
import igentuman.mbtool.util.PlacedStructure;
import igentuman.mbtool.util.PlacedStructuresManager;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class DismantleHandler {
    private static boolean isDismantling = false;
    private static long dismantleStartTime = 0L;
    private static final long DISMANTLE_DURATION = 555L;
    private static BlockPos targetPos = null;
    private static InteractionHand targetHand = null;
    private static PlacedStructure currentLookedAtStructure = null;
    private static ItemStack currentMultibuilderStack = null;
    private static InteractionHand currentHand = null;

    public static boolean isDismantling() {
        return isDismantling;
    }

    public static PlacedStructure getDismantlingStructure() {
        if (!isDismantling || targetPos == null) {
            return null;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return null;
        }
        ItemStack multibuilderStack = mc.f_91074_.m_21120_(targetHand);
        if (!(multibuilderStack.m_41720_() instanceof MultibuilderItem)) {
            return null;
        }
        return PlacedStructuresManager.findStructureAt(multibuilderStack, targetPos);
    }

    private static boolean isHoldingMultibuilderTool(Player player) {
        if (player == null) {
            return false;
        }
        ItemStack mainHand = player.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack offHand = player.m_21120_(InteractionHand.OFF_HAND);
        return mainHand.m_41720_() instanceof MultibuilderItem || offHand.m_41720_() instanceof MultibuilderItem;
    }

    private static BlockHitResult performExtendedRayTrace(Minecraft mc, double maxDistance) {
        Vec3 lookVec;
        Vec3 endPos;
        LocalPlayer player = mc.f_91074_;
        if (player == null || mc.f_91073_ == null) {
            return null;
        }
        Vec3 eyePos = player.m_20299_(1.0f);
        ClipContext clipContext = new ClipContext(eyePos, endPos = eyePos.m_82549_((lookVec = player.m_20252_(1.0f)).m_82490_(maxDistance)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player);
        BlockHitResult result = mc.f_91073_.m_45547_(clipContext);
        return result.m_6662_() == HitResult.Type.BLOCK ? result : null;
    }

    private static boolean isBlockPartOfStructure(PlacedStructure structure, BlockPos clickedPos) {
        if (structure == null || clickedPos == null) {
            return false;
        }
        return structure.contains(clickedPos);
    }

    private static boolean hasEnoughInventorySpace(ItemStack multibuilderStack, PlacedStructure structure) {
        if (multibuilderStack == null || structure == null) {
            return false;
        }
        Item item = multibuilderStack.m_41720_();
        if (!(item instanceof MultibuilderItem)) {
            return false;
        }
        MultibuilderItem multibuilderItem = (MultibuilderItem)item;
        IItemHandler inventory = multibuilderItem.getInventory(multibuilderStack);
        if (inventory == null) {
            return false;
        }
        MultiblockStructure structureDefinition = null;
        String structureId = structure.getStructureId();
        if (MultiblocksProvider.structures.isEmpty()) {
            MultiblocksProvider.getStructures();
        }
        for (MultiblockStructure struct : MultiblocksProvider.structures) {
            if (struct.getId() == null || !struct.getId().toString().equals(structureId)) continue;
            structureDefinition = struct;
            break;
        }
        if (structureDefinition == null) {
            return true;
        }
        List<ItemStack> neededItems = structureDefinition.getNeededItems();
        for (ItemStack itemStack : neededItems) {
            ItemStack remaining = itemStack.m_41777_();
            for (int i = 0; i < inventory.getSlots() && !remaining.m_41619_(); ++i) {
                remaining = inventory.insertItem(i, remaining, true);
            }
            if (remaining.m_41619_()) continue;
            return false;
        }
        return true;
    }

    private static void updateRayTracing(Minecraft mc) {
        PlacedStructure structure;
        LocalPlayer player = mc.f_91074_;
        if (player == null || mc.f_91073_ == null) {
            currentLookedAtStructure = null;
            currentMultibuilderStack = null;
            currentHand = null;
            return;
        }
        if (!DismantleHandler.isHoldingMultibuilderTool((Player)player)) {
            currentLookedAtStructure = null;
            currentMultibuilderStack = null;
            currentHand = null;
            return;
        }
        ItemStack mainHand = player.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack offHand = player.m_21120_(InteractionHand.OFF_HAND);
        ItemStack multibuilderStack = null;
        InteractionHand hand = null;
        if (mainHand.m_41720_() instanceof MultibuilderItem) {
            multibuilderStack = mainHand;
            hand = InteractionHand.MAIN_HAND;
        } else if (offHand.m_41720_() instanceof MultibuilderItem) {
            multibuilderStack = offHand;
            hand = InteractionHand.OFF_HAND;
        }
        if (multibuilderStack == null) {
            currentLookedAtStructure = null;
            currentMultibuilderStack = null;
            currentHand = null;
            return;
        }
        BlockHitResult blockHitResult = DismantleHandler.performExtendedRayTrace(mc, 48.0);
        if (blockHitResult == null) {
            currentLookedAtStructure = null;
            currentMultibuilderStack = null;
            currentHand = null;
            return;
        }
        BlockPos pos = blockHitResult.m_82425_();
        if (blockHitResult.m_82434_() == Direction.UP) {
            pos = pos.m_7495_();
        }
        if (blockHitResult.m_82434_() == Direction.EAST) {
            pos = pos.m_122024_();
        }
        if (blockHitResult.m_82434_() == Direction.SOUTH) {
            pos = pos.m_122012_();
        }
        if ((structure = PlacedStructuresManager.findStructureAt(multibuilderStack, pos)) != null && DismantleHandler.isBlockPartOfStructure(structure, pos)) {
            currentLookedAtStructure = structure;
            currentMultibuilderStack = multibuilderStack;
            currentHand = hand;
        } else {
            currentLookedAtStructure = null;
            currentMultibuilderStack = null;
            currentHand = null;
        }
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        if (event.getKey() == 70 && DismantleHandler.isHoldingMultibuilderTool((Player)mc.f_91074_)) {
            if (event.getAction() == 1) {
                DismantleHandler.startDismantle(mc);
            } else if (event.getAction() == 0) {
                DismantleHandler.stopDismantle();
            }
        }
    }

    private static void startDismantle(Minecraft mc) {
        PlacedStructure structure;
        LocalPlayer player = mc.f_91074_;
        if (player == null || !DismantleHandler.isHoldingMultibuilderTool((Player)player)) {
            return;
        }
        ItemStack mainHand = player.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack offHand = player.m_21120_(InteractionHand.OFF_HAND);
        ItemStack multibuilderStack = null;
        InteractionHand hand = null;
        if (mainHand.m_41720_() instanceof MultibuilderItem) {
            multibuilderStack = mainHand;
            hand = InteractionHand.MAIN_HAND;
        } else if (offHand.m_41720_() instanceof MultibuilderItem) {
            multibuilderStack = offHand;
            hand = InteractionHand.OFF_HAND;
        }
        if (multibuilderStack == null) {
            return;
        }
        BlockHitResult blockHitResult = DismantleHandler.performExtendedRayTrace(mc, 48.0);
        if (blockHitResult == null) {
            return;
        }
        BlockPos pos = blockHitResult.m_82425_();
        if (blockHitResult.m_82434_() == Direction.UP) {
            pos = pos.m_7495_();
        }
        if (blockHitResult.m_82434_() == Direction.EAST) {
            pos = pos.m_122024_();
        }
        if (blockHitResult.m_82434_() == Direction.SOUTH) {
            pos = pos.m_122012_();
        }
        if ((structure = PlacedStructuresManager.findStructureAt(multibuilderStack, pos)) == null) {
            return;
        }
        if (!DismantleHandler.isBlockPartOfStructure(structure, pos)) {
            return;
        }
        if (!DismantleHandler.hasEnoughInventorySpace(multibuilderStack, structure)) {
            player.m_213846_((Component)Component.m_237115_((String)"message.mbtool.insufficient_inventory_space"));
            return;
        }
        isDismantling = true;
        dismantleStartTime = System.currentTimeMillis();
        targetPos = pos;
        targetHand = hand;
    }

    private static void stopDismantle() {
        if (!isDismantling) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        long elapsedTime = currentTime - dismantleStartTime;
        if (elapsedTime >= 555L && targetPos != null && targetHand != null) {
            NetworkHandler.INSTANCE.sendToServer((Object)new DismantleStructurePacket(targetPos, targetHand));
        }
        isDismantling = false;
        dismantleStartTime = 0L;
        targetPos = null;
        targetHand = null;
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        DismantleHandler.updateRayTracing(mc);
        if (DismantleHandler.isHoldingMultibuilderTool((Player)mc.f_91074_)) {
            while (mc.f_91066_.f_92093_.m_90859_()) {
            }
        }
    }

    @SubscribeEvent
    public static void onRenderGuiOverlay(RenderGuiOverlayEvent.Post event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        if (isDismantling) {
            long currentTime = System.currentTimeMillis();
            long elapsedTime = currentTime - dismantleStartTime;
            float progress = Math.min(1.0f, (float)elapsedTime / 555.0f);
            DismantleHandler.renderDismantleProgressBar(event.getGuiGraphics(), progress);
            if (elapsedTime >= 555L) {
                DismantleHandler.stopDismantle();
            }
        } else if (currentLookedAtStructure != null && currentMultibuilderStack != null) {
            DismantleHandler.renderDismantleTooltip(event.getGuiGraphics());
        }
    }

    private static void renderDismantleProgressBar(GuiGraphics guiGraphics, float progress) {
        Minecraft mc = Minecraft.m_91087_();
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        int barWidth = 100;
        int barHeight = 7;
        int barX = (screenWidth - barWidth) / 2;
        int barY = screenHeight / 2 + 50;
        guiGraphics.m_280509_(barX - 2, barY - 2, barX + barWidth + 2, barY + barHeight + 2, -16777216);
        guiGraphics.m_280509_(barX, barY, barX + barWidth, barY + barHeight, -13421773);
        int progressWidth = (int)((float)barWidth * progress);
        guiGraphics.m_280509_(barX, barY, barX + progressWidth, barY + barHeight, -39424);
        MutableComponent text = Component.m_237110_((String)"message.mbtool.dismantling_progress", (Object[])new Object[]{(int)(progress * 100.0f)});
        int textWidth = mc.f_91062_.m_92852_((FormattedText)text);
        int textX = (screenWidth - textWidth) / 2;
        int textY = barY - 15;
        guiGraphics.m_280430_(mc.f_91062_, (Component)text, textX, textY, -1);
    }

    private static void renderDismantleTooltip(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.m_91087_();
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        MutableComponent tooltipText = Component.m_237115_((String)"message.mbtool.hold_f_to_dismantle");
        int textWidth = mc.f_91062_.m_92852_((FormattedText)tooltipText);
        Objects.requireNonNull(mc.f_91062_);
        int textHeight = 9;
        int tooltipX = (screenWidth - textWidth) / 2;
        int tooltipY = screenHeight / 2 + 60;
        int padding = 4;
        int bgX = tooltipX - padding;
        int bgY = tooltipY - padding;
        int bgWidth = textWidth + padding * 2;
        int bgHeight = textHeight + padding * 2;
        guiGraphics.m_280509_(bgX, bgY, bgX + bgWidth, bgY + bgHeight, -872415232);
        guiGraphics.m_280509_(bgX - 1, bgY - 1, bgX + bgWidth + 1, bgY, -1);
        guiGraphics.m_280509_(bgX - 1, bgY + bgHeight, bgX + bgWidth + 1, bgY + bgHeight + 1, -1);
        guiGraphics.m_280509_(bgX - 1, bgY, bgX, bgY + bgHeight, -1);
        guiGraphics.m_280509_(bgX + bgWidth, bgY, bgX + bgWidth + 1, bgY + bgHeight, -1);
        guiGraphics.m_280430_(mc.f_91062_, (Component)tooltipText, tooltipX, tooltipY, -256);
    }
}

