/*
 * Decompiled with CFR 0.152.
 */
package igentuman.mbtool.client.gui;

import igentuman.mbtool.client.gui.MultiblockButton;
import igentuman.mbtool.client.gui.MultiblockButtonStyles;
import igentuman.mbtool.client.gui.MultiblockSelectionGrid;
import igentuman.mbtool.util.MultiblockStructure;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class MultiblockGalleryScreen
extends Screen {
    private MultiblockSelectionGrid structureGrid;
    private MultiblockButton previewButton;
    private MultiblockButton selectedStructureButton;
    private Button closeButton;
    private Button styleToggleButton;
    private final List<MultiblockStructure> exampleStructures = new ArrayList<MultiblockStructure>();
    private final List<String> structureNames = new ArrayList<String>();
    private int currentStyleIndex = 0;
    private final String[] styleNames = new String[]{"Standard", "Dark", "Light", "Blue", "Green", "Transparent"};

    public MultiblockGalleryScreen() {
        super((Component)Component.m_237115_((String)"gui.mbtool.multiblock_gallery"));
        this.initializeExampleStructures();
    }

    private void initializeExampleStructures() {
        String[] names;
        for (String name : names = new String[]{"Simple House", "Castle Tower", "Windmill", "Bridge", "Factory", "Lighthouse", "Temple", "Observatory"}) {
            MultiblockStructure structure = new MultiblockStructure(new CompoundTag());
            this.exampleStructures.add(structure);
            this.structureNames.add(name);
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        int gridX = 20;
        int gridY = 40;
        int gridWidth = 280;
        int gridHeight = 200;
        this.structureGrid = new MultiblockSelectionGrid(gridX, gridY, gridWidth, gridHeight, this::onStructureSelected);
        for (int i = 0; i < this.exampleStructures.size(); ++i) {
            this.structureGrid.addStructure(this.exampleStructures.get(i), this.structureNames.get(i), (Component)Component.m_237110_((String)"gui.mbtool.structure_description", (Object[])new Object[]{this.structureNames.get(i)}));
        }
        this.m_142416_((GuiEventListener)this.structureGrid);
        int previewX = gridX + gridWidth + 20;
        int previewY = gridY;
        int previewSize = 120;
        this.previewButton = MultiblockButtonStyles.createLargeSquare(previewX, previewY, this.exampleStructures.isEmpty() ? null : this.exampleStructures.get(0), this::onPreviewButtonPressed);
        this.previewButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.mbtool.preview_tooltip")));
        this.m_142416_((GuiEventListener)this.previewButton);
        int styleY = previewY + previewSize + 20;
        this.selectedStructureButton = this.createStyledButton(previewX, styleY, this.currentStyleIndex);
        this.m_142416_((GuiEventListener)this.selectedStructureButton);
        this.styleToggleButton = Button.m_253074_((Component)Component.m_237110_((String)"gui.mbtool.style", (Object[])new Object[]{this.styleNames[this.currentStyleIndex]}), this::onStyleTogglePressed).m_252987_(previewX, styleY + 70, 120, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.styleToggleButton);
        this.closeButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), btn -> this.m_7379_()).m_252987_(this.f_96543_ - 80, this.f_96544_ - 30, 60, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.closeButton);
        if (!this.exampleStructures.isEmpty()) {
            this.structureGrid.setSelectedIndex(0);
            this.onStructureSelected(this.exampleStructures.get(0));
        }
    }

    private MultiblockButton createStyledButton(int x, int y, int styleIndex) {
        MultiblockStructure structure = this.structureGrid.getSelectedStructure();
        return switch (styleIndex) {
            case 0 -> MultiblockButtonStyles.createStandard(x, y, 120, 60, structure, this::onStyledButtonPressed);
            case 1 -> MultiblockButtonStyles.createDark(x, y, 120, 60, structure, this::onStyledButtonPressed);
            case 2 -> MultiblockButtonStyles.createLight(x, y, 120, 60, structure, this::onStyledButtonPressed);
            case 3 -> MultiblockButtonStyles.createBlueAccent(x, y, 120, 60, structure, this::onStyledButtonPressed);
            case 4 -> MultiblockButtonStyles.createGreenAccent(x, y, 120, 60, structure, this::onStyledButtonPressed);
            case 5 -> MultiblockButtonStyles.createTransparent(x, y, 120, 60, structure, this::onStyledButtonPressed);
            default -> MultiblockButtonStyles.createStandard(x, y, 120, 60, structure, this::onStyledButtonPressed);
        };
    }

    private void onStructureSelected(MultiblockStructure structure) {
        if (this.previewButton != null) {
            this.previewButton.setStructure(structure);
        }
        if (this.selectedStructureButton != null) {
            this.selectedStructureButton.setStructure(structure);
        }
    }

    private void onPreviewButtonPressed(MultiblockButton button) {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            String structureName = "Unknown";
            int selectedIndex = this.structureGrid.selectedIndex;
            if (selectedIndex >= 0 && selectedIndex < this.structureNames.size()) {
                structureName = this.structureNames.get(selectedIndex);
            }
            this.f_96541_.f_91074_.m_213846_((Component)Component.m_237110_((String)"gui.mbtool.preview_pressed", (Object[])new Object[]{structureName}));
        }
    }

    private void onStyledButtonPressed(MultiblockButton button) {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            this.f_96541_.f_91074_.m_213846_((Component)Component.m_237110_((String)"gui.mbtool.styled_button_pressed", (Object[])new Object[]{this.styleNames[this.currentStyleIndex]}));
        }
    }

    private void onStyleTogglePressed(Button button) {
        this.currentStyleIndex = (this.currentStyleIndex + 1) % this.styleNames.length;
        this.styleToggleButton.m_93666_((Component)Component.m_237110_((String)"gui.mbtool.style", (Object[])new Object[]{this.styleNames[this.currentStyleIndex]}));
        this.m_169411_((GuiEventListener)this.selectedStructureButton);
        this.selectedStructureButton = this.createStyledButton(this.selectedStructureButton.m_252754_(), this.selectedStructureButton.m_252907_(), this.currentStyleIndex);
        this.m_142416_((GuiEventListener)this.selectedStructureButton);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, 0xFFFFFF);
        guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"gui.mbtool.structure_gallery"), 20, 25, 0xFFFFFF);
        guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"gui.mbtool.preview"), 320, 25, 0xFFFFFF);
        guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"gui.mbtool.style_demo"), 320, 175, 0xFFFFFF);
        int selectedIndex = this.structureGrid.selectedIndex;
        if (selectedIndex >= 0 && selectedIndex < this.structureNames.size()) {
            String structureName = this.structureNames.get(selectedIndex);
            MultiblockStructure structure = this.exampleStructures.get(selectedIndex);
            MutableComponent info = Component.m_237110_((String)"gui.mbtool.selected_info", (Object[])new Object[]{structureName, structure.getWidth(), structure.getHeight(), structure.getDepth()});
            guiGraphics.m_280430_(this.f_96547_, (Component)info, 320, 140, 0xCCCCCC);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean m_7043_() {
        return false;
    }

    public void addStructure(MultiblockStructure structure, String name) {
        this.exampleStructures.add(structure);
        this.structureNames.add(name);
        if (this.structureGrid != null) {
            this.structureGrid.addStructure(structure, name, (Component)Component.m_237110_((String)"gui.mbtool.structure_description", (Object[])new Object[]{name}));
        }
    }

    public void clearStructures() {
        this.exampleStructures.clear();
        this.structureNames.clear();
        if (this.structureGrid != null) {
            this.structureGrid.clearStructures();
        }
    }
}

