/*
 * Decompiled with CFR 0.152.
 */
package igentuman.mbtool.client.gui;

import igentuman.mbtool.client.gui.MultiblockButton;
import igentuman.mbtool.client.gui.MultiblockButtonStyles;
import igentuman.mbtool.util.MultiblockStructure;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class MultiblockSelectionGrid
extends AbstractWidget {
    private final List<MultiblockStructureEntry> structures = new ArrayList<MultiblockStructureEntry>();
    private final List<MultiblockButton> buttons = new ArrayList<MultiblockButton>();
    private final Consumer<MultiblockStructure> onStructureSelected;
    private final int buttonSize;
    private final int spacing;
    private final int columns;
    public int selectedIndex = -1;

    public MultiblockSelectionGrid(int x, int y, int width, int height, Consumer<MultiblockStructure> onStructureSelected) {
        this(x, y, width, height, onStructureSelected, 64, 4, 4);
    }

    public MultiblockSelectionGrid(int x, int y, int width, int height, Consumer<MultiblockStructure> onStructureSelected, int buttonSize, int spacing, int columns) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.onStructureSelected = onStructureSelected;
        this.buttonSize = buttonSize;
        this.spacing = spacing;
        this.columns = columns;
    }

    public void addStructure(MultiblockStructure structure, String name, Component description) {
        this.structures.add(new MultiblockStructureEntry(structure, name, description));
        this.rebuildButtons();
    }

    public void clearStructures() {
        this.structures.clear();
        this.buttons.clear();
        this.selectedIndex = -1;
    }

    public MultiblockStructure getSelectedStructure() {
        if (this.selectedIndex >= 0 && this.selectedIndex < this.structures.size()) {
            return this.structures.get((int)this.selectedIndex).structure;
        }
        return null;
    }

    public void setSelectedIndex(int index) {
        if (index >= -1 && index < this.structures.size()) {
            this.selectedIndex = index;
            this.updateButtonStates();
        }
    }

    private void rebuildButtons() {
        this.buttons.clear();
        for (int i = 0; i < this.structures.size(); ++i) {
            MultiblockStructureEntry entry = this.structures.get(i);
            int row = i / this.columns;
            int col = i % this.columns;
            int buttonX = this.m_252754_() + col * (this.buttonSize + this.spacing);
            int buttonY = this.m_252907_() + row * (this.buttonSize + this.spacing);
            if (buttonX + this.buttonSize > this.m_252754_() + this.f_93618_ || buttonY + this.buttonSize > this.m_252907_() + this.f_93619_) continue;
            int finalI = i;
            MultiblockButton button = MultiblockButtonStyles.createStandard(buttonX, buttonY, this.buttonSize, this.buttonSize, entry.structure, btn -> this.onButtonPressed(finalI));
            button.m_257544_(Tooltip.m_257550_((Component)entry.description));
            this.buttons.add(button);
        }
        this.updateButtonStates();
    }

    private void onButtonPressed(int index) {
        this.setSelectedIndex(index);
        if (this.onStructureSelected != null && this.selectedIndex >= 0) {
            this.onStructureSelected.accept(this.structures.get((int)this.selectedIndex).structure);
        }
    }

    private void updateButtonStates() {
        for (int i = 0; i < this.buttons.size(); ++i) {
            MultiblockButton button = this.buttons.get(i);
            if (i == this.selectedIndex) {
                button.setBackgroundColors(-11890462, -10772238, -12943150);
                continue;
            }
            button.setBackgroundColors(-7631989, -6250336, -10461088);
        }
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.f_93624_) {
            return;
        }
        for (MultiblockButton button : this.buttons) {
            button.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }
        if (this.structures.isEmpty()) {
            MutableComponent emptyMessage = Component.m_237115_((String)"gui.mbtool.no_structures_available");
            int centerX = this.m_252754_() + this.f_93618_ / 2;
            int centerY = this.m_252907_() + this.f_93619_ / 2;
            guiGraphics.m_280653_(Minecraft.m_91087_().f_91062_, (Component)emptyMessage, centerX, centerY, 0x808080);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.f_93624_ || !this.f_93623_) {
            return false;
        }
        for (MultiblockButton btn : this.buttons) {
            if (!btn.m_6375_(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (!this.f_93624_ || !this.f_93623_) {
            return false;
        }
        for (MultiblockButton btn : this.buttons) {
            btn.m_6348_(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.f_93624_ || !this.f_93623_) {
            return false;
        }
        for (MultiblockButton btn : this.buttons) {
            btn.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
        return false;
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        if (this.selectedIndex >= 0 && this.selectedIndex < this.structures.size()) {
            MultiblockStructureEntry entry = this.structures.get(this.selectedIndex);
            narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)Component.m_237110_((String)"gui.mbtool.selected_structure", (Object[])new Object[]{entry.name}));
        } else {
            narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)Component.m_237115_((String)"gui.mbtool.structure_grid"));
        }
    }

    public int getStructureCount() {
        return this.structures.size();
    }

    public MultiblockStructure getStructure(int index) {
        if (index >= 0 && index < this.structures.size()) {
            return this.structures.get((int)index).structure;
        }
        return null;
    }

    public String getStructureName(int index) {
        if (index >= 0 && index < this.structures.size()) {
            return this.structures.get((int)index).name;
        }
        return "";
    }

    private static class MultiblockStructureEntry {
        final MultiblockStructure structure;
        final String name;
        final Component description;

        MultiblockStructureEntry(MultiblockStructure structure, String name, Component description) {
            this.structure = structure;
            this.name = name;
            this.description = description;
        }
    }
}

