/*
 * Decompiled with CFR 0.152.
 */
package igentuman.mbtool.client.screen;

import igentuman.mbtool.Mbtool;
import igentuman.mbtool.client.gui.MultiblockButton;
import igentuman.mbtool.client.screen.MultibuilderScreen;
import igentuman.mbtool.container.MultibuilderSelectStructureContainer;
import igentuman.mbtool.item.MultibuilderItem;
import igentuman.mbtool.util.MultiblockStructure;
import igentuman.mbtool.util.MultiblocksProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class MultibuilderSelectStructureScreen
extends AbstractContainerScreen<MultibuilderSelectStructureContainer> {
    private static final ResourceLocation TEXTURE = Mbtool.rl("textures/gui/container/mbtool.png");
    private final Screen previousScreen;
    private int currentPage = 0;
    private int pages = 1;
    private Button prevButton;
    private Button nextButton;
    private EditBox searchField;
    private static final int GRID_COLUMNS = 3;
    private static final int GRID_ROWS = 2;
    private static final int BUTTON_SIZE = 64;
    private static final int BUTTON_SPACING = 2;
    private static final int STRUCTURES_PER_PAGE = 6;
    private List<MultiblockStructure> allStructures = new ArrayList<MultiblockStructure>();
    private List<MultiblockStructure> filteredStructures = new ArrayList<MultiblockStructure>();
    private List<MultiblockButton> multiblockButtons = new ArrayList<MultiblockButton>();
    private String currentFilter = "";

    public MultibuilderSelectStructureScreen(MultibuilderSelectStructureContainer pMenu, Inventory pPlayerInventory, Component pTitle) {
        this(pMenu, pPlayerInventory, pTitle, null);
    }

    public MultibuilderSelectStructureScreen(MultibuilderSelectStructureContainer pMenu, Inventory pPlayerInventory, Component pTitle, Screen previousScreen) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        int gridWidth = 196;
        int gridHeight = 130;
        this.f_97726_ = Math.max(226, gridWidth + 10);
        this.f_97727_ = Math.max(186, gridHeight + 20);
        this.previousScreen = previousScreen;
        this.loadStructures();
    }

    protected void m_7856_() {
        super.m_7856_();
        int screenX = (this.f_96543_ - this.f_97726_) / 2;
        int screenY = (this.f_96544_ - this.f_97727_) / 2;
        this.multiblockButtons.clear();
        int searchFieldWidth = Math.min(200, this.f_97726_ - 80);
        int searchFieldX = screenX + (this.f_97726_ - searchFieldWidth) / 2;
        int searchFieldY = screenY + this.f_97727_ - 28;
        this.searchField = new EditBox(this.f_96547_, searchFieldX, searchFieldY, searchFieldWidth, 16, (Component)Component.m_237113_((String)"Search structures..."));
        this.searchField.m_257771_((Component)Component.m_237113_((String)"Search structures..."));
        this.searchField.m_94151_(this::onSearchChanged);
        this.searchField.m_93692_(true);
        this.m_142416_((GuiEventListener)this.searchField);
        int gridWidth = 196;
        int gridHeight = 130;
        int gridStartX = screenX + (this.f_97726_ - gridWidth) / 2;
        int gridStartY = screenY + 20;
        for (int row = 0; row < 2; ++row) {
            for (int col = 0; col < 3; ++col) {
                int buttonX = gridStartX + col * 66;
                int buttonY = gridStartY + row * 66;
                MultiblockButton button2 = MultiblockButton.builder().bounds(buttonX, buttonY, 64, 64).structure(null).container((MultibuilderSelectStructureContainer)this.m_6262_()).onPress(this::onMultiblockButtonPressed).build();
                this.multiblockButtons.add(button2);
                this.m_142416_((GuiEventListener)button2);
            }
        }
        this.prevButton = Button.m_253074_((Component)Component.m_237113_((String)"<"), button -> this.previousPage()).m_252987_(screenX + 10, screenY + this.f_97727_ - 30, 20, 20).m_253136_();
        this.nextButton = Button.m_253074_((Component)Component.m_237113_((String)">"), button -> this.nextPage()).m_252987_(screenX + this.f_97726_ - 30, screenY + this.f_97727_ - 30, 20, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.prevButton);
        this.m_142416_((GuiEventListener)this.nextButton);
        this.updateButtonStates();
        this.updateMultiblockButtons();
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        pGuiGraphics.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(pGuiGraphics);
        ArrayList<Tooltip> savedTooltips = new ArrayList<Tooltip>();
        for (MultiblockButton button : this.multiblockButtons) {
            savedTooltips.add(button.m_278622_());
            button.m_257544_(null);
        }
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        for (int i = 0; i < this.multiblockButtons.size(); ++i) {
            this.multiblockButtons.get(i).m_257544_((Tooltip)savedTooltips.get(i));
        }
        this.renderCustomTooltip(pGuiGraphics, pMouseX, pMouseY);
    }

    private void renderCustomTooltip(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        Tooltip tooltip;
        MultiblockButton hoveredButton = null;
        for (MultiblockButton button : this.multiblockButtons) {
            if (!button.m_5953_(pMouseX, pMouseY) || !button.f_93624_ || button.m_278622_() == null) continue;
            hoveredButton = button;
            break;
        }
        if (hoveredButton != null && (tooltip = hoveredButton.m_278622_()) != null) {
            boolean buttonInTopHalf;
            int screenCenterY = this.f_96544_ / 2;
            boolean bl = buttonInTopHalf = hoveredButton.m_252907_() < screenCenterY;
            if (buttonInTopHalf) {
                int tooltipX = pMouseX;
                int tooltipY = hoveredButton.m_252907_() + hoveredButton.m_93694_() + 5;
                tooltipY = Math.min(tooltipY, this.f_96544_ - 50);
                pGuiGraphics.m_280245_(this.f_96547_, tooltip.m_257408_(this.f_96541_), tooltipX, tooltipY);
            } else {
                int tooltipX = pMouseX;
                int tooltipY = hoveredButton.m_252907_() - 5;
                tooltipY = Math.max(tooltipY, 20);
                pGuiGraphics.m_280245_(this.f_96547_, tooltip.m_257408_(this.f_96541_), tooltipX, tooltipY);
            }
            return;
        }
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.searchField != null && this.searchField.m_93696_()) {
            if (this.searchField.m_7933_(pKeyCode, pScanCode, pModifiers)) {
                return true;
            }
            if (pKeyCode != 256) {
                return true;
            }
        }
        if (this.searchField != null && this.searchField.m_7933_(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_5534_(char pCodePoint, int pModifiers) {
        if (this.searchField != null && this.searchField.m_93696_()) {
            if (this.searchField.m_5534_(pCodePoint, pModifiers)) {
                return true;
            }
            return true;
        }
        if (this.searchField != null && this.searchField.m_5534_(pCodePoint, pModifiers)) {
            return true;
        }
        return super.m_5534_(pCodePoint, pModifiers);
    }

    protected void m_181908_() {
        super.m_181908_();
        if (this.searchField != null) {
            this.searchField.m_94120_();
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (this.searchField.m_6375_(pMouseX, pMouseY, pButton)) {
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    protected void m_280003_(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        FormattedCharSequence formattedcharsequence = this.f_96539_.m_7532_();
        graphics.m_280649_(this.f_96547_, formattedcharsequence, 110 - this.f_96547_.m_92724_(formattedcharsequence) / 2, 6, 0x404040, false);
    }

    private void previousPage() {
        if (this.currentPage > 0) {
            --this.currentPage;
            this.updateButtonStates();
            this.onPageChanged();
        }
    }

    private void nextPage() {
        if (this.currentPage < this.pages - 1) {
            ++this.currentPage;
            this.updateButtonStates();
            this.onPageChanged();
        }
    }

    private void updateButtonStates() {
        if (this.prevButton != null) {
            boolean bl = this.prevButton.f_93623_ = this.currentPage > 0;
        }
        if (this.nextButton != null) {
            this.nextButton.f_93623_ = this.currentPage < this.pages - 1;
        }
    }

    protected void onPageChanged() {
        this.updateMultiblockButtons();
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int page) {
        if (page >= 0 && page < this.pages) {
            this.currentPage = page;
            this.updateButtonStates();
            this.onPageChanged();
        }
    }

    public void setPages(int pages) {
        this.pages = Math.max(1, pages);
        if (this.currentPage >= this.pages) {
            this.currentPage = this.pages - 1;
        }
        this.updateButtonStates();
    }

    public void m_7379_() {
        if (this.previousScreen != null && this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.previousScreen);
        } else {
            super.m_7379_();
        }
    }

    private void loadStructures() {
        this.allStructures = MultiblocksProvider.getStructures();
        this.filteredStructures = new ArrayList<MultiblockStructure>(this.allStructures);
        this.updatePagination();
    }

    private void onSearchChanged(String searchText) {
        this.currentFilter = searchText.toLowerCase().trim();
        this.applyFilter();
    }

    private void applyFilter() {
        this.filteredStructures = this.currentFilter.isEmpty() ? new ArrayList<MultiblockStructure>(this.allStructures) : this.allStructures.stream().filter(structure -> structure.getName() != null && structure.getName().toLowerCase().contains(this.currentFilter)).collect(Collectors.toList());
        this.currentPage = 0;
        this.updatePagination();
        this.updateButtonStates();
        this.updateMultiblockButtons();
    }

    private void updatePagination() {
        this.pages = this.filteredStructures.isEmpty() ? 1 : (int)Math.ceil((double)this.filteredStructures.size() / 6.0);
        if (this.currentPage >= this.pages) {
            this.currentPage = 0;
        }
    }

    private void updateMultiblockButtons() {
        int startIndex = this.currentPage * 6;
        for (int i = 0; i < this.multiblockButtons.size(); ++i) {
            MultiblockButton button = this.multiblockButtons.get(i);
            int structureIndex = startIndex + i;
            if (structureIndex < this.filteredStructures.size()) {
                button.setStructure(this.filteredStructures.get(structureIndex));
                button.f_93624_ = true;
                button.f_93623_ = true;
                continue;
            }
            button.setStructure(null);
            button.f_93624_ = false;
            button.f_93623_ = false;
        }
    }

    private void onMultiblockButtonPressed(MultiblockButton button) {
        MultiblockStructure structure = button.getStructure();
        if (structure != null && this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            ItemStack multibuilderStack;
            int originalIndex = this.allStructures.indexOf(structure);
            int slot = ((MultibuilderSelectStructureContainer)this.f_97732_).getPlayerSlot();
            if (slot >= 0 && (multibuilderStack = slot == 40 ? this.f_96541_.f_91074_.m_21206_() : this.f_96541_.f_91074_.m_150109_().m_8020_(slot)).m_150930_((Item)Mbtool.MBTOOL.get())) {
                multibuilderStack.m_41784_().m_128405_("recipe", originalIndex);
                MultibuilderItem multibuilderItem = (MultibuilderItem)multibuilderStack.m_41720_();
                multibuilderItem.setRuntimeStructure(multibuilderStack, null);
            }
            if (this.previousScreen instanceof MultibuilderScreen) {
                ((MultibuilderScreen)this.previousScreen).selectedStructure = originalIndex;
            }
            this.m_7379_();
        }
    }
}

