/*
 * Decompiled with CFR 0.152.
 */
package igentuman.mbtool.config;

import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class MbtoolConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<Integer> MAX_ENERGY;
    public static final ForgeConfigSpec.ConfigValue<Integer> ENERGY_TRANSFER_RATE;
    public static final ForgeConfigSpec.ConfigValue<Integer> ENERGY_PER_BLOCK;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> BLOCK_EQUIVALENCY_SETS;

    public static void register() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SPEC, "mbtool-common.toml");
    }

    public static int getMaxEnergy() {
        return (Integer)MAX_ENERGY.get();
    }

    public static int getEnergyTransferRate() {
        return (Integer)ENERGY_TRANSFER_RATE.get();
    }

    public static int getEnergyPerBlock() {
        return (Integer)ENERGY_PER_BLOCK.get();
    }

    public static List<? extends String> getBlockEquivalencySets() {
        return (List)BLOCK_EQUIVALENCY_SETS.get();
    }

    static {
        BUILDER.push("Energy Settings");
        MAX_ENERGY = BUILDER.comment("Maximum energy capacity of the Multibuilder Tool (in FE)").defineInRange("maxEnergy", 10000000, 100000, 100000000);
        ENERGY_TRANSFER_RATE = BUILDER.comment("Energy transfer rate for charging/discharging (in FE/tick)").defineInRange("energyTransferRate", 100000, 10000, 1000000);
        ENERGY_PER_BLOCK = BUILDER.comment("Energy cost per block placed (in FE)").defineInRange("energyPerBlock", 100, 1, 10000);
        BUILDER.pop();
        BUILDER.push("Block Replacement Settings");
        BLOCK_EQUIVALENCY_SETS = BUILDER.comment(new String[]{"Define sets of equivalent blocks that can be used as replacements.", "Each line represents a set of equivalent blocks separated by commas.", "Example: 'mekanism:basic_mechanical_pipe,mekanism:advanced_mechanical_pipe,mekanism:elite_mechanical_pipe'", "If a structure requires 'elite_mechanical_pipe' but you only have 'basic_mechanical_pipe',", "the builder will use the basic pipe as a replacement."}).defineList("blockEquivalencySets", Arrays.asList("mekanism:basic_mechanical_pipe,mekanism:advanced_mechanical_pipe,mekanism:elite_mechanical_pipe,mekanism:ultimate_mechanical_pipe"), obj -> obj instanceof String);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

