/*
 * Decompiled with CFR 0.152.
 */
package igentuman.mbtool.integration.jei;

import igentuman.mbtool.Mbtool;
import igentuman.mbtool.integration.jei.MultiblockStructureCategory;
import igentuman.mbtool.integration.jei.MultiblockStructureRecipe;
import igentuman.mbtool.util.MultiblocksProvider;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private IIngredientManager ingredientManager;

    public ResourceLocation getPluginUid() {
        return Mbtool.rl("jei_plugin");
    }

    public void registerCategories(@NotNull IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new MultiblockStructureCategory(registration.getJeiHelpers().getGuiHelper())});
        this.ingredientManager = registration.getJeiHelpers().getIngredientManager();
    }

    public void registerRecipes(IRecipeRegistration registration) {
        List<MultiblockStructureRecipe> multiblockRecipes = this.loadMultiblockStructures();
        registration.addRecipes(MultiblockStructureCategory.TYPE, multiblockRecipes);
    }

    private List<MultiblockStructureRecipe> loadMultiblockStructures() {
        return MultiblocksProvider.getStructures().stream().map(structure -> new MultiblockStructureRecipe(structure.getId(), structure.getStructureNbt(), structure.getName(), this.ingredientManager)).toList();
    }
}

