/*
 * Decompiled with CFR 0.152.
 */
package igentuman.mbtool.integration.nc;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import igentuman.mbtool.Mbtool;
import igentuman.mbtool.util.MultiblockStructure;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class ReactorDesignParser {
    public static String resolvePath(String input) throws Exception {
        if (input.startsWith("file://")) {
            return Paths.get(new URI(input)).toAbsolutePath().toString();
        }
        return Paths.get(input, new String[0]).toAbsolutePath().toString();
    }

    private static JsonElement loadFromUrl(String urlString) throws Exception {
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setConnectTimeout(10000);
        connection.setReadTimeout(30000);
        connection.setRequestProperty("User-Agent", "MultiBuilderTool/1.0");
        int responseCode = connection.getResponseCode();
        if (responseCode != 200) {
            throw new Exception("HTTP " + responseCode + ": " + connection.getResponseMessage());
        }
        StringBuilder response = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                response.append(line).append('\n');
            }
        }
        connection.disconnect();
        return JsonParser.parseString((String)response.toString());
    }

    public static MultiblockStructure parseNuclearCraftReactorDesign(String input) {
        JsonElement jsonElement = null;
        if (input.startsWith("http://") || input.startsWith("https://")) {
            try {
                jsonElement = ReactorDesignParser.loadFromUrl(input);
            }
            catch (Exception e) {
                System.err.println("Failed to load from URL: " + e.getMessage());
            }
        } else {
            String resolvedPath = input;
            try {
                resolvedPath = ReactorDesignParser.resolvePath(input);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                jsonElement = JsonParser.parseReader((Reader)new FileReader(resolvedPath));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        try {
            int z;
            int y;
            int x;
            JsonObject positionObject;
            JsonElement positionsElement;
            String componentType;
            JsonObject jsonObject;
            if (jsonElement == null) {
                jsonElement = JsonParser.parseString((String)input);
            }
            if (!(jsonObject = jsonElement.getAsJsonObject()).has("CompressedReactor")) {
                return null;
            }
            JsonObject compressedReactor = jsonObject.getAsJsonObject("CompressedReactor");
            CompoundTag nbt = new CompoundTag();
            ListTag blocksList = new ListTag();
            ListTag palette = new ListTag();
            HashMap<String, Integer> paletteMap = new HashMap<String, Integer>();
            AtomicInteger paletteIndex = new AtomicInteger(0);
            int minX = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int minY = Integer.MAX_VALUE;
            int maxY = Integer.MIN_VALUE;
            int minZ = Integer.MAX_VALUE;
            int maxZ = Integer.MIN_VALUE;
            boolean hasCasing = false;
            for (Map.Entry entry : compressedReactor.entrySet()) {
                componentType = (String)entry.getKey();
                positionsElement = (JsonElement)entry.getValue();
                if (!positionsElement.isJsonArray()) continue;
                if (componentType.toLowerCase().contains("casing") || componentType.toLowerCase().contains("glass")) {
                    // empty if block
                }
                for (JsonElement posObj : positionsElement.getAsJsonArray()) {
                    positionObject = posObj.getAsJsonObject();
                    x = positionObject.get("X").getAsInt();
                    y = positionObject.get("Y").getAsInt();
                    z = positionObject.get("Z").getAsInt();
                    minX = Math.min(minX, x);
                    maxX = Math.max(maxX, x);
                    minY = Math.min(minY, y);
                    maxY = Math.max(maxY, y);
                    minZ = Math.min(minZ, z);
                    maxZ = Math.max(maxZ, z);
                }
            }
            if (!hasCasing) {
                ReactorDesignParser.addReactorWrapper(blocksList, palette, paletteMap, paletteIndex, --minX, ++maxX, --minY, ++maxY, --minZ, ++maxZ);
            }
            for (Map.Entry entry : compressedReactor.entrySet()) {
                componentType = (String)entry.getKey();
                positionsElement = (JsonElement)entry.getValue();
                if (!positionsElement.isJsonArray()) continue;
                for (JsonElement posObj : positionsElement.getAsJsonArray()) {
                    positionObject = posObj.getAsJsonObject();
                    x = positionObject.get("X").getAsInt();
                    y = positionObject.get("Y").getAsInt();
                    z = positionObject.get("Z").getAsInt();
                    String blockName = ReactorDesignParser.getBlockNameFromComponent(componentType.toLowerCase());
                    ReactorDesignParser.addBlockToStructure(blocksList, palette, paletteMap, x, y, z, blockName, paletteIndex);
                }
            }
            nbt.m_128365_("blocks", (Tag)blocksList);
            nbt.m_128365_("palette", (Tag)palette);
            return new MultiblockStructure(Mbtool.rl("runtime_reactor"), nbt, "nuclearcraft_reactor");
        }
        catch (JsonSyntaxException e) {
            System.err.println("Invalid JSON syntax in reactor design: " + e.getMessage());
            return null;
        }
        catch (Exception e) {
            System.err.println("Error parsing reactor design: " + e.getMessage());
            return null;
        }
    }

    private static String getBlockNameFromComponent(String componentType) {
        switch (componentType) {
            case "transparentcasing": {
                return "nuclearcraft:fission_reactor_glass";
            }
            case "fuelcell": {
                return "nuclearcraft:fission_reactor_solid_fuel_cell";
            }
            case "water": {
                return "nuclearcraft:water_heat_sink";
            }
            case "redstone": {
                return "nuclearcraft:redstone_heat_sink";
            }
            case "quartz": {
                return "nuclearcraft:quartz_heat_sink";
            }
            case "obsidian": {
                return "nuclearcraft:obsidian_heat_sink";
            }
            case "nether_brick": {
                return "nuclearcraft:nether_brick_heat_sink";
            }
            case "glowstone": {
                return "nuclearcraft:glowstone_heat_sink";
            }
            case "lapis": {
                return "nuclearcraft:lapis_heat_sink";
            }
            case "gold": {
                return "nuclearcraft:gold_heat_sink";
            }
            case "prismarine": {
                return "nuclearcraft:prismarine_heat_sink";
            }
            case "slime": {
                return "nuclearcraft:slime_heat_sink";
            }
            case "end_stone": {
                return "nuclearcraft:end_stone_heat_sink";
            }
            case "purpur": {
                return "nuclearcraft:purpur_heat_sink";
            }
            case "diamond": {
                return "nuclearcraft:diamond_heat_sink";
            }
            case "emerald": {
                return "nuclearcraft:emerald_heat_sink";
            }
            case "copper": {
                return "nuclearcraft:copper_heat_sink";
            }
            case "tin": {
                return "nuclearcraft:tin_heat_sink";
            }
            case "lead": {
                return "nuclearcraft:lead_heat_sink";
            }
            case "boron": {
                return "nuclearcraft:boron_heat_sink";
            }
            case "lithium": {
                return "nuclearcraft:lithium_heat_sink";
            }
            case "magnesium": {
                return "nuclearcraft:magnesium_heat_sink";
            }
            case "manganese": {
                return "nuclearcraft:manganese_heat_sink";
            }
            case "aluminum": {
                return "nuclearcraft:aluminum_heat_sink";
            }
            case "silver": {
                return "nuclearcraft:silver_heat_sink";
            }
            case "fluorite": {
                return "nuclearcraft:fluorite_heat_sink";
            }
            case "villiaumite": {
                return "nuclearcraft:villiaumite_heat_sink";
            }
            case "carobbiite": {
                return "nuclearcraft:carobbiite_heat_sink";
            }
            case "arsenic": {
                return "nuclearcraft:arsenic_heat_sink";
            }
            case "liquid_helium": {
                return "nuclearcraft:liquid_helium_heat_sink";
            }
            case "liquid_nitrogen": {
                return "nuclearcraft:liquid_nitrogen_heat_sink";
            }
            case "liquid_neon": {
                return "nuclearcraft:liquid_neon_heat_sink";
            }
            case "liquid_argon": {
                return "nuclearcraft:liquid_argon_heat_sink";
            }
            case "liquid_krypton": {
                return "nuclearcraft:liquid_krypton_heat_sink";
            }
            case "liquid_xenon": {
                return "nuclearcraft:liquid_xenon_heat_sink";
            }
            case "liquid_radon": {
                return "nuclearcraft:liquid_radon_heat_sink";
            }
            case "enderium": {
                return "nuclearcraft:enderium_heat_sink";
            }
            case "cryotheum": {
                return "nuclearcraft:cryotheum_heat_sink";
            }
            case "iron": {
                return "nuclearcraft:iron_heat_sink";
            }
            case "moderator": {
                return "nuclearcraft:fission_reactor_moderator";
            }
            case "reflector": {
                return "nuclearcraft:fission_reactor_reflector";
            }
        }
        return "minecraft:air";
    }

    private static void addReactorWrapper(ListTag blocksList, ListTag palette, Map<String, Integer> paletteMap, AtomicInteger paletteIndex, int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    boolean isOnBoundary;
                    boolean bl = isOnBoundary = x == minX || x == maxX || y == minY || y == maxY || z == minZ || z == maxZ;
                    if (!isOnBoundary) continue;
                    int faceCount = 0;
                    if (x == minX || x == maxX) {
                        ++faceCount;
                    }
                    if (y == minY || y == maxY) {
                        ++faceCount;
                    }
                    if (z == minZ || z == maxZ) {
                        ++faceCount;
                    }
                    String blockName = faceCount >= 2 ? "nuclearcraft:fission_reactor_casing" : "nuclearcraft:fission_reactor_glass";
                    ReactorDesignParser.addBlockToStructure(blocksList, palette, paletteMap, x, y, z, blockName, paletteIndex);
                }
            }
        }
    }

    private static void addBlockToStructure(ListTag blocksList, ListTag palette, Map<String, Integer> paletteMap, int x, int y, int z, String blockName, AtomicInteger paletteIndex) {
        if (!paletteMap.containsKey(blockName)) {
            CompoundTag paletteEntry = new CompoundTag();
            paletteEntry.m_128359_("Name", blockName);
            palette.add((Object)paletteEntry);
            paletteMap.put(blockName, paletteIndex.getAndIncrement());
        }
        CompoundTag blockEntry = new CompoundTag();
        ListTag pos = new ListTag();
        pos.add((Object)IntTag.m_128679_((int)x));
        pos.add((Object)IntTag.m_128679_((int)y));
        pos.add((Object)IntTag.m_128679_((int)z));
        blockEntry.m_128365_("pos", (Tag)pos);
        blockEntry.m_128405_("state", paletteMap.get(blockName).intValue());
        blocksList.add((Object)blockEntry);
    }
}

