/*
 * Decompiled with CFR 0.152.
 */
package igentuman.mbtool.network;

import igentuman.mbtool.item.MultibuilderItem;
import igentuman.mbtool.util.PlacedStructure;
import igentuman.mbtool.util.PlacedStructuresManager;
import igentuman.mbtool.util.StructureDismantler;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class DismantleStructurePacket {
    private final BlockPos targetPos;
    private final InteractionHand hand;

    public DismantleStructurePacket(BlockPos targetPos, InteractionHand hand) {
        this.targetPos = targetPos;
        this.hand = hand;
    }

    public static void encode(DismantleStructurePacket packet, FriendlyByteBuf buffer) {
        buffer.m_130064_(packet.targetPos);
        buffer.m_130068_((Enum)packet.hand);
    }

    public static DismantleStructurePacket decode(FriendlyByteBuf buffer) {
        BlockPos targetPos = buffer.m_130135_();
        InteractionHand hand = (InteractionHand)buffer.m_130066_(InteractionHand.class);
        return new DismantleStructurePacket(targetPos, hand);
    }

    public static void handle(DismantleStructurePacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            ItemStack itemStack = player.m_21120_(packet.hand);
            if (!(itemStack.m_41720_() instanceof MultibuilderItem)) {
                return;
            }
            PlacedStructure structure = PlacedStructuresManager.findStructureAt(itemStack, packet.targetPos);
            if (structure == null) {
                player.m_213846_((Component)Component.m_237115_((String)"message.mbtool.no_structure_found"));
                return;
            }
            if (!structure.getPlacedBy().equals(player.m_20148_()) && !player.m_7500_()) {
                player.m_213846_((Component)Component.m_237115_((String)"message.mbtool.not_your_structure"));
                return;
            }
            StructureDismantler.DismantleResult result = StructureDismantler.dismantleStructure(player.m_9236_(), (Player)player, itemStack, structure);
            player.m_213846_(result.getMessage());
            if (result.isSuccess()) {
                PlacedStructuresManager.removePlacedStructure(itemStack, structure);
            }
        });
        context.setPacketHandled(true);
    }
}

