/*
 * Decompiled with CFR 0.152.
 */
package igentuman.mbtool.network;

import igentuman.mbtool.item.MultibuilderItem;
import igentuman.mbtool.util.MultiblockBuilder;
import igentuman.mbtool.util.MultiblockStructure;
import igentuman.mbtool.util.MultiblocksProvider;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class SyncMultibuilderParamsPacket {
    private final int recipeIndex;
    private final int rotation;
    private final InteractionHand hand;

    public SyncMultibuilderParamsPacket(int recipeIndex, int rotation, InteractionHand hand) {
        this.recipeIndex = recipeIndex;
        this.rotation = rotation;
        this.hand = hand;
    }

    public static void encode(SyncMultibuilderParamsPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.recipeIndex);
        buffer.writeInt(packet.rotation);
        buffer.m_130068_((Enum)packet.hand);
    }

    public static SyncMultibuilderParamsPacket decode(FriendlyByteBuf buffer) {
        int recipeIndex = buffer.readInt();
        int rotation = buffer.readInt();
        InteractionHand hand = (InteractionHand)buffer.m_130066_(InteractionHand.class);
        return new SyncMultibuilderParamsPacket(recipeIndex, rotation, hand);
    }

    public static void handle(SyncMultibuilderParamsPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            ItemStack itemStack = player.m_21120_(packet.hand);
            Item patt2054$temp = itemStack.m_41720_();
            if (!(patt2054$temp instanceof MultibuilderItem)) {
                return;
            }
            MultibuilderItem multibuilderItem = (MultibuilderItem)patt2054$temp;
            itemStack.m_41784_().m_128405_("recipe", packet.recipeIndex);
            itemStack.m_41784_().m_128405_("rotation", packet.rotation);
            if (MultiblocksProvider.structures.isEmpty()) {
                MultiblocksProvider.getStructures();
            }
            if (packet.recipeIndex < 0 || packet.recipeIndex >= MultiblocksProvider.structures.size()) {
                player.m_213846_((Component)Component.m_237115_((String)"message.mbtool.invalid_recipe"));
                return;
            }
            MultiblockStructure structure = MultiblocksProvider.structures.get(packet.recipeIndex);
            if (structure == null) {
                player.m_213846_((Component)Component.m_237115_((String)"message.mbtool.invalid_recipe"));
                return;
            }
            BlockPos buildPos = SyncMultibuilderParamsPacket.getBuildPosition(player, structure, packet.rotation);
            if (buildPos == null) {
                player.m_213846_((Component)Component.m_237115_((String)"message.mbtool.no_build_position"));
                return;
            }
            MultiblockBuilder.BuildResult result = MultiblockBuilder.buildMultiblock(player.m_9236_(), (Player)player, itemStack, structure, buildPos, packet.rotation);
            player.m_213846_(result.getMessage());
        });
        context.setPacketHandled(true);
    }

    private static BlockPos getBuildPosition(ServerPlayer player, MultiblockStructure structure, int rotation) {
        if (player == null || player.m_9236_() == null) {
            return null;
        }
        Vec3 eyePos = player.m_20299_(1.0f);
        Vec3 lookVec = player.m_20252_(1.0f);
        Vec3 endPos = eyePos.m_82549_(lookVec.m_82490_(32.0));
        BlockHitResult rayTrace = player.m_9236_().m_45547_(new ClipContext(eyePos, endPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        if (rayTrace.m_6662_() != HitResult.Type.BLOCK) {
            return null;
        }
        BlockPos hit = rayTrace.m_82425_();
        BlockState state = player.m_9236_().m_8055_(hit);
        Direction hitSide = rayTrace.m_82434_();
        switch (hitSide) {
            case DOWN: {
                if (!state.m_247087_()) {
                    hit = hit.m_7918_(0, -structure.getHeight(), 0);
                }
                if (rotation == 0 || rotation == 2) {
                    hit = hit.m_7918_(-structure.getWidth() / 2, 0, -structure.getDepth() / 2);
                    break;
                }
                hit = hit.m_7918_(-structure.getDepth() / 2, 0, -structure.getWidth() / 2);
                break;
            }
            case UP: {
                hit = hit.m_7918_(0, 1, 0);
                if (rotation == 0 || rotation == 2) {
                    hit = hit.m_7918_(-structure.getWidth() / 2, 0, -structure.getDepth() / 2);
                    break;
                }
                hit = hit.m_7918_(-structure.getDepth() / 2, 0, -structure.getWidth() / 2);
                break;
            }
            case EAST: {
                if (!state.m_247087_()) {
                    hit = hit.m_7918_(1, 0, 0);
                }
                if (rotation == 0 || rotation == 2) {
                    hit = hit.m_7918_(0, -structure.getHeight() / 2, -structure.getDepth() / 2);
                    break;
                }
                hit = hit.m_7918_(0, -structure.getHeight() / 2, -structure.getWidth() / 2);
                break;
            }
            case WEST: {
                if (!state.m_247087_()) {
                    hit = hit.m_7918_(-1, 0, 0);
                }
                if (rotation == 0 || rotation == 2) {
                    hit = hit.m_7918_(-structure.getWidth() + 1, -structure.getHeight() / 2, -structure.getDepth() / 2);
                    break;
                }
                hit = hit.m_7918_(-structure.getDepth() + 1, -structure.getHeight() / 2, -structure.getWidth() / 2);
                break;
            }
            case NORTH: {
                if (!state.m_247087_()) {
                    hit = hit.m_7918_(0, 0, -1);
                }
                if (rotation == 0 || rotation == 2) {
                    hit = hit.m_7918_(-structure.getWidth() / 2, -structure.getHeight() / 2, -structure.getDepth() + 1);
                    break;
                }
                hit = hit.m_7918_(-structure.getDepth() / 2, -structure.getHeight() / 2, -structure.getWidth() + 1);
                break;
            }
            case SOUTH: {
                if (!state.m_247087_()) {
                    hit = hit.m_7918_(0, 0, 1);
                }
                hit = rotation == 0 || rotation == 2 ? hit.m_7918_(-structure.getWidth() / 2, -structure.getHeight() / 2, 0) : hit.m_7918_(-structure.getDepth() / 2, -structure.getHeight() / 2, 0);
            }
        }
        return hit;
    }
}

